unit RegisterFileType;


interface

procedure pRegisterFileType(prefix: String; exePfad: String );
procedure DeregisterFileType(prefix: String);

implementation
uses  Windows,Registry,shlobj;

procedure pRegisterFileType(prefix: String; exePfad: String );
var
  reg:TRegistry;
begin
  reg:=TRegistry.Create;
  reg.RootKey:=HKEY_CLASSES_ROOT;
  try
  begin
    //create a new key  --> .pci
    if reg.OpenKey('.'+prefix,True) then
    begin
    //create a new value for this key --> pcifile
       reg.WriteString('',prefix+'file');
       reg.CloseKey;
    end;
    //create a new key --> pcifile
    if reg.CreateKey(prefix+'file') then
      //create a new key pcifile\DefaultIcon
          if reg.OpenKey(prefix+'file\DefaultIcon',True) then
          begin
             //and create a value where the icon is stored --> c:\project1.exe,0
             reg.WriteString('',exepfad+',0');
             reg.CloseKey;
          end;
    if reg.OpenKey(prefix+'file\shell\open\command',True) then
       begin
          //create value where exefile is stored --> c:\project1.exe "%1"
          reg.WriteString('',exepfad+' "%1"');
          reg.CloseKey;
       end;
  end;
  finally reg.Free; end; // try .. finally
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;


procedure DeregisterFileType(prefix: String);
var
  reg:TRegistry;
begin
  reg:=TRegistry.Create;
  reg.RootKey:=HKEY_CLASSES_ROOT;
  //create a new key  --> .pci
  reg.DeleteKey ('.'+prefix);
  //create a new value for this key --> pcifile
  //reg.WriteString('',prefix+'file');
  //reg.CloseKey;
  //create a new key --> pcifile
  reg.DeleteKey(prefix+'file');
  //create a new key pcifile\DefaultIcon
  //reg.OpenKey(prefix+'file\DefaultIcon',True);
  //and create a value where the icon is stored --> c:\project1.exe,0
  //reg.WriteString('',exepfad+',0');
  //reg.CloseKey;
  //reg.OpenKey(prefix+'file\shell\open\command',True);
  //create value where exefile is stored --> c:\project1.exe "%1"
  //reg.WriteString('',exepfad+' "%1"');
  //reg.CloseKey;
  reg.Free;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;



end.
 