unit UInterpreter;

interface
uses  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
      Dialogs, StdCtrls, ExtCtrls, UScanner, UVariablen, UDaten, UKlassen,
      UConstants, UFehler;

type
TInterpreter = class (TObject)
public
   vs: TVarSpace;

   klassenfabrik: TKlassenFabrik;
   sc: TScanner;
   stack: TStack;
   fensterliste: TList; // Mit TFenstern drin

   count: Integer;

   Fehler: Boolean;
   Fehlercode: TFehler;

   Verschachtelungstiefe: integer;
   FuerObjekt: TObjekt;

   StandardFenster: TFenster;

   procedure findeMethoden;
   procedure Methodenparameter(m: TMethode); // Liest die Parameter ein

   function schritt(einzelschritt: Boolean; Var OStopWarDa: Boolean): Boolean;
   procedure error(s: String);
   procedure zeichneAlleFenster;
   // Hier kommen die Strukturen
   procedure Wiederhole;
   procedure SternWiederhole;
   procedure Solange;
   procedure SternSolange;
   procedure wenn;
   procedure sonst;
   procedure SternWenn;
   procedure vdeklAttributMethode(pos:integer);
   procedure variablendeklaration;
   function methodenaufruf(m: TMethode): TVariant;
   procedure getparameter(p: TParameter); // wird von Methodenaufruf gebraucht,
     // wenn eine selbstgeschriebene Methode aufgerufen wurde.
   procedure zuweisung(v: TVariant);
   procedure setzeMethode(m: TMethode);
   // AttributMethode Untersucht ganze Variablen, z.B. r1.Pinsel.farbe
   // Wenn es sich um ein Attribut handelt, wird das entsprechende TAttribut-
   // Objekt zurckgegeben. Handelt es sich um eine Methode, so wird sie aufgerufen.
   // Handelt es sich um eine Methode mit Rckgabewert, so wird sie aufgerufen und der Rckgabewert
   // auf den Stack gelegt.
   function AttributMethode(linkswertErwartet: Boolean): TVariant;
   procedure Blockueberlesen;
   procedure Fuer;
   procedure SternFuer;
   procedure Ende;
   procedure Methode; // selbstgeschriebene Methode berlesen!

   // Die folgenden Prozeduren hinterlassen auf dem Stack das
   // Ergebnis.
   procedure Term(vtGewuenscht: TVarType; ciGewuenscht: Integer);
   procedure AndOr;
   procedure Vergleich;
   procedure PlusMinus;
   procedure MalGeteilt;
   procedure Atom;
   procedure NotMinus;

   constructor create(sc: TScanner; Fensterautomatisch: Boolean);
   destructor destroy; override;
end;

implementation

uses UCriticalSections, UEinstellungen;


{ TInterpreter }

procedure TInterpreter.AndOr;
Var t: EToken;
    op1, op2, operg: Boolean;
begin
   if not Fehler then
   begin
     Vergleich; // Erstes Argument
     t := sc.TRead;
     while t in [OAnd, OOr] do
     begin
        if stack.Typ <> vtBoolean then error('Vor And/Or wird ein boolescher Wert erwartet.')
        else begin
          Vergleich; // Zweites Argument
          if stack.Typ <> vtBoolean then error('Nach And/Or wird ein boolescher Wert erwartet.')
          else begin
             op2 := stack.popBoolean;
             op1 := stack.popBoolean;
             case t of
             OAnd: operg := op1 and op2;
             OOr: operg := op1 or op2;
             else operg := false;
             end;
             stack.pushBoolean(operg);
          end; // if stack.Typ = vtBoolean (2. Operand)
        end; // if stack.Typ = vtBoolean  (1. Operand)
     t := sc.TRead;
     end;  // while t in [OAnd, OOr]
     sc.Back;
   end;
end;   // AndOr

procedure TInterpreter.Atom;
Var t: EToken;
begin
   if not Fehler then
   begin
     t := sc.TRead;
     case t of
     Otrue: stack.pushBoolean(true);
     Ofalse: stack.pushBoolean(false);
     OIntegerconst: stack.pushInteger(sc.IntWert);
     ORealconst: stack.pushDouble(sc.RealWert);
     OStringConst: stack.pushString(sc.Text);
     OKlammAuf: begin
                   AndOr;
                   t := sc.TRead;
                   if t <> OKlammZu then error (' ) erwartet.');
                end;
     OIdentifier: begin
                     sc.Back;
                     AttributMethode(false); // kein Linkswert erwartet!
                  end;
     OZahlenfehler: error (sc.Stringgelesen + ' ist keine zulssige Zahl.');
     else error (sc.Stringgelesen + ' macht hier keinen Sinn.');
     end; // case
   end;
end;

function TInterpreter.AttributMethode(linkswertErwartet: Boolean): TVariant;
var v: TVariant;
    a: TAttribut;
    m: TMethode;
    t: EToken;
    name: String;
begin
   a := nil; v := nil;m := nil;
   if not Fehler then
   begin
     t := sc.TRead; // Voraussetzung: Das ist ein OIdentifier!!!
     if t <> OIdentifier then error('Bezeichner erwartet.');
     // Zuerst nach Attributen/Methoden im Fuer-Objekt suchen
     if FuerObjekt <> nil then
     begin
        a := FuerObjekt.GetAttribut(sc.Text);
        if a <> nil then
        begin
           v := a.Wert;
        end else
        begin   // Suche nach Methode
           m := FuerObjekt.GetMethode(sc.Text);
           if m <> nil then
           begin
              v := methodenaufruf(m);
           end;
        end;
     end;

     if  (m = nil) and (a=nil) then
       begin
          // Gibt es eine Variable mit diesem Namen?
          v := vs.get(sc.Text);
          if v <> nil then
            begin
              if v.Typ = vtMethode then
              begin
                  m := v.m;
                  v := methodenaufruf(m);
              end;
            end
            else error ('Den Bezeichner '+sc.Text+' gibt es nicht.');
       end;

     if not Fehler then
     begin
       name := sc.Text; t := sc.TRead;
       while (t = OPunkt) and (not Fehler) do
       begin
          if (v = nil) and (m <> nil) then error('Die Methode ' + m.Name + 'gibt kein Objekt zurck')
          else
          begin
            m := nil;
            t := sc.TRead;
            if (v.Typ = vtObjekt) then
            begin
               if t = OIdentifier then
               begin
                   a := v.o.GetAttribut(sc.Text);
                   if a <> nil then v := a.wert
                   else
                   begin
                      m := v.o.GetMethode(sc.Text);
                      if m = nil then error(sc.text+ ' ist nicht der Name eines Attributs/einer Methode von ' + name)
                      else v := methodenaufruf(m)
                   end;
               end else error('Nach dem Punkt wird der Name einer Eigenschaft/Methode erwartet.');
            end else error(name + ' hat keine Eigenschaften/Methoden');
          end;
       t := sc.TRead;
       end; // while (t =OPunkt) and (not Fehler)
       sc.Back;

       if not Fehler then
       begin
          if not linkswertErwartet then // Ein Rechtswert wird erwartet => es muss was auf den Stack!!!
          begin  // Kein Linkswert erwartet => "Term"wert auf den Stack
             if (m <> nil) and (m.Rueckgabeparameter = nil) then error('Die Methode ' + m.Name + ' gibt nichts zurck.')
             else stack.pushVariant(v);
             // Wenn eine Methode kein Objekt zurckgibt, hat methodenaufruf das Ergebnis auf dem Stack belassen!
          end
          else if (v = nil) and (m = nil) then error ('Linkswert erwartet.');
       end; // if not Fehler
     end; // Bezeichner bekannt
   end;
   AttributMethode := v;
end;

procedure TInterpreter.Blockueberlesen;
Var n: integer; // Verschachtelungstiefe
    t: EToken;
begin
   // berliest einen ganzen Block, d.h. liest, bis es ein *wenn, *solange, ...
   // zuviel entdeckt hat.
   if not Fehler then
   begin
     n := 0;
     repeat
        t := sc.TRead;
        case t of
          OWiederhole, OSolange, OWenn: n := n + 1;
          OSternWiederhole, OSternsolange, OSternWenn: n := n - 1
        end;
     until (n = -1) or (sc.EndOfText);
     if sc.EndOfText then error('Programmende war erreicht, obwohl noch ein *wiederhole, *solange oder *wenn gefehlt hat.');
   end;
end;


constructor TInterpreter.create(sc: TScanner; Fensterautomatisch: Boolean);
var w: TVariant;
begin
   self.sc := sc;
   klassenfabrik := TKlassenFabrik.Create;
   vs := TVarSpace.create;
   stack := TSTack.create;
   Fehler := false; Fehlercode := nil;
   FensterListe := TList.Create;
   verschachtelungstiefe := 0;
   FuerObjekt := nil;

   if FensterAutomatisch then
   begin
      Standardfenster := TFenster.create('',nil,false);
      w := TVariant.create(Standardfenster);
      vs.add('',w,true,false);
      Fensterliste.Add(Standardfenster);
   end else StandardFenster := nil;

   findeMethoden;
   if Fehler then
   begin
      Fehlerverwaltung.add(Fehlercode);
      Fehlerverwaltung.ListBoxAktualisieren;
   end;
end;

destructor TInterpreter.destroy;
Var i: integer;
begin
  klassenfabrik.Free;
  try
    EnterCriticalSection(CriticalSectionPaint);
    for i := 0 to fensterliste.Count -1 do
       TFenster(fensterliste.Items[i]).form.Zeichnenerlaubt := false;
  finally LeaveCriticalSection(CriticalSectionPaint); end;
    for i := 0 to fensterliste.Count -1 do
    begin
       TFenster(fensterliste.Items[i]).form.Close;
       TFenster(fensterliste.Items[i]).form.Release;
    end;
  FensterListe.Free;
  try
     EnterCriticalSection(CriticalSectionPaint);
     vs.Free;
  finally LeaveCriticalSection(CriticalSectionPaint); end;
  Stack.Free;
  inherited;
end;

procedure TInterpreter.Ende;
begin
   if Stack.popAblaufSteuerung <> asReturnto then error('Stack-Fehler')
   else
     begin
      sc.SetPos(stack.popInteger);
      vs.ClearKontext; // lokale Variablen aufrumen
     end;
end;

procedure TInterpreter.error(s: String);
Var Zeile, Spalte: integer;
begin
   if (s <> '') and not Fehler then
   begin
      sc.back;
      if Fehlercode <> nil then Fehlercode.Free;
      sc.getZeileSpalte(Zeile, Spalte);
      Fehlercode := TFehler.Create(Zeile, Spalte,1,0,s);
      Fehler := true;
   end;
   if s = '' then
   begin
      Fehlercode.Free; Fehlercode := nil;
      Fehler := false;
   end;
end;

procedure TInterpreter.findeMethoden;
Var t: EToken;
    v: TVariant;
    pos: integer;
    m: TMethode;
    name: string;
begin
   m := nil;
   repeat
      t := sc.TRead;
      if t = OMethode then
      begin
         if sc.TRead = OIdentifier then
         begin
           pos := sc.getPos;
           name := sc.text;
           m := TMethode.create(pos);
           m.Name := name;
           v := TVariant.create(m);
           vs.add(name,v,false,false);
         end else error('Nach Methode wird der Name der Methode erwartet.');
         if not Fehler then
         begin
            t := sc.TRead;
            if t = OKlammAuf then // Parameter einlesen
            begin
               t := sc.TRead;
               if t <> OKlammZu then
               begin
                 sc.back;
                 repeat
                 Methodenparameter(m);
                 t := sc.TRead;
                 until t <> OStrichpunkt;
               end;
               if t <> OKlammzu then error(' ) erwartet');
               m.Einsprungadresse := sc.getPos;
            end;

            // Methodenrumpf berlesen
            if not Fehler then
            repeat
               t := sc.TRead;
            until (t = OEnde) or (t = OEOF);
            if t = OEOF then error('Die Methode ' + name + ' muss mit Ende abgechlossen werden.');
         end;
      end;
   until (t = OEOF) or Fehler;
   sc.SetPos(1);
end;

procedure TInterpreter.Fuer;
var v: TVariant;
begin
   if FuerObjekt <> nil then error('Fr - Blcke knnen nicht geschachtelt werden!');
   if not Fehler then
   begin
          v := AttributMethode(true);
          if v.Typ <> vtObjekt then error('Nach Fr wird ein Objekt erwaret!')
          else FuerObjekt := v.o;
   end; // if not Fehler
end;


// Beim Aufruf einer selbstgeschriebenen Methode mssen die bergebenen Parameter ausgewertet werden...
procedure TInterpreter.getparameter(p: TParameter);
var v: TVariant;
    typfalsch: boolean;
begin
   vs.NichtNeuerKontext := true;
   if p.Variablenparameter then
   begin
     v := AttributMethode(true);
     typfalsch := false;
     if v <> nil then
     begin
       if (v.Typ <> p.typ) then typfalsch := true;
       if (v.Typ = vtObjekt) then if v.o.ci <> p.ci then typfalsch := true;
       if typfalsch then error('Der fr ' + p.Name + 'bergebene Parameter hat nicht den richtigen Typ.')
       else
       begin
          vs.addlocal(p.Name,v,true,true);
       end;
     end;
   end
   else
   begin
     term(p.typ,p.ci);
     v := stack.pop;
     if not fehler then vs.addlocal(p.name,v,true,false);
   end;
   vs.NichtNeuerKontext := false;
end;

procedure TInterpreter.MalGeteilt;
Var t: EToken;
    op1i, op2i: integer;
    op1d, op2d: double;
    typ1, typ2, ergtyp: TVarType;
begin
   if not Fehler then
   begin
     op1i := 1; op2i := 1; op1d := 1; op2d := 1;
     NotMinus; // Erstes Argument
     t := sc.TRead;
     while t in [OMal, OGeteilt] do
     begin
        typ1 := stack.Typ;
        if not (Typ1 in [vtInteger, vtDouble]) then error('Vor Mal/Geteilt wird ein Integer- oder Double- Wert erwartet.')
        else begin
          NotMinus; // Zweites Argument
          typ2 := stack.Typ;
          if not (Typ2 in [vtInteger, vtDouble, vtString]) then error('Nach Vor Mal/Geteilt wird ein Integer- oder Double- Wert erwartet.')
          else begin
               if typ1 = vtDouble then
               begin
                  if typ2 = vtInteger then op2d := stack.popInteger else op2d := stack.popdouble;
                  op1d := stack.popdouble;
                  ergtyp := vtdouble;
               end
               else if typ2 = vtDouble then
               begin
                  op2d := stack.popdouble;
                  if typ1 = vtInteger then op1d := stack.popInteger else op1d := stack.popdouble;
                  ergtyp := vtdouble;
               end
               else
               begin // beide vtInteger
                  op2i := stack.popInteger; op1i := stack.popInteger; ergtyp := vtInteger;
               end;
             // ***********************
             // Jetzt wird gerechnet!!
             case ergtyp of
             vtDouble:
                begin
                  case t of
                  OMal: stack.pushDouble(op1d * op2d);
                  OGeteilt: stack.pushDouble(op1d / op2d);
                  end; // case
                end;
             vtInteger:
                begin
                  case t of
                  OMal: stack.pushInteger(op1i * op2i);
                  OGeteilt: stack.pushInteger(trunc(op1i / op2i));
                  end; // case
                end;
             end; // case ergtyp of
          end; // if Typ des 2. Operanden passt
        end; // if Typ des 1. Operanden passt
        t := sc.TRead;
     end;  // while t in [OMal, OGeteilt]
     sc.Back;
   end;
end;   // MalGeteilt

procedure TInterpreter.Methode;
var t: EToken;
begin
   if Verschachtelungstiefe > 0 then error('Methoden drfen nicht innerhalb von Wiederholungen/Bedingungen stehen.')
   else
   begin
     repeat
     t := sc.TRead
     until (t = OEnde) or (t = OEOF);
     if t = OEOF then error('Eine Methodendeklaration wurde nicht mit Ende beendet!');
   end;
end;

function TInterpreter.methodenaufruf(m: TMethode): TVariant;
Var i: integer;
    v: TVariant;
begin
  v := nil;
  // Speicher fr lokale Variablen abtrennen!
  if m.Typ = mtselbstgeschrieben then
  begin
    vs.NeuerKontext;
  end;
  if sc.TRead <> OKlammauf then error ('( erwartet.');
  if not Fehler then
  begin
    if m.parameter.Count > 0 then
    begin
       begin
         i := 0;
         while ( i <= m.parameter.Count - 1) and not Fehler do
         begin
            if m.Typ = mtselbstgeschrieben then
               getparameter(TParameter(m.parameter.items[i]))
               else term(TParameter(m.parameter.Items[i]).typ,TParameter(m.parameter.Items[i]).ci);
            if (i < m.parameter.Count -1 ) then
            begin
              if (sc.TRead <> OKomma) then error (', erwartet.');
            end;
         inc(i);
         end; // for i := 0 to m.parameter.count - 1
       end; // KLammerauf war da
    end;  // Parameter besorgen und ( erledigen !
    if (sc.TRead <> OKlammzu) then error(') erwartet');

    // Endlich: Methode aufrufen!
    if not Fehler then
    begin
      case m.Typ of
      mtSystem: m.MethodenProzedur(stack);  // Systemprozedur wie sin, cos,...
      mtObjektMethode:  m.Objekt.methodenaufruf(m.Nummer,stack);   // Methode eines Objekts
      mtSelbstgeschrieben: begin
                             Stack.pushInteger(sc.getPos);
                             Stack.pushAblaufSteuerung(asReturnTo);
                             sc.SetPos(m.Einsprungadresse);
                           end;
      mtSetzeMethode: begin
                         SetzeMethode(m);
                      end;
      end; // case;
      v := nil;
      if m.Rueckgabeparameter <> nil then
         v := stack.pop;
    end;
  end;
  methodenaufruf := v;
end;

procedure TInterpreter.Methodenparameter(m: TMethode);
Var t: EToken;
    sl: TStrings;
    VariablenParameter: Boolean;
    ci,i: integer;
    typ :TVarType;
begin
   begin
     sl := TStringList.Create;
     t := sc.TRead;
     if t = OVar then
     begin
        Variablenparameter := true; t := sc.TRead;
     end else Variablenparameter := false;
     if t = OIdentifier then
     begin
        while (t <> ODoppelpunkt) and  not Fehler do
        begin
           if  m.getparameter(sc.text) <> nil then error('Einen Parameter mit dem Namen ' + sc.text + ' gibt es schon.');
           for i := 0 to sl.Count -1 do
              if Myuppercase(sl.Strings[i]) = Myuppercase(sc.text) then error('Einen Parameter mit dem Namen ' + sc.text+ ' gibt es schon.');
           if not fehler then
           begin
             sl.Add(sc.Text);
             t := sc.TRead;
             if not (t in [OKomma, ODoppelpunkt]) then
                error('Komma oder Doppelpunkt erwartet.')
                else if t = OKomma then
                begin
                  t := sc.TRead;
                  if t <> OIdentifier then Error('Bezeichner erwartet');
                end;
           end;
        end; // While Bezeichner einlesen
        if not Fehler then
        begin
           t := sc.TRead;
           if not (t in [OIdentifier, OInteger, OReal, OChar, OBoolean, OString]) then
              error ('Parametertyp erwartet')
              else
              begin
                 if t = OIdentifier then
                 begin
                    if not VariablenParameter then
                    error('Objekte sind nur als Variablenparameter, nicht als Werteparameter zulssig.')
                    else
                    if not Klassenfabrik.gibtes(sc.Text) then error('Den Variablentyp/die Klasse '+sc.text+' gibt es nicht.')
                    else begin
                       for i := 0 to sl.Count -1 do
                       begin
                          ci := klassenfabrik.getci(sc.Text);
                          m.addvarparameter(sl.Strings[i],vtObjekt,ci,Variablenparameter);
                       end;
                    end;
                 end // t = OIdentifier
                 else begin // t in [OInteger, ODouble, OChar, OBoolean]
                    typ := vtkeiner;
                    for i := 0 to sl.Count -1 do
                    begin
                       case t of
                       OInteger: Typ := vtInteger;
                       OReal: Typ := vtDouble;
                       OChar: Typ := vtchar;
                       OBoolean: Typ := vtBoolean;
                       OSTring: Typ := vtSTring;
                       end; // case
                       m.addvarparameter(sl.Strings[i],typ,0,VariablenParameter);
                    end;
                 end;  //Variablentyp zuweisen
              end;  // Variablentyp einlesen
        end; // Kein Fehler beim Einlesen der Bezeichner
     end else Error('Bezeichner erwartet.');
     sl.Free;
   end;
end;

procedure TInterpreter.NotMinus;
Var t: EToken;
begin
   if not Fehler then
   begin
     t := sc.TRead;
     case t of
     OMinus:
       begin
          Atom;
          case stack.typ of
          vtInteger: stack.oberstesElement.i := stack.oberstesElement.i * (-1);
          vtDouble: stack.oberstesElement.d := stack.oberstesElement.d * (-1);
          else error('Nach "-" wird ein Integer- oder Double-Termwert erwartet.');
          end;
       end;
     ONot:
       begin
          Atom;
          if stack.Typ <> vtBoolean then error('Nach not wird ein boolescher Wert erwartet.')
          else begin
             stack.oberstesElement.b := not stack.oberstesElement.b;
          end;
       end;
     else
        begin
           sc.Back;
           Atom;
        end;
     end; // case
   end;
end;

procedure TInterpreter.PlusMinus;
Var t: EToken;
    op1i, op2i: integer;
    op1d, op2d: double;
    op1s, op2s: string;
    typ1, typ2, ergtyp: TVarType;
begin
   if not Fehler then
   begin
     op1d := 1; op2d := 1; op1i := 1; op2i := 1;
     MalGeteilt; // Erstes Argument
     t := sc.TRead;
     while t in [OPlus,OMinus] do
     begin
        typ1 := stack.Typ;
        if not (Typ1 in [vtInteger, vtDouble, vtString]) then error('Vor Plus/Minus wird ein Integer-, Double- oder String- Wert erwartet.')
        else begin
          MalGeteilt; // Zweites Argument
          typ2 := stack.Typ;
          if ( (typ1 = vtString) or (typ2 = vtString) ) and not (t = OPlus)
             then error ('Strings knnen nicht mit "-" verknpft werden.')
          else if not (Typ2 in [vtInteger, vtDouble, vtString]) then error('Nach Plus/Minus wird ein Integer-, Double- oder String- Wert erwartet.')
          else begin
               if typ1 = vtString then
               begin
                  if typ2 = vtString then op2s := stack.popString
                  else
                  begin
                    if typ2 = vtInteger then op2s := inttostr(stack.popInteger)
                    else if typ2 = vtDouble then op2s := floattostr(stack.popdouble);
                  end;
                  ergtyp := vtString;
                  op1s := stack.popString;
               end  // typ1 = vtString
               else if typ2 = vtString then
               begin
                  op2s := stack.popString;
                  if typ1 = vtString then op1s := stack.popString
                  else
                  begin
                    if typ1 = vtInteger then op1s := inttostr(stack.popInteger)
                    else if typ1 = vtDouble then op1s := floattostr(stack.popdouble);
                  end;
                  ergtyp := vtString;
               end
               else if typ1 = vtDouble then
               begin
                  if typ2 = vtInteger then op2d := stack.popInteger else op2d := stack.popdouble;
                  op1d := stack.popdouble;
                  ergtyp := vtdouble;
               end
               else if typ2 = vtDouble then
               begin
                  op2d := stack.popdouble;
                  if typ1 = vtInteger then op1d := stack.popInteger else op1d := stack.popdouble;
                  ergtyp := vtdouble;
               end
               else
               begin // beide vtInteger
                  op2i := stack.popInteger; op1i := stack.popInteger; ergtyp := vtInteger;
               end;
             // ***********************
             // Jetzt wird gerechnet!!
             case ergtyp of
             vtDouble:
                begin
                  case t of
                  OPlus: stack.pushDouble(op1d + op2d);
                  OMinus: stack.pushDouble(op1d - op2d);
                  end; // case
                end;
             vtInteger:
                begin
                  case t of
                  OPlus: stack.pushInteger(op1i + op2i);
                  OMinus: stack.pushInteger(op1i - op2i);
                  end; // case
                end;
             vtString:
                begin
                   stack.pushString(op1s + op2s);
                end;
             end; // case ergtyp of
          end; // if Typ des 2. Operanden passt
        end; // if Typ des 1. Operanden passt
        t := sc.TRead;
     end;  // while t in [OPlus, OMinus]
     sc.Back;
   end;
end;   // PlusMinus

function TInterpreter.schritt(Einzelschritt: Boolean;
                               Var OStopWarDa: Boolean): Boolean;
Var t: EToken;
    painted: boolean;
    pos: integer;
    Schrittdurchgefuehrt: Boolean;
begin
   painted := false;
   if not Fehler then
   begin
   try
     EnterCriticalSection(CriticalSectionPaint);

     repeat
       Schrittdurchgefuehrt := true; OStopWarDa := false;
       pos := sc.getPos;
       t := sc.TRead;
       case t of
       OIdentifier: begin
                      vdeklAttributMethode(pos);
                    end;
       OWiederhole: wiederhole;
       OSternWiederhole: SternWiederhole;
       OSolange: Solange;
       OSternSolange: SternSolange;
       OWenn: Wenn;
       OSternWenn: SternWenn;
       OEnde: Ende;
       OSonst: Sonst;
       OFuer: Fuer;
       OSternFuer: SternFuer;
       OMethode: Methode;
       OStop: begin
                Schrittdurchgefuehrt := false;
                OStopWarDa := true;
              end;
       else if t <> OEOF then error('Erwarte Variablendeklaration oder Anweisung.');
       end;
       sc.SkipSpace;
     until (not einzelschritt) or schrittdurchgefuehrt or Fehler;

     finally LeaveCriticalSection(CriticalSectionPaint); end;
     if t in [OIdentifier] then
     begin
        zeichneAlleFenster; painted := true;
     end else painted := false;
   end;
   if Fehlercode <> nil then
   begin
      Fehlerverwaltung.loescheFehler(1);
      FehlerVerwaltung.add(Fehlercode);
   end;
   schritt := painted;
end;

procedure TInterpreter.setzeMethode(m: TMethode);
var v: TVariant;
begin
   if not Fehler then
   begin
       v := m.Attribut.Wert;
          case v.typ of
            vtBoolean : v.b := stack.popBoolean;
            vtChar    : v.c := stack.popChar;
            vtInteger : v.i := stack.popInteger;
            vtDouble  : v.d := stack.popdouble;
            vtString  : v.s := stack.popString;
            vtObjekt  : v.o.copyfrom(stack.popObjekt);
          end; // case
       m.attribut.Objekt.attributaenderung(m.Attribut);
   end;
end;

procedure TInterpreter.Solange;
begin
   inc(Verschachtelungstiefe);
   Stack.pushInteger(sc.getPos);
   Stack.pushAblaufSteuerung(asSolangeBedingung);
   Term(vtBoolean,0); // Bedingung auswerten
   if not Fehler then
   begin
      if not stack.popBoolean then
      begin // Bedingung nicht erfllt, also kein Durchlauf
         Stack.popAblaufSteuerung; Stack.popInteger;
         if sc.TRead <> OTue then error('tue erwartet.')
         else begin
         Blockueberlesen;
         end;
      end else
       begin
          if sc.TRead <> OTue then error('tue erwartet.');
       end;
   end;
end;

procedure TInterpreter.sonst;
begin
   if stack.popAblaufSteuerung = asWennBedingungDann then
   begin
     Blockueberlesen;
   end
   else error('sonst ohne wenn gefunden.');
end;

procedure TInterpreter.SternFuer;
begin
   FuerObjekt := nil;
end;

procedure TInterpreter.SternSolange;
Var ast: TAblaufsteuerung;
    pos, posjetzt: integer;
begin
  dec(Verschachtelungstiefe);
  ast := stack.popAblaufSteuerung;
  posjetzt := sc.getPos;
  pos := Stack.popInteger; // da steht die Bedingung
  sc.SetPos(pos); // auf Bedingung setzen
  Term(vtBoolean,0);
  if (not Fehler) and (stack.popBoolean) then
    begin  // Bedingung noch erfllt => wiederholen!
       stack.pushInteger(pos);
       stack.pushAblaufSteuerung(ast);
       sc.TRead; // tue berlesen
       // scanner liest nach tue richtig weiter
    end
    else begin // Bedingung nicht erfllt => nach *wiederhole weiterlesen
       sc.Setpos(posjetzt);
    end;
end;

procedure TInterpreter.SternWenn;
Var ast: TAblaufsteuerung;
begin
   ast := stack.popAblaufSteuerung;
   if not (ast in [asWennBedingungDann,asImSonstBlock]) then
      error('*wenn ohne wenn.');
end;

procedure TInterpreter.SternWiederhole;
Var ast: TAblaufsteuerung;
    n, pos, posjetzt: integer;
    t : EToken;
    BedErfuellt: Boolean;
begin
   dec(Verschachtelungstiefe);
   ast := stack.popAblaufSteuerung;
   case ast of
      asWiederholeImmer: begin
                            pos := stack.popInteger;
                            sc.SetPos(pos);
                            stack.pushInteger(pos);
                            stack.pushAblaufSteuerung(ast);
                         end;
      asWiederholeN: begin
                        n := stack.popInteger; pos := stack.popInteger;
                        dec(n);
                        if n > 0 then
                          begin // Es sind noch Durchlufe ausstndig
                             sc.SetPos(pos);
                             stack.pushInteger(pos); stack.pushInteger(n);
                             stack.pushAblaufSteuerung(ast);
                          end;
                     end;
      asWiederholeSolange:
         begin
            posjetzt := sc.getPos;
            pos := Stack.popInteger; // da steht die Bedingung
            sc.SetPos(pos); // auf Bedingung setzen
            Term(vtBoolean,0);
            if (not Fehler) and (stack.popBoolean) then
            begin  // Bedingung noch erfllt => wiederholen!
               stack.pushInteger(pos);
               stack.pushAblaufSteuerung(ast);
               // scanner liest nach Bed. richtig weiter
            end
            else begin // Bedingung nicht erfllt => nach *wiederhole weiterlesen
               sc.Setpos(posjetzt);
            end;
         end;
      asWiederholeEndBed:
         begin
            pos := stack.popInteger;
            t := sc.TRead;
            if not (t in [OBis, OSolange]) then error ('bis erwartet.')
            else begin
               Term(vtBoolean,0); BedErfuellt := stack.popBoolean;
               if ( not BedErfuellt and (t = OBis) ) or
                    ( BedErfuellt and (t = OSolange) )  then
                  begin // noch eine Wiederholung, da Bed. noch nicht erfllt
                     stack.pushInteger(pos);
                     stack.pushAblaufSteuerung(ast);
                     sc.SetPos(pos);
                  end;
            end;
         end;
   else error('*wiederhole gefunden, ohne dass ein entsprechender Befehl wiederhole vorliegt.');
   end; // case
end;

procedure TInterpreter.Term(vtGewuenscht: TVarType; ciGewuenscht: Integer);
begin
   if not Fehler then
   begin
     AndOr; // Term auswerten
     case vtGewuenscht of
     vtString:
        case stack.Typ of
          vtInteger: stack.pushString(inttostr(stack.popInteger));
          vtDouble: stack.pushString(floattoStr(stack.popdouble));
          vtBoolean: if stack.popBoolean then stack.pushString('true') else stack.pushString('false');
          vtString: begin end;
          else error('Typ String erwartet.');
        end; // case stack.Typ of
     vtDouble:
        case stack.Typ of
          vtInteger: stack.pushDouble(stack.popInteger);
          vtDouble: begin end;
          else error('Typ Double erwartet');
        end; // case stack.Typ of
     vtInteger: if stack.Typ <> vtinteger then error('Typ Integer erwartet');
     vtChar: if stack.Typ <> vtChar then error('Typ Char erwartet');
     vtObjekt: if (stack.Typ <> vtObjekt) or (stack.oberstesElement.o.ci mod ciGewuenscht <> 0) then
               error('Klasse vom Index '+ inttostr(ciGewuenscht) +' erwartet.');
     end; // case vtGewuenscht of
   end;
end;

procedure TInterpreter.variablendeklaration;
Var t: EToken;
    sl: TStrings;
    o: TObjekt;
    i: Integer;
    v: TVariant;
    gibtesschon: boolean;
begin
   if Verschachtelungstiefe > 0 then error('Variablendeklaration ist nur auerhalb von Wiederholung (wiederhole/solange) zulssig.')
   else
   begin
     sl := TStringList.Create;
     t := sc.TRead;
     if t = OIdentifier then  // eigentlich berflssig, da nur in diesem Fall variablendeklaration aufgerufen wurde...
     begin
        while (t <> ODoppelpunkt) and  not Fehler do
        begin
           gibtesschon := false;
           for i := 0 to sl.Count -1 do
             if (sc.Text = sl.Strings[i]) then gibtesschon := true;
           if (vs.get(sc.text) <> nil) or gibtesschon then error('Eine Variable/ein Objekt mit dem Namen ' + sc.text + ' gibt es schon.')
           else
           begin
             sl.Add(sc.Text);
             t := sc.TRead;
             if not (t in [OKomma, ODoppelpunkt]) then
                error('Komma oder Doppelpunkt erwartet.')
                else if t = OKomma then
                begin
                  t := sc.TRead;
                  if t <> OIdentifier then Error('Bezeichner erwartet');
                end;
           end;
        end; // While Bezeichner einlesen
        if not Fehler then
        begin
           t := sc.TRead;
           if not (t in [OIdentifier, OInteger, OReal, OChar, OBoolean, OString]) then
              error ('Variablentyp erwartet')
              else
              begin
                 if t = OIdentifier then
                 begin
                    if not Klassenfabrik.gibtes(sc.Text) then error('Den Variablentyp/die Klasse '+sc.text+' gibt es nicht.')
                    else begin
                       for i := 0 to sl.Count -1 do
                       begin
                          o := klassenfabrik.erstelleObjekt(sc.Text,sl.Strings[i],nil);
                          if lowercase(sc.Text) = 'fenster' then
                          begin
                             fensterliste.Add(o);
                          end;
                          if (o.ci mod 2 = 0) and (StandardFenster <> nil) then
                          begin
                             Standardfenster.addObjekt(o);
                          end;
                          v := TVariant.Create;
                          v.o := o;
                          v.attribut := nil; // wir haben es mit einer Variablen zu tun, nicht mit einem Attribut eines Objekts!
                          vs.add(sl.Strings[i],v,false,false);
                       end;
                    end;
                 end // t = OIdentifier
                 else begin // t in [OInteger, ODouble, OChar, OBoolean]
                    for i := 0 to sl.Count -1 do
                    begin
                       v := TVariant.Create;
                       v.attribut := nil; // wir haben es mit einer Variablen zu tun, nicht mit einem Attribut eines Objekts!
                       case t of
                       OInteger: v.Typ := vtInteger;
                       OReal: v.Typ := vtDouble;
                       OChar: v.Typ := vtchar;
                       OBoolean: v.Typ := vtBoolean;
                       OSTring: v.Typ := vtString;
                       end; // case
                       vs.add(sl.Strings[i],v,false,false);
                    end;
                 end;  //Variablentyp zuweisen
              end;  // Variablentyp einlesen
        end; // Kein Fehler beim Einlesen der Bezeichner
     end else Error('Bezeichner erwartet.');
     sl.Free;
   end;
end;

procedure TInterpreter.vdeklAttributMethode(pos: integer);
var t: EToken;
    v: TVariant;
begin
   t := sc.TRead;
   sc.SetPos(pos); // auf Position vor dem Bezeichner setzen!!
   if t in [OKomma,ODoppelpunkt] then variablendeklaration
      else begin
             v := AttributMethode(true);
             if (v <> nil) and (v.attribut <> nil) and ( FEinstellungen.KeineZuweisungZuAttributen) then
                 error('Einem Attribut kann kein Wert zugewiesen werden!');
             if (not Fehler) and ( v <> nil) then
             begin  // ein Linkswert ist da => Zuweisung!
               zuweisung(v);
               if v.attribut <> nil then v.attribut.wurdegeaendert;
             end;
           end;
end;

procedure TInterpreter.Vergleich;
Var t: EToken;
    op1i, op2i: integer;
    op1d, op2d: double;
    operg: Boolean;
    Vergleichstyp: TVarType;
begin
   if not Fehler then
   begin
     op1d := 1; op2d := 1; op1i := 1; op2i := 1;
     PlusMinus; // Erstes Argument
     t := sc.TRead;
     if t in [Okleiner, Ogroesser, OGleich,
                 OKleinerGleich, OGroessergleich, OUngleich] then
     begin
        if not (stack.Typ in [vtInteger, vtDouble]) then error('Vor <,>,<=,>=,<>,= wird ein Integer- oder Double-Wert erwartet.')
        else begin
          PlusMinus; // Zweites Argument
          if not (stack.Typ in [vtInteger, vtDouble]) then error('Nach <,>,<=,>=,<>,= wird ein Integer- oder Double-Wert erwartet.')
          else begin
             vergleichstyp := vtDouble;
             if stack.Typ = vtDouble then
             begin
                op2d := stack.popdouble;
                op1d := stack.popdouble; // castet automatisch
             end
             else
             op2i := stack.popInteger;

             if stack.Typ = vtInteger then
             begin
                op1i := stack.popInteger;
                Vergleichstyp := vtInteger;
             end
             else begin
             op1d := stack.popdouble; op2d := op2i;
             end;

             if vergleichstyp = vtDouble then
             begin
               case t of
               OKleiner: operg := op1d < op2d;
               OGroesser: operg := op1d > op2d;
               OKleinerGleich: operg := op1d <= op2d;
               OGroesserGleich: operg := op1d >= op2d;
               OGleich: operg := op1d = op2d;
               OUngleich: operg := op1d <> op2d;
               else operg := false;
               end; // case
             end else // if vergleichstyp = vtDouble
             begin //  Vergleichstyp = vtInteger
               case t of
               OKleiner: operg := op1i < op2i;
               OGroesser: operg := op1i > op2i;
               OKleinerGleich: operg := op1i <= op2i;
               OGroesserGleich: operg := op1i >= op2i;
               OGleich: operg := op1i = op2i;
               OUngleich: operg := op1i <> op2i;
               else operg := false;
               end; // case
             end; // vergleichstyp = vtDouble
             stack.pushBoolean(operg);
          end; // if Typ des 2. Operanden passt
        end; // if Typ des 1. Operanden passt
     end  // if t in [OKleiner, ...]
     else sc.Back;
   end;
end;   // Vergleich

procedure TInterpreter.wenn;
Var b: Boolean;
    n : Integer; // Schachtelungstiefe
    t: EToken;
begin
   // Bedingung auswerten
   Term(vtBoolean,0);
   if sc.TRead <> ODann then error('dann erwartet.');
   if not Fehler then
   begin
     b := stack.popBoolean;
     if b then
     begin
        stack.pushAblaufSteuerung(asWennBedingungDann);
     end
     else
     begin // Wenn-Block berspringen. Nach dem zugehrigen sonst oder *wenn suchen
        n := 1;
        repeat   // n zhlt die offenen Wenn - Blcke mit.
          t := sc.TRead;
          case t of
          OWenn: n := n + 1;
          OSternWenn: n := n - 1;
          end; // case
        until (t = OEof) or (n = 0) or ( (t = OSonst) and (n = 1) );
        if ( t = OSonst) and (n = 1) then
        begin
          stack.pushAblaufSteuerung(asImSonstBlock);
        end;
     end;
   end;
end;

procedure TInterpreter.Wiederhole;
Var t,t1: EToken;
    n, pos: integer;
begin
   inc(verschachtelungstiefe);
   pos := sc.getPos;
   t := sc.TRead;
   case t of
      OImmer: begin
                 Stack.pushInteger(sc.getPos);
                 Stack.pushAblaufSteuerung(asWiederholeImmer);
              end;
      OSolange: begin
                   Stack.pushInteger(sc.getPos);
                   Stack.pushAblaufSteuerung(asWiederholeSolange);
                   Term(vtBoolean,0); // Bedingung auswerten
                   if not Fehler then
                   begin
                      if not stack.popBoolean then
                      begin // Bedingung nicht erfllt, also kein Durchlauf
                         Stack.popAblaufSteuerung; Stack.popInteger;
                         Blockueberlesen;
                      end;
                   end;
                end;
      else begin        // Wiederhole n mal oder Wiederhole mit Endbedingung
           sc.Back;
           t1 := sc.TRead;
           if t1 in [OKlammAuf, OIntegerconst] then  // Wiederhole n mal
             begin
                sc.Back;
                Term(vtInteger,0);
                if not Fehler then
                begin
                  n := stack.popInteger; // Anzahl der Wiederholungen
                  if n > 0 then
                  begin
                     if sc.TRead <> OMalWort then error(' mal erwartet.')
                     else begin
                        stack.pushInteger(sc.getPos);
                        stack.pushInteger(n);
                        stack.pushAblaufSteuerung(asWiederholeN);
                     end;
                  end;
                end;
             end else
             begin
                sc.SetPos(pos);
                stack.pushInteger(pos);
                stack.pushAblaufSteuerung(asWiederholeEndBed);
             end; // Wiederhole mit Endbed
           end;
   end; // case;

end;

procedure TInterpreter.zeichneAlleFenster;
Var i: integer;
begin
   for i := 0 to fensterliste.Count -1 do
      TFenster(fensterliste.Items[i]).zeichne;
end;

procedure TInterpreter.zuweisung(v: TVariant);
var ci: integer;
begin
   if not Fehler then
   begin
     if sc.TRead <> ODoppelpunktGleich then error (':= erwartet.')
     else begin
       if (v.Typ = vtObjekt) and (v.o <> nil) then ci := v.o.ci else ci := 0;
       Term(v.Typ,ci);
       if not Fehler then
       begin
          case v.typ of
            vtBoolean : v.b := stack.popBoolean;
            vtChar    : v.c := stack.popChar;
            vtInteger : v.i := stack.popInteger;
            vtDouble  : v.d := stack.popdouble;
            vtString  : v.s := stack.popString;
            vtObjekt  : v.o.copyfrom(stack.popObjekt);
          end; // case
       end;
     end; // := war da
   end;
end;


end.
