unit UProgrammSpeicher;

interface

uses UCompilerConstants, Classes, UDaten;

type
TProgrammSpeicher = class(TObject)
   private
     prog: Array of Integer;
     progKapazitaet: Integer; // Wie gro ist das Array augenblicklich?
     Inkrement: Integer;
     PC: Integer;

     konstanten: TList;       // Konstantenspeicher
   public
     StartAdresse: Integer;

     procedure pushBefehl(b: TBefehl);
     procedure pushInteger(i: Integer);
     function getBefehl: TBefehl;
     function getInteger: Integer;
     function getPC: Integer;
     procedure setPC(n: Integer);

     function pushKonstante(v: TVariant): Integer;
     function getKonstante(n: Integer):TVariant;

     constructor create;
     procedure clear;
     destructor destroy; override;
end;

TBefehlsStack = class(TObject)
   private
      prog: Array of Integer;
      frames: Array of Integer;
      progKapazitaet, FrameKapazitaet: Integer;
      progCount, FrameCount: Integer;
      progInkrement, FrameInkrement: Integer;
   public

   procedure newFrame;
   procedure FrameAbraeumen(ps: TProgrammSpeicher);

   procedure pushBefehl(b: TBefehl);
   procedure pushInteger(i: Integer);

   constructor create;
   destructor destroy; override;
end;

implementation

{ TProgrammSpeicher }

procedure TProgrammSpeicher.clear;
Var i: integer;
begin
   prog := nil;
   PC := 0;
   progKapazitaet := Inkrement;
   setlength(prog,Inkrement);

  for i := 0 to Konstanten.count -1 do
     begin
       TVariant(Konstanten.items[i]).free;
       Konstanten.items[i] := nil;
     end;
  konstanten.clear;
end;

constructor TProgrammSpeicher.create;
begin
   Inkrement := 1000;
   PC := 0;
   progKapazitaet := Inkrement;
   setlength(prog,Inkrement);

   konstanten := TList.create;
end;

destructor TProgrammSpeicher.destroy;
Var i: integer;
begin
  prog := nil;
  for i := 0 to Konstanten.count -1 do
     begin
       TVariant(Konstanten.items[i]).free;
       Konstanten.items[i] := nil;
     end;
  konstanten.free;
  inherited;
end;

function TProgrammSpeicher.getBefehl: TBefehl;
begin
   if pc <= progKapazitaet - 1 then
      begin
         getBefehl := TBefehl(prog[pc]);
         inc(pc);
      end
   else getBefehl := BNop;
end;

function TProgrammSpeicher.getInteger: Integer;
begin
   if pc <= progKapazitaet - 1 then
      begin
         getInteger := prog[pc];
         inc(pc);
      end
   else getInteger := 0;
end;

function TProgrammSpeicher.getKonstante(n: Integer): TVariant;
begin
   getKonstante := TVariant(konstanten.Items[n]);
end;

function TProgrammSpeicher.getPC: Integer;
begin
   getPC := PC;
end;

procedure TProgrammSpeicher.pushBefehl(b: TBefehl);
begin
   if pc > progKapazitaet - 1 then
      begin
         progKapazitaet := progKapazitaet + Inkrement;
         setlength(prog,progKapazitaet);
      end;
   prog[pc] := Integer(b);
   inc(pc);
end;

procedure TProgrammSpeicher.pushInteger(i: Integer);
begin
   if pc > progKapazitaet - 1 then
      begin
         progKapazitaet := progKapazitaet + Inkrement;
         setlength(prog,progKapazitaet);
      end;
   prog[pc] := i;
   inc(pc);
end;

function TProgrammSpeicher.pushKonstante(v: TVariant): Integer;
begin
   konstanten.Add(v);
   pushKonstante := konstanten.Count - 1;
end;

procedure TProgrammSpeicher.setPC(n: Integer);
begin
   if (pc <= 0) and (pc <= progKapazitaet -1) then
   pc := n;
end;

{ TBefehlsStack }

constructor TBefehlsStack.create;
begin
   progInkrement := 100;
   FrameInkrement := 10;

   progKapazitaet := progInkrement;
   FrameKapazitaet := FrameInkrement;

   setlength(prog,progKapazitaet);
   setlength(frames,frameKapazitaet);

   progCount := 0; frameCount := 0;
end;

destructor TBefehlsStack.destroy;
begin
  prog := nil; frames := nil;
  inherited;
end;

procedure TBefehlsStack.FrameAbraeumen(ps: TProgrammSpeicher);
Var i,von: integer;
begin
   if FrameCount > 0 then
   begin
      von := Frames[FrameCount -1];
      dec(FrameCount);
   end else von := 0;
   for i := von to progCount - 1 do
      ps.pushInteger(prog[i]);
   progCount := von;
end;

procedure TBefehlsStack.newFrame;
begin
   //Frames[0..FrameCount -1] sind besetzt.
   if FrameCount >= FrameKapazitaet then
   begin
      FrameKapazitaet := FrameKapazitaet + FrameInkrement;
      setlength(frames,FrameKapazitaet);
   end;
   Frames[FrameCount] := ProgCount;
   inc(FrameCount);
end;

procedure TBefehlsStack.pushBefehl(b: TBefehl);
begin
   if progCount >= ProgKapazitaet then
   begin
      progKapazitaet := progKapazitaet + progInkrement;
      setlength(prog,progKapazitaet);
   end;
   prog[progCount] := Integer(b);
   inc(progCount);
end;

procedure TBefehlsStack.pushInteger(i: Integer);
begin
   if progCount >= ProgKapazitaet then
   begin
      progKapazitaet := progKapazitaet + progInkrement;
      setlength(prog,progKapazitaet);
   end;
   prog[progCount] := i;
   inc(progCount);
end;

end.
