unit UMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, UScanner, UVariablen, UDaten, UKlassen,
  UInterpreter, USHControl, Menus, Buttons, ComCtrls, ImgList, UFehler,
  LadenSpeichern, UDebugControl, ActnList;

const Version = '1.5.9';
      SaveVersion = '1.5';

const
     // Geschwindigkeitsstufen; Jede Stufe besteht aus dem Timerintervall
     // in ms und der Anzahl der Befehle, die bei jedem Timeraufruf abgearbeitet werden.
     millisekunden: Array[1..30] of integer =
     ( 2000,1000,900,800,700,600,500,
       400,300,200,100,50,40,30,20,10,5,4,3,2,
       1,1,1,1,1,1,1,1,1,1);
      BefehlsAnzahl: Array[1..30] of integer =
      ( 1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,2,3,4,5,6,7,8,9,10);


type
  TFMain = class(TForm)
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    OEffnen1: TMenuItem;
    Speichern1: TMenuItem;
    Speichernunter1: TMenuItem;
    Bearbeiten1: TMenuItem;
    Ausschneiden1: TMenuItem;
    Kopieren1: TMenuItem;
    Einfgen1: TMenuItem;
    LBError: TListBox;
    SBOeffnen: TSpeedButton;
    SBSpeichern: TSpeedButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SBStart: TSpeedButton;
    SBPause: TSpeedButton;
    SBStop: TSpeedButton;
    SBSchritt: TSpeedButton;
    BStarten: TButton;
    BBearbeiten: TButton;
    Timer: TTimer;
    Panel: TPanel;
    Splitter1: TSplitter;
    TVKlassen: TTreeView;
    BKlassenansicht: TButton;
    ImageList1: TImageList;
    PCHelp: TPageControl;
    TSKlassen: TTabSheet;
    TSBefehle: TTabSheet;
    MBefehle: TMemo;
    TSKonstanten: TTabSheet;
    MKonstanten: TMemo;
    TimerInfo: TTimer;
    Hilfe1: TMenuItem;
    Information1: TMenuItem;
    LObjectCount: TLabel;
    TBSpeed: TTrackBar;
    LGeschwindigkeit: TLabel;
    Neu1: TMenuItem;
    Einstellungen1: TMenuItem;
    Drucken1: TMenuItem;
    BVariablen: TButton;
    Paneloben: TPanel;
    Panelunten: TPanel;
    Splitter2: TSplitter;
    Schlieen1: TMenuItem;
    Programm1: TMenuItem;
    LetztesZeichenfenster1: TMenuItem;
    MRueckgaengig: TMenuItem;
    ActionList1: TActionList;
    Oeffnen: TAction;
    Speichern: TAction;
    Drucken: TAction;
    Kopieren: TAction;
    Ausschneiden: TAction;
    Einfuegen: TAction;
    Rueckgaengig: TAction;
    SpeichernUnter: TAction;
    Einstellungen: TAction;
    Neu: TAction;
    Information: TAction;
    Start: TAction;
    Pause: TAction;
    Stop: TAction;
    Schritt: TAction;
    SBKopieren: TSpeedButton;
    SBAusschneiden: TSpeedButton;
    SBEinfuegen: TSpeedButton;
    SBRueckgaengig: TSpeedButton;
    InhaltdesZeichenfenstersKopieren: TMenuItem;
    EditorPopup: TPopupMenu;
    Kopieren2: TMenuItem;
    Ausschneiden2: TMenuItem;
    Einfgen2: TMenuItem;
    SBRedo: TSpeedButton;
    Redo: TAction;
    Redo1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure BStartenClick(Sender: TObject);
    procedure BBearbeitenClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BKlassenansichtClick(Sender: TObject);
    procedure LBErrorClick(Sender: TObject);
    procedure TimerInfoTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TBSpeedChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BVariablenClick(Sender: TObject);
    procedure Schlieen1Click(Sender: TObject);
    procedure LetztesZeichenfenster1Click(Sender: TObject);
    procedure OeffnenExecute(Sender: TObject);
    procedure SpeichernExecute(Sender: TObject);
    procedure DruckenExecute(Sender: TObject);
    procedure KopierenExecute(Sender: TObject);
    procedure AusschneidenExecute(Sender: TObject);
    procedure EinfuegenExecute(Sender: TObject);
    procedure RueckgaengigExecute(Sender: TObject);
    procedure SpeichernUnterExecute(Sender: TObject);
    procedure EinstellungenExecute(Sender: TObject);
    procedure NeuExecute(Sender: TObject);
    procedure InformationExecute(Sender: TObject);
    procedure StartExecute(Sender: TObject);
    procedure PauseExecute(Sender: TObject);
    procedure StopExecute(Sender: TObject);
    procedure SchrittExecute(Sender: TObject);
    procedure InhaltdesZeichenfenstersKopierenClick(Sender: TObject);
    procedure RueckgaengigUpdate(Sender: TObject);
    procedure RedoExecute(Sender: TObject);
    procedure RedoUpdate(Sender: TObject);
  private
    // Fr die Timergesteuerte Ausfhrung:
    run: Boolean;
    running: Boolean;

    sc: TScanner;
    fc: TFormatClass;
    interpreter: TInterpreter;
    programrunning: Boolean;
    programmstopp: Boolean;

    Schrittfarbe: TColor;
    Filename: string;

    BefehlsAnzahlaktuell: integer;
    PositionImmerZeigen: boolean;
    EinzelBefehlsMode: boolean;

    Variablenzeigen: boolean;
    Variablenzeigenmerken: boolean;
    // ls: TLoadSave;

    talt: integer;
    procedure Init;
    procedure programmende;
    procedure SetCaption;
    procedure HaltepunkteAktualisieren;
    procedure Schrittkennzeichnen;
  public
    shc: TSHControl;
    dc: TDebugControl;


  procedure variablenausgabe;
  procedure variablenausgabeh(v: TVariable);
  end;

var
  FMain: TFMain;

implementation

uses UHelpTree, UCriticalSections, UInformation, UCountObjects, Uencrypt,
  UEinstellungen, UTratzen, UPasswortabfrage, UPrint,
  USyntaxcheck, ULetztesZeichenfenster, Clipbrd;

{$R *.dfm}


procedure TFMain.FormCreate(Sender: TObject);
Var kf: TKlassenFabrik;
    i: integer;
    s{,FName}: string;
begin
   Variablenzeigen := false;
   Variablenzeigenmerken := false;

   BefehlsAnzahlaktuell := 10;
   PositionImmerZeigen := false;
   EinzelBefehlsMode := false;

   InitializeCriticalSections;

   fc := TFormatClass.Create;

   shc := TSHControl.create(Paneloben);
   shc.Parent := Paneloben;
   shc.Align := alClient;
   shc.FormatProzedur := fc.formatprocedure;
   shc.SetBounds(0,0,Panel.Width,Panel.Height);
   shc.OnStopPosAenderung := HaltepunkteAktualisieren;
   shc.PopupMenu := EditorPopup;
   shc.Show;

   dc := TDebugControl.create(Panelunten);
   dc.Parent := Panelunten;
   dc.Align := alClient;
   dc.Show;

   FehlerVerwaltung := TFehlerVerwaltung.create(LBError);

   ProgramRunning := false; programmstopp := false;

   Schrittfarbe := clAqua;
   Filename := '';
   Top := 0; left := 0;

   // fr den Timer:
   run := false;
   running := false;
   timer.Enabled := true;

   // TreeView
   kf := TKlassenFabrik.create;
   TreeCreate(TVKlassen,kf);
   kf.Free;

   // test
   talt := 0;

   ZaehlerFuerObjectcs := 0;

  for i := 0 to ParamCount do
   begin
     s := ParamStr(i);
     if lowercase(copy(s,length(s)-2,3)) = 'eos' then
     begin
        shc.openfile(s);
        filename := s;
     end;
   end;

   SetCaption;

end;

procedure TFMain.FormDestroy(Sender: TObject);
begin
   programmende;
   fc.Free;
   FehlerVerwaltung.Free;
   DeleteCriticalSections; // in UCriticalSections
end;

procedure TFMain.FormResize(Sender: TObject);
begin
   Panel.SetBounds(2,32,clientwidth-4,Clientheight - 72);
   LBError.SetBounds(2,clientheight - 71+30,clientwidth-4,98-59);
end;

procedure TFMain.Init;
Var zeile, spalte: integer;
begin
  try
  EnterCriticalSection(CriticalSectionMainFormTimer); // Wegen Haltepunkteaktualisieren!
     sc.free; interpreter.Free;
     sc := nil; interpreter := nil;

     sc := TScanner.Create;
     sc.init(shc);
     interpreter := TInterpreter.create(sc,TSyntaxCheck(shc.SyntaxCheck).FensterAutomatisch);
   finally
   LeaveCriticalSection(CriticalSectionMainFormTimer);
   end;

   HaltepunkteAktualisieren;
   sc.SkipSpace;
   sc.GetZeileSpalte(Zeile,Spalte);
   TZeilenInformation(shc.Zeile.Objects[Zeile]).Hintergrundfarbe := Schrittfarbe;
   shc.Paint;
   talt := Zeile;
end;


procedure TFMain.SetCaption;
begin
   if Filename = '' then
   Caption := 'EOS '+ Version + ' (Einfache objektorientierte Sprache)'
   else
   Caption := 'EOS ' + Version + ' - ' + ExtractFileName(FileName);
end;

procedure TFMain.programmende;
Var srunning: boolean;
begin
   try
     EnterCriticalSection(CriticalSectionMainFormTimer);
     run := false;
   finally
     LeaveCriticalSection(CriticalSectionMainFormTimer);
   end;
   repeat
     try
       EnterCriticalSection(CriticalSectionMainFormTimer);
       srunning := running;
     finally
       LeaveCriticalSection(CriticalSectionMainFormTimer);
     end;
   until not srunning;

  //CriticalSection wegen Haltepunkteaktualisieren!
  try
    EnterCriticalSection(CriticalSectionMainFormTimer);
    sc.Free; sc := nil;
    interpreter.Free; interpreter := nil;
  finally
    LeaveCriticalSection(CriticalSectionMainFormTimer);
  end;
end;

procedure TFMain.BStartenClick(Sender: TObject);
begin
   shc.Bearbeitenerlaubt := false;
   shc.clearColor;
   FehlerVerwaltung.loescheAlleFehler;
   init;
   shc.setCursorText(0,0);
   shc.Paint;
   BStarten.Visible := false;
   BVariablen.visible := true;
   if variablenzeigenmerken then BVariablen.Click;

   if variablenzeigen then variablenausgabe;

   Kopieren.Enabled := false;
   Einfuegen.Enabled := false;
   Ausschneiden.Enabled := false;
   Rueckgaengig.Enabled := false;

   SBKopieren.Visible := false;
   SBEinfuegen.Visible := false;
   SBAusschneiden.Visible := false;
   SBRueckgaengig.Visible := false;
   SBRedo.Visible := false;

   SBOeffnen.Visible := false;
   SBSpeichern.Visible := false;

   BBearbeiten.Visible := true;
   TBSpeed.Visible := true;
   LGeschwindigkeit.Visible := true;

   Start.Visible := true;
   Pause.Visible := false;
   Stop.Visible := true;
   Schritt.Visible := true;
end;

procedure TFMain.BBearbeitenClick(Sender: TObject);
begin
   if talt >= 0 then
      TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;
   {   programmstopp := true;
   repeat until not programrunning;}
   programmende;

   Start.Visible := false;
   Pause.Visible := false;
   SBPause.Visible := false;
   Stop.Visible := false;
   Schritt.Visible := false;
   BBearbeiten.Visible := false;
   TBSpeed.Visible := false;
   LGeschwindigkeit.Visible := false;
   variablenzeigenmerken := variablenzeigen;
   if Variablenzeigen then BVariablen.Click;
   BVariablen.visible := false;

   Kopieren.Enabled := true;
   Einfuegen.Enabled := true;
   Ausschneiden.Enabled := true;
   Rueckgaengig.Enabled := true;

   SBKopieren.Visible := true;
   SBEinfuegen.Visible := true;
   SBAusschneiden.Visible := true;
   SBRueckgaengig.Visible := true;
   SBRedo.Visible := true;

   SBOeffnen.Visible := true;
   SBSpeichern.Visible := true;


   BStarten.Visible := true;
   shc.clearColor; shc.Paint;
   shc.Bearbeitenerlaubt := true; shc.SetFocus; shc.Paint;
   FehlerVerwaltung.loescheAlleFehler;
   shc.checkSyntax;
end;

procedure TFMain.TimerTimer(Sender: TObject);
var i,j: integer;
    painted: boolean;
    OStopWarDa: Boolean;
begin
{$IFDEF OBJECTCOUNT}
    try
      EnterCriticalSection(CriticalSectionObjectCount);
      LObjectCount.Caption := inttostr(zaehlerFuerObjectcs);
    finally
      LeaveCriticalSection(CriticalSectionObjectCount);
    end;
{$ENDIF}
  Application.ProcessMessages;
  try
     EnterCriticalSection(CriticalSectionMainFormTimer);
     if not running then
     begin
       OStopWarDa := false;
       running := true;
       if run then
       begin
         if talt >= 0 then
             TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;

           i := Befehlsanzahlaktuell;
           if EinzelBefehlsMode then j := 1 else j := 100;
           while not (sc.EndofText or interpreter.Fehler or (i = 0)
                   or(j = 0) or OStopWarDa ) do
           begin
             try
              EnterCriticalSection(CriticalSectionVariablenzugriff);
              painted := interpreter.schritt(false,OStopWarDa);
             finally
              LeaveCriticalSection(CriticalSectionVariablenzugriff);
             end;
              if painted then dec(i);
              dec(j);
              if PositionImmerZeigen then
              begin
                 Schrittkennzeichnen;
              end;

         end;
         if sc.EndofText then
         begin
           Schrittkennzeichnen;
           if sc.EndOfText then run := false;
         end;
         if interpreter.Fehler and (interpreter.Fehlercode <> nil) then
         begin
            shc.setCursorText(interpreter.Fehlercode.Zeile, interpreter.Fehlercode.Spalte);
            try
              EnterCriticalSection(CriticalSectionProgrammZeilen);
              TZeilenInformation(shc.Zeile.Objects[interpreter.Fehlercode.Zeile]).Hintergrundfarbe := clred;
            finally
              LeaveCriticalSection(CriticalSectionProgrammZeilen);
            end;
            variablenausgabe;
            shc.Paint; shc.SetFocus;
            FehlerVerwaltung.ListBoxAktualisieren;
            run := false;
         end;
       end;
       running := false;
     end;

     if OStopWarDa and run then
        begin
            run := false;
            PauseExecute(self);
        end;
  finally
    LeaveCriticalSection(CriticalSectionMainFormTimer);
  end;

end;

procedure TFMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   timer.enabled := false; // Kein weiteres Timersignal!
   if BBearbeiten.Visible then
   begin
      Programmende;
   end;
end;

procedure TFMain.BKlassenansichtClick(Sender: TObject);
var z: integer;
begin
  if not PCHelp.Visible then
  begin
  PCHelp.Visible := true;
  Splitter1.Visible := true;
  BKlassenansicht.Caption := 'Hilfe ausblenden';
  randomize;
  z := random(40);
  if z = 10 then InformationExecute(self);
  end else
  begin
  PCHelp.Visible := false;
  Splitter1.Visible := false;
  BKlassenansicht.Caption := 'Hilfe zeigen...';
  end;
end;

procedure TFMain.LBErrorClick(Sender: TObject);
Var f: TFehler;
begin
   if LBError.ItemIndex <= LBError.Count - 1 then
   begin
      f := TFehler(LbError.Items.Objects[LBError.ItemIndex]);
      shc.PositionSichtbar(f.Zeile,f.spalte);
      shc.SetCursorText(f.Zeile,f.Spalte);
      shc.setFocus;
   end;
end;

procedure TFMain.TimerInfoTimer(Sender: TObject);
begin
   FInformation.Hide;
   TimerInfo.enabled := false;
   FEinstellungen.EinstellungenLaden;
end;

procedure TFMain.FormShow(Sender: TObject);
begin
   TimerInfo.Enabled := true;
   FInformation.Show;
end;

procedure TFMain.HaltepunkteAktualisieren;
begin
  try
    EnterCriticalSection(CriticalSectionMainFormTimer);
     if sc <> nil then
        if sc.shc <> nil then sc.StopPositionensetzen;
  finally
    LeaveCriticalSection(CriticalSectionMainFormTimer);
  end;
end;

procedure TFMain.TBSpeedChange(Sender: TObject);
begin
   BefehlsAnzahlaktuell := BefehlsAnzahl[TBSpeed.Position];
   timer.Interval := Millisekunden[TBSpeed.Position];
   if TBSpeed.Position < 15 then
   begin
     PositionImmerZeigen := true;
     EinzelBefehlsMode := true;
   end
   else
   begin
     PositionImmerZeigen := false;
     EinzelBefehlsMode := false;
     try
       EnterCriticalSection(CriticalSectionProgrammZeilen);
       TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;
     finally
       LeaveCriticalSection(CriticalSectionProgrammZeilen);
     end;
     shc.Paint;
   end;
end;

procedure TFMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   canClose := false;
   if shc.modified then
   begin
     case Application.MessageBox('Wollen Sie vorher noch abspeichern?','Warnung:',MB_YESNOCANCEL) of
     ID_YES: begin
             canClose := false;
             SpeichernExecute(self);
             end;
     ID_No: CanClose := true;
     ID_Cancel: CanClose := false;
     end; // case
   end else CanClose := true;
end;

procedure TFMain.variablenausgabeh(v: TVariable);
var s: string;
    i: integer;
    a: TAttribut;
begin
   s := '';
   if (not (v.Wert.Typ in [vtMethode])) and not v.System then
   begin
     if v.wert.typ = vtObjekt then
     begin
        s := s + #1 + v.Name + #2 + ' = (';
        for i := 0 to v.Wert.o.attribute.Count -1 do
        begin
           a := TAttribut(v.wert.o.attribute.Items[i]);
           if not a.versteckt then
           begin
              if i <> 0 then s := s + ',';
              s := s + #1 + a.Name + #2;
              if a.Wert.Typ <> vtObjekt then
              begin
                 s := s + ' = ';
                 if a.Wert.veraendert then s := s + #3;
                 s := s + a.Wert.toSTring;
                 if a.Wert.veraendert then s := s + #4;
                 a.Wert.veraendert := false;
              end;
           end;
        end;
        s := s + ')';
        dc.addvar(s);
     end
     else begin
        s := s + #1 + v.Name + #2 + ' = ';
        if v.Wert.veraendert then s := s + #3;
        s := s + v.Wert.toSTring;
        if v.Wert.veraendert then s := s + #4;
        v.Wert.veraendert := false;
        dc.addvar(s);
     end;
   end;
end;

procedure TFMain.variablenausgabe;
Var i, bis: integer;
    vs: TVarSpace;
    v: TVariable;
begin
   if variablenzeigen then
   begin
     try
       EnterCriticalSection(CriticalSectionVariablenzugriff);
       vs := interpreter.vs;

         dc.init; // Alte Ausgabe verwerfen
         // lokale Variablen
         if vs.KontextCount > 0 then
         begin
            for i := vs.KontextGrenzen[vs.KontextCount -1] to vs.Varlist.Count -1 do
            begin
               v := TVariable(vs.Varlist.Items[i]);
               variablenausgabeh(v);
            end;
         end;
         // globale Variablen
         if vs.KontextCount > 0 then bis := vs.Kontextgrenzen[0] - 1 else bis := vs.Varlist.Count - 1;
            // Zuerst alle Nicht-Objekte
            for i := 0 to bis do
            begin
               v := TVariable(vs.Varlist.Items[i]);
               if v.Wert.Typ <> vtObjekt then variablenausgabeh(v);
            end;
            // Dann alle Objekte
            for i := 0 to bis do
            begin
               v := TVariable(vs.Varlist.Items[i]);
               if v.Wert.Typ = vtObjekt then variablenausgabeh(v);
            end;
       dc.complete;
     finally
       LeaveCriticalSection(CriticalSectionVariablenzugriff);
     end;
   end;
end;

procedure TFMain.BVariablenClick(Sender: TObject);
begin
  try
   EnterCriticalSection(CriticalSectionVariablenzugriff);
   Variablenzeigen := not VAriablenzeigen;
   if Variablenzeigen then
   begin
      Panelunten.Visible := true;
      Splitter2.visible := true;
      variablenausgabe;
      BVariablen.Caption := 'Variablen ausblenden';
   end else
   begin
      Panelunten.Visible := false;
      splitter2.visible := false;
      BVariablen.Caption := 'Variablen zeigen';
   end;
  finally
   LeaveCriticalSection(CriticalSectionVariablenzugriff);
  end;
end;

procedure TFMain.Schlieen1Click(Sender: TObject);
begin
 if BBearbeiten.Visible then BBearbeitenClick(self);
 timer.Enabled := false;
 close;
end;

procedure TFMain.LetztesZeichenfenster1Click(Sender: TObject);
begin
   FLetztesZeichenfenster.Show;
end;

procedure TFMain.OeffnenExecute(Sender: TObject);
var ersteZeile: string; // Versionsinformation
begin
   if BBearbeiten.Visible then BBearbeitenClick(self);
   timer.Enabled := false;
     if FEinstellungen.Arbeitsverzeichnis <> '' then
       OpenDialog1.InitialDir := FEinstellungen.Arbeitsverzeichnis;
   if OpenDialog1.Execute then
      begin
         Filename := OpenDialog1.FileName;
         ersteZeile := shc.openfile(FileName);
         if (ersteZeile <> '') and (copy(ersteZeile,1,10) <> '// EOS '+SaveVersion) then
             Application.MessageBox('Dieses Programm wurde nicht fr EOS '+SaveVersion+' geschrieben.','Warnung!',MB_OK);
         SetCaption;
         SaveDialog1.InitialDir := ExtractFilePath(Filename);
         shc.clearColor; shc.Paint;
      end;
   timer.Enabled := true;
end;

procedure TFMain.SpeichernExecute(Sender: TObject);
begin
   if BBearbeiten.Visible then BBearbeitenClick(self);

   if Filename <> '' then
      shc.savefile(Filename,'// EOS '+SaveVersion+' - Programm')
      else SpeichernunterExecute(self);
end;

procedure TFMain.DruckenExecute(Sender: TObject);
begin
   FPrint.init(shc);
   FPrint.ShowModal;
end;

procedure TFMain.KopierenExecute(Sender: TObject);
begin
   if not BBearbeiten.Visible then
      shc.ClipboardCopy;
end;

procedure TFMain.AusschneidenExecute(Sender: TObject);
begin
   if not BBearbeiten.Visible then
      shc.ClipboardCut;
end;

procedure TFMain.EinfuegenExecute(Sender: TObject);
begin
   if not BBearbeiten.Visible then
      shc.ClipboardPaste;
end;

procedure TFMain.RueckgaengigExecute(Sender: TObject);
begin
   if not BBearbeiten.Visible then
      shc.Rueckgaengig;
end;

procedure TFMain.SpeichernUnterExecute(Sender: TObject);
begin
   if Filename <> '' then SaveDialog1.FileName := FileName;
   if SaveDialog1.Execute then
   begin
      Filename := SaveDialog1.FileName;
      SetCaption;
      SpeichernExecute(self);
   end;
end;

procedure TFMain.EinstellungenExecute(Sender: TObject);
begin
   if FEinstellungen.Passwort <> '' then
     FPasswortabfrage.Show
     else FEinstellungen.Show;
end;

procedure TFMain.NeuExecute(Sender: TObject);
begin
  if BBearbeiten.Visible then BBearbeitenClick(self);
  if MessageDlg('Soll das aktuelle Programm verworfen werden?',mtWarning,mbOKCancel,0)
        = mrOK then
     begin
        shc.clear;
        Filename := '';
     end;
  SetCaption;
end;

procedure TFMain.InformationExecute(Sender: TObject);
begin
   FInformation.BorderStyle := bsSingle;
   FInformation.Height := FInformation.Height + 25;
   FInformation.Show;
end;

procedure TFMain.StartExecute(Sender: TObject);
begin
   if BBearbeiten.Visible then
   begin
     shc.clearColor; shc.Paint;
     SBPause.Visible := true;
     SBStart.Visible := false;
     SBSchritt.Visible := false;

     if talt >= 0 then
         TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;
     run := true; // den Rest macht der Timer!!
   end;
end;

procedure TFMain.PauseExecute(Sender: TObject);
var zeile,spalte: integer;
    srunning: boolean;
begin
   if BBearbeiten.Visible then
   begin
     try
       EnterCriticalSection(CriticalSectionMainFormTimer);
       run := false;
     finally
       LeaveCriticalSection(CriticalSectionMainFormTimer);
     end;
     repeat
       try
         EnterCriticalSection(CriticalSectionMainFormTimer);
         srunning := running;
       finally
         LeaveCriticalSection(CriticalSectionMainFormTimer);
       end;
     until not srunning;

     if talt >= 0 then
     TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;
     sc.getZeileSpalte(Zeile,Spalte);
     TZeilenInformation(shc.Zeile.Objects[Zeile]).Hintergrundfarbe := Schrittfarbe;
     talt := Zeile;
     shc.PositionSichtbar(Zeile,0);
     shc.Paint;

     SBPause.Visible := false;
     SBStart.Visible := true;
     SBSchritt.Visible := true;

     if variablenzeigen then variablenausgabe;
   end;
end;

procedure TFMain.StopExecute(Sender: TObject);
begin
   if BBearbeiten.Visible then
   begin
     run := false; 
     repeat until not running;

     shc.clearColor;
     init;
     FehlerVerwaltung.loescheFehler(1);
     shc.setCursorText(0,0);
     shc.positionsichtbar(0,0);
     shc.Paint;
     SBPause.Visible := false;
     SBStart.Visible := true;
     SBSchritt.Visible :=true;

     if Variablenzeigen then variablenausgabe;
   end;
end;

procedure TFMain.SchrittExecute(Sender: TObject);
Var StopWarDa: Boolean;
begin
  if BBearbeiten.Visible then
  begin
   shc.Paint;
     if not (sc.EndofText or interpreter.Fehler or running) then
     begin
         FehlerVerwaltung.loescheFehler(1);

           if not (sc.EndofText or interpreter.Fehler ) then
           begin
              try
                EnterCriticalSection(CriticalSectionVariablenzugriff);
                interpreter.schritt(true, StopWarDa);
              finally
                LeaveCriticalSection(CriticalSectionVariablenzugriff);
                Schrittkennzeichnen;
                variablenausgabe;
                shc.Paint; shc.SetFocus;
                FehlerVerwaltung.ListBoxAktualisieren;
              end;
           end;
     end;
  end;
end;

procedure TFMain.InhaltdesZeichenfenstersKopierenClick(Sender: TObject);
begin
  Application.MessageBox('Klicken Sie mit der rechten Maustaste auf das Zeichenfenster!','Tipp:',MB_OK);
end;

procedure TFMain.RueckgaengigUpdate(Sender: TObject);
begin
   Rueckgaengig.Enabled := (shc.UndoAnzahl > 0) and BStarten.Visible;
end;

procedure TFMain.RedoExecute(Sender: TObject);
begin
   if not BBearbeiten.Visible then
      shc.Redo;
end;

procedure TFMain.RedoUpdate(Sender: TObject);
begin
   Redo.Enabled := (shc.RedoAnzahl > 0) and BStarten.Visible;
end;

procedure TFMain.Schrittkennzeichnen;
Var Zeile, Spalte: Integer;
begin
   sc.getZeileSpalte(Zeile,Spalte);
   if Zeile > shc.Zeile.Count -1 then Zeile := shc.Zeile.Count -1;
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     TZeilenInformation(shc.Zeile.Objects[talt]).Hintergrundfarbe := clwhite;
     TZeilenInformation(shc.Zeile.Objects[Zeile]).Hintergrundfarbe := Schrittfarbe;
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
   talt := Zeile;
   variablenausgabe;
   shc.PositionSichtbar(Zeile,0);
   shc.Paint;
end;

end.
