unit UUndo;

interface

uses Classes;

type
TUndoArt = (UErsetzen, ULoeschen, UEinfuegen, UZeilenUmbruch);

TUndoSchritt = class(TObject)
private
    zeilen: TStrings; // Liste der gepufferten Zeilen
public
    erste: Integer;   // Index der ersten Zeile im Programmtext
    AnzahlLoeschen: Integer;
    cZeile, cSpalte: Integer; // Auf welche Position soll der Cursor zurckgesetzt werden?
    ZweiSchritte: Boolean; // Gehrt der nchste Schritt mit dazu?
    Art: TUndoArt;
  procedure MachRueckgaengig(text: TStrings);  // Macht den gespeicherten Schritt beim bergebenen Programmtext rckgngig.
  procedure ZeilenPuffern(text: TStrings; Erste, Anzahl: Integer);
  procedure init;
  constructor Create;
  destructor Destroy; override;
published

end;



TUndo = class(TObject)
private
   UndoSchritte: Array of TUndoSchritt;
   Kapazitaet: Integer; // Wie viele Schritte werden maximal gespeichert?
   Letzter: Integer;    // Index des letzten gespeicherten Schrittes im obigen Array (0..Kapazitaet -1)
   FUndoAnzahl: Integer;     // Wie viele UndoSchritte sind momentan gespeichert?
   FRedoAnzahl: Integer;     // Wie viele RedoSchritte sind momentan gespeichert?
   cZeile, cSpalte: Integer; // Zeile und Spalte, auf die der Cursor auf Grund des letzten rckgngig
                             // gemachten Schritts gesetzt werden soll
   KommenZweiSchritte: Boolean; // Es kommen zwei Schritte, die zusammengehren, z.B. wenn die Eingabe
                                // eines Zeichens einen markierten Bereich lscht
protected

public
  property UndoAnzahl: Integer read FUndoAnzahl;
  property RedoAnzahl: Integer read FRedoAnzahl;

  // Schritte werden mit neuerSchritt angelegt. bergeben wird eine Referenz auf den
  // kompletten Programmtext, die Nummer der ersten Zeile, die verndert wird (0,1,...) und
  // die Anzahl der Zeilen, die verndert werden. Auerdem die Art und weise, wie der
  // Schritt wieder rckgngig gemacht werden soll.
  // Wurden Zeilen nur verndert, dann UErsetzen
  // wurden Zeilen eingefgt, dann ULoeschen
  // wurden Zeilen gelscht, dann UEinfuegen
  procedure neuerSchritt(text: TStrings; erste: Integer;
        AnzahlLoeschen, AnzahlEinfuegen: Integer;
        Art: TUndoArt; CursorZeile, CursorSpalte: Integer);
  procedure EsKommenZweiSchritte;
  procedure WarDochNurEiner;
  function Rueckgaengig(text: TStrings;
           CursorZeile, CursorSpalte: Integer): boolean; // true, wenn noch ein Schritt da war.
  function Redo(text: TStrings;
           CursorZeile, CursorSpalte: Integer): boolean; // true, wenn noch ein Schritt da war.
  function GetZeile: Integer;
  function GetSpalte: Integer;
  procedure reset;
  constructor Create(Kapazitaet: Integer);
  destructor Destroy; override;
published

end;

implementation

uses USHControl;

{ TUndoSchritt }

constructor TUndoSchritt.Create;
begin
   Zeilen := TStringList.create;
end;

destructor TUndoSchritt.Destroy;
begin
  Zeilen.Free;
  inherited;
end;

procedure TUndoSchritt.init;
begin
   zeilen.Clear;
end;

procedure TUndoSchritt.MachRueckgaengig(text: TStrings);
Var i: integer;
    //Die folgenden Variablen werden mit der Information gefllt, die fr's
    //Redo ntig ist:
    rsl: TStrings;
    rAnzahlLoeschen, rerste: integer;
    rArt: TUndoArt;
begin
   rsl := TStringlist.Create; rerste := 0; rAnzahlLoeschen := 0;
   rArt := UErsetzen;
   case Art of
   ULoeschen: begin
                // Informationen fr's Redo konservieren...
                for i := erste to erste + AnzahlLoeschen - 1 do
                    if i <= text.Count - 1 then
                       rsl.Add(text.Strings[i]);
                rerste := erste; rAnzahlLoeschen := 0; rArt := UEinfuegen;

                for i := 1 to AnzahlLoeschen do
                   if text.Count - 1 >= erste then
                   begin
                      TZeilenInformation(text.Objects[erste]).Free;
                      text.Delete(erste);
                   end;
                   // Die anderen rutschen nach, daher
                   // ist es richtig, immer die erste zu lschen!
              end;
   UEinfuegen: begin
                  // Informationen fr's Redo konservieren...
                  rerste := erste; rAnzahlLoeschen := zeilen.Count; rArt := ULoeschen;

                  for i := 0 to zeilen.Count - 1 do
                     text.Insert(erste + i,zeilen.Strings[i]);
               end;
   UErsetzen: begin
                 // Informationen fr's Redo konservieren...
                 for i := erste to erste + AnzahlLoeschen - 1 do
                    if i <= text.Count - 1 then
                       rsl.Add(text.Strings[i]);
                 rerste := erste; rAnzahlLoeschen := Zeilen.Count; rArt := UErsetzen;

                 for i := 1 to AnzahlLoeschen do
                   if text.Count -1 >= erste then
                   begin
                      TZeilenInformation(text.Objects[erste]).Free;
                      text.Delete(erste);
                   end;
                 for i := 0 to Zeilen.Count - 1 do
                    text.insert(erste,zeilen.Strings[Zeilen.count - 1 - i]);
              end;
   UZeilenUmbruch: begin
                      // Informationen fr's Redo konservieren...
                      for i := erste to erste + 1 do
                          if i <= text.Count - 1 then
                             rsl.Add(text.Strings[i]);
                      rerste := erste; rAnzahlLoeschen := 1; rArt := UErsetzen;

                      text.Strings[erste] := text.Strings[erste] + text.Strings[erste + 1];
                      if text.Count - 1 >= erste + 1 then
                      begin
                      TZeilenInformation(text.Objects[erste+1]).Free;
                      text.Delete(erste+1);
                      end;
              end;
   end; // case
   zeilen.Free; zeilen := rsl;
   AnzahlLoeschen := rAnzahlLoeschen;
   Art := rArt;
   erste := rerste;
end;

procedure TUndoSchritt.ZeilenPuffern(text: TStrings; Erste,
  Anzahl: Integer);
Var i: integer;
begin
   For i := 0 to Anzahl - 1 do
      if text.Count - 1 >= Erste + i then
         zeilen.Add(text.Strings[Erste + i]);
end;

{ TUndo }

constructor TUndo.Create(Kapazitaet: Integer);
var i: integer;
begin
   setlength(UndoSchritte,Kapazitaet);
   self.Kapazitaet := Kapazitaet;
   Letzter := 0; FUndoAnzahl := 0; KommenZweiSchritte := false;
   for i := 0 to Kapazitaet - 1 do
      UndoSchritte[i] := TUndoSchritt.Create;
end;

destructor TUndo.Destroy;
var i: integer;
begin
  for i := 0 to Kapazitaet -1 do
     UndoSchritte[i].Free;
  UndoSchritte := nil; // gibt den Speicher fr das Array frei
  inherited;
end;

procedure TUndo.EsKommenZweiSchritte;
begin
   KommenZweiSchritte := true;
end;

function TUndo.GetSpalte: Integer;
begin
   GetSpalte := cSpalte;
end;

function TUndo.GetZeile: Integer;
begin
   GetZeile := cZeile;
end;

procedure TUndo.neuerSchritt(text: TStrings; erste: Integer;
          AnzahlLoeschen, AnzahlEinfuegen: Integer;
            Art: TUndoArt; CursorZeile, CursorSpalte: Integer);
Var us: TUndoSchritt;
begin
   FRedoAnzahl := 0;
   Letzter := (Letzter + 1) mod Kapazitaet; // Letzter zeigt auf die Position im Puffer, die jetzt benutzt wird
   inc(FUndoAnzahl); if FUndoAnzahl > Kapazitaet then FUndoAnzahl := Kapazitaet;
   us := UndoSchritte[Letzter];
   us.init; // Altes lschen
   us.Art := art;
   us.erste := erste;
   us.AnzahlLoeschen := AnzahlLoeschen;
   us.ZweiSchritte := KommenZweiSchritte;
   KommenZweiSchritte := false;
   us.cZeile := CursorZeile; us.cSpalte := CursorSpalte;
   if Art in [UEinfuegen,UErsetzen] then us.ZeilenPuffern(text,erste,AnzahlEinfuegen);
end;

function TUndo.Redo(text: TStrings; CursorZeile,
  CursorSpalte: Integer): boolean;
Var NochEinSchritt: Boolean;
    erfolgreich: Boolean;
    ersterUndoSchritt: Integer;
begin
   erfolgreich := FRedoAnzahl > 0;
   if FRedoAnzahl > 0 then
   begin
      Letzter := (Letzter + 1) mod Kapazitaet;
      UndoSchritte[Letzter].MachRueckgaengig(text);
      cZeile := UndoSchritte[Letzter].cZeile;
      cSpalte := UndoSchritte[Letzter].cSpalte;
      NochEinSchritt := UndoSchritte[Letzter].ZweiSchritte;
      inc(FUndoAnzahl);
      dec(FRedoAnzahl);
      if NochEinSchritt then
      begin
        Letzter := (Letzter + 1) mod Kapazitaet;
        UndoSchritte[Letzter].MachRueckgaengig(text);
        inc(FUndoAnzahl);
        dec(FRedoAnzahl);
      end;
      ersterUndoSchritt := Letzter;
      UndoSchritte[ersterUndoSchritt].cZeile := CursorZeile;
      UndoSchritte[ersterUndoSchritt].cSpalte := CursorSpalte;
      UndoSchritte[ersterUndoSchritt].ZweiSchritte := NochEinSchritt;
   end;
   Redo := erfolgreich;
end;

procedure TUndo.reset;
begin
   FUndoAnzahl := 0; Letzter := 0; FRedoAnzahl := 0;
end;

function TUndo.Rueckgaengig(text: TStrings; CursorZeile, CursorSpalte: Integer): Boolean;
Var NochEinSchritt: Boolean;
    erfolgreich: Boolean;
    ersterRedoSchritt: Integer;
begin
   erfolgreich := FUndoAnzahl > 0;
   if FUndoAnzahl > 0 then
   begin
      UndoSchritte[Letzter].MachRueckgaengig(text);
      cZeile := UndoSchritte[Letzter].cZeile;
      cSpalte := UndoSchritte[Letzter].cSpalte;
      NochEinSchritt := UndoSchritte[Letzter].ZweiSchritte;
      dec(FUndoAnzahl);
      inc(FRedoAnzahl);
      Letzter := (Letzter - 1 + Kapazitaet) mod Kapazitaet;
      if NochEinSchritt then
      begin
        UndoSchritte[Letzter].MachRueckgaengig(text);
        Letzter := (Letzter - 1 + Kapazitaet) mod Kapazitaet;
        dec(FUndoAnzahl);
        inc(FRedoAnzahl);
      end;
      ersterRedoSchritt := (Letzter + 1) mod Kapazitaet;
      UndoSchritte[ersterRedoSchritt].cZeile := CursorZeile;
      UndoSchritte[ersterRedoSchritt].cSpalte := CursorSpalte;
      UndoSchritte[ersterRedoSchritt].ZweiSchritte := NochEinSchritt;
   end;
   Rueckgaengig := erfolgreich;
end;

procedure TUndo.WarDochNurEiner;
begin
   UndoSchritte[Letzter].ZweiSchritte := false;
end;

end.
