unit UVariablen;

interface

uses SysUtils,UDaten,classes,UKlassen, Graphics,UCountObjects;

const ZweiPIDurch360 = 0.017453292;

type
TVariable = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
   Name: String;
   Wert: TVariant;
   System: boolean;  // vom System generiert (z.B. gelb, ...)
   ObjektNichtLoeschen: boolean; // das zugehrige TObjekt darf nicht gelscht werden
   variantnichtloeschen: boolean;
   breite: integer; // zum Zeichnen
   constructor create;
   destructor destroy; override;
end;

TVarSpace = class (TObject)
  public
   Varlist: TList;

     KontextGrenzen: Array of integer;
     KontextCount: integer; // Anzahl der Kontexte
     KontextPlatz: integer; // Wie gro ist das Feld gerade?

   // Damit beim Berechnen von Funktionsparametern rekursiver Funktionen nicht gleich die Parameter
   // verwendet werden, die gerade bergeben werden.
   NichtNeuerKontext: Boolean;

   procedure add(Name: String; wert: TVariant; System, Objektnichtloeschen: Boolean);
   procedure addlocal(Name: String; wert: TVariant; Variantnichtloeschen, Objektnichtloeschen: Boolean);
   function get(Name: String):TVariant;
   procedure ClearNonSystemVariables;
     procedure NeuerKontext; // Legt einen neuen Kontext an - beim Aufruf einer Methode fr die lokalen Variablen und Parameter
     procedure ClearKontext; // Leert obersten Kontext - beim Verlassen einer Methode
   constructor create;
   destructor destroy; override;

   // Systemprozeduren
   procedure msin(st:TStack);
   procedure mcos(st:TStack);
   procedure mtan(st:TStack);
   procedure marctan(st: TStack);
   procedure mround(st:TStack);
   procedure mtrunc(st:TStack);
   procedure mzufall(st:TStack);
   private
end;




implementation

{ TVarSpace }

procedure TVarSpace.add(Name: String; wert: TVariant; System, Objektnichtloeschen: Boolean);
Var v: TVariable;
begin
   v := TVariable.create;
   v.Name := lowercase(name);
   v.Wert := wert;
   v.System := System;
   v.ObjektNichtLoeschen := Objektnichtloeschen;
   v.variantnichtloeschen := false;
   varlist.Add(v);
end;

procedure TVarSpace.addlocal(Name: String; wert: TVariant;
  Variantnichtloeschen, Objektnichtloeschen: Boolean);
Var v: TVariable;
begin
   v := TVariable.create;
   v.Name := lowercase(name);
   v.Wert := wert;
   v.System := false;
   v.ObjektNichtLoeschen := Objektnichtloeschen;
   v.variantnichtloeschen := variantnichtloeschen;
   varlist.Add(v);
end;


procedure TVarSpace.ClearKontext;
Var i,j, start: integer;
    v: TVariable;
//    o,f: TObjekt;
begin
   if KontextCount > 0 then
   begin
      start := KontextGrenzen[KontextCount - 1];
      dec (KontextCount);

{      // lokale Objekte bei den Fenstern deregistrieren!
      for i := start to varlist.Count -1 do
         begin
           if TVAriable(Varlist.Items[i]).Wert.Typ = vtObjekt then
           begin
           o := TVariable(Varlist.Items[i]).Wert.o;
           if o <> nil then
              if (o.ci <> 41)
                   and not TVariable(Varlist.Items[i]).ObjektNichtLoeschen  then
               begin
                 for j := 0 to varlist.Count -1 do
                 begin
                   if TVAriable(Varlist.Items[j]).Wert.Typ = vtObjekt then
                   begin
                     f := TVariable(Varlist.Items[j]).Wert.o;
                     if f <> nil then if (o.ci <> 41) then
                     begin
                        TFenster(f).removeObjekt(o);
                     end;
                   end;
                 end; // Schleife ber alle Fenster
               end;
           end;
         end;
}
       for i := start to VarList.Count - 1 do
       begin
          v := TVariable(Varlist.Items[i]);
          if not v.ObjektNichtLoeschen then
             begin
                if v.Wert.Typ = vtObjekt then v.Wert.o.Free;
// Die TVariant s kommen vom Stack. der Kmmer sich ums lschen!
//                v.Wert.Free;
             end;
          v.Free;
       end;
       j := varlist.Count -1;
       for i := start to j do varlist.Delete(varlist.Count-1);
   end;
end;

procedure TVarSpace.ClearNonSystemVariables;
Var i: integer;
    v: TVariable;
begin
  i := 0;
  while (i <= varlist.Count - 1) do
  begin
    v := TVariable(Varlist.Items[i]);
    if not v.System then
       begin
          v.Free;
          Varlist.Delete(i);
       end else inc(i);
  end;
end;

constructor TVarSpace.create;
Var c: TFarbe;
    m: TMethode;
begin
   varlist := TList.Create;

   KontextPlatz := 100;
   // Platz fr Indizes 0..KontextPlatz - 1
   setlength(KontextGrenzen,KontextPlatz);
   KontextCount := 0;

   NichtNeuerKontext := false;

   // Konstanten
   //***********
// Farben
   c := TFarbe.create('schwarz',nil,false);
   c.setzergb(0,0,0);
   add('schwarz',TVariant.create(c),true,false);

   c := TFarbe.create('wei',nil,false);
   c.setzergb(255,255,255);
   add('wei',TVariant.create(c),true,false);

   c := TFarbe.create('weiss',nil,false);
   c.setzergb(255,255,255);
   add('weiss',TVariant.create(c),true,false);

   c := TFarbe.create('blau',nil,false);
   c.setzergb(0,0,255);
   add('blau',TVariant.create(c),true,false);

   c := TFarbe.create('rot',nil,false);
   c.setzergb(255,0,0);
   add('rot',TVariant.create(c),true,false);

   c := TFarbe.create('grn',nil,false);
   c.setzergb(0,128,0);
   add('grn',TVariant.create(c),true,false);

   c := TFarbe.create('gruen',nil,false);
   c.setzergb(0,128,0);
   add('gruen',TVariant.create(c),true,false);

   c := TFarbe.create('gelb',nil,false);
   c.setzergb(255,255,0);
   add('gelb',TVariant.create(c),true,false);

   c := TFarbe.create('grau',nil,false);
   c.setzergb($80,$80,$80);
   add('grau',TVariant.create(c),true,false);

   c := TFarbe.create('hellgrau',nil,false);
   c.setzergb($C0,$C0,$C0);
   add('hellgrau',TVariant.create(c),true,false);

   c := TFarbe.create('hellblau',nil,false);
   c.setzergb($A6,$CA,$F0);
   add('hellblau',TVariant.create(c),true,false);

   c := TFarbe.create('hellgrn',nil,false);
   c.setzergb(00,255,00);
   add('hellgrn',TVariant.create(c),true,false);

   c := TFarbe.create('hellgrn',nil,false);
   c.setzergb(00,255,00);
   add('hellgrn',TVariant.create(c),true,false);

   c := TFarbe.create('braun',nil,false);
   c.setzergb($80,$80,$00);
   add('braun',TVariant.create(c),true,false);


// Linienstile
   add('gestrichelt',TVariant.create(Integer(psDash)),true,false);
   add('durchgezogen',TVariant.create(Integer(psSolid)),true,false);
   add('gepunktelt',TVariant.create(Integer(psDot)),true,false);
   add('gestrichpunktelt',TVariant.create(Integer(psDashDot)),true,false);
   add('unsichtbar',TVariant.create(Integer(psClear)),true,false);
// Fllungsstile
   add('ausgemalt', TVariant.create(Integer(bsSolid)),true,false);
   add('schraffiert', TVariant.create(Integer(bsBDiagonal)),true,false);
   add('kariert', TVariant.create(Integer(bsCross)),true,false);
   add('durchsichtig',TVariant.create(Integer(bsClear)),true,false);
// Ausrichtung
   add('zentriert',TVariant.create(0),true,false);
   add('linksbndig',TVariant.create(1),true,false);
   add('rechtsbndig',TVariant.create(2),true,false);
   add('obenbndig',TVariant.create(1),true,false);
   add('untenbndig',TVariant.create(2),true,false);

// *************************
// * SystemProzeduren
   m := TMethode.create(msin,vtdouble,0);
   m.addparameter('Winkel in Grad',vtDouble,0);
   add('sin',TVariant.create(m),true,false);


   m := TMethode.create(mcos,vtdouble,0);
   m.addparameter('Winkel in Grad',vtDouble,0);
   add('cos',TVariant.create(m),true,false);

   m := TMethode.create(mtan,vtdouble,0);
   m.addparameter('Winkel in Grad',vtDouble,0);
   add('tan',TVariant.create(m),true,false);

   m := TMethode.create(mArcTan,vtdouble,0);
   m.addparameter('Wert',vtDouble,0);
   add('arctan',TVariant.create(m),true,false);

   m := TMethode.create(mround,vtInteger,0);
   m.addparameter('Zu rundende Zahl',vtDouble,0);
   add('round',TVariant.create(m),true,false);

   m := TMethode.create(mtrunc,vtInteger,0);
   m.addparameter('Zu rundende Zahl',vtDouble,0);
   add('trunc',TVariant.create(m),true,false);

   m := TMethode.create(mZufall,vtInteger,0);
   m.addparameter('Von',vtInteger,0);
   m.addparameter('Bis',vtInteger,0);
   add('zufall',TVariant.create(m),true,false);

end;

destructor TVarSpace.destroy;
Var i: integer;
    //o: TObjekt;
begin
// Fenster wurden schon von TInterpreter geschlossen, daher ist der Rest hier
// auskommentiert!

{  for i := 0 to varlist.Count -1 do
     if TVAriable(Varlist.Items[i]).Wert.Typ = vtObjekt then
     begin
     o := TVariable(Varlist.Items[i]).Wert.o;
     if o <> nil then
        if (o.ci = 41) and assigned(o) and
           ( not TVariable(Varlist.Items[i]).ObjektNichtLoeschen)  then
         begin
         if (TFenster(o).form <> nil) then
             if(TFenster(o).form.dc <> nil) then
                  TFenster(o).form.dc.painterlaubt := false;
         if TFenster(o).form <> nil then
         TFenster(o).form.Close;
         end;
     end;

  for i := 0 to varlist.Count -1 do
     begin
       if TVariable(Varlist.Items[i]).Wert.Typ = vtObjekt then
       begin
         o := TVariable(Varlist.Items[i]).Wert.o;
         if o <> nil then
          if (o.ci = 41) and (o <> nil) and
             ( not TVariable(Varlist.Items[i]).ObjektNichtLoeschen) then
           begin
           TFenster(o).Free;
           TVariable(Varlist.Items[i]).Wert.o := nil;
           end;
       end;
     end;
}

  while KontextCount >= 1 do ClearKontext;

  for i := 0 to varlist.Count - 1 do
  begin
    TVariable(Varlist.Items[i]).Free;
    Varlist.Items[i] := nil;
  end;
  varlist.Free;

  KontextGrenzen := nil;

  inherited;
end;

function TVarSpace.get(Name: String): TVariant;
Var i, bis: integer;
    v: TVariant;
begin
   v := nil;

   if not NichtNeuerKontext then
   begin
     // Lokale Variablen durchsuchen
     if KontextCount > 0 then
     begin
         i := KontextGrenzen[KontextCount - 1];
         while (i < varlist.Count) and ( v = nil) do
         begin
            if lowercase(TVariable(varlist.Items[i]).Name) = lowercase(name) then
               v := TVariable(varlist.Items[i]).Wert
               else inc(i);
         end;
     end;
   end;
   // Globale Variablen durchsuchen
   if v = nil then
   begin
     if KontextCount > 0 then bis := KontextGrenzen[KontextCount - 1]
        else bis := varlist.Count;
     i := bis - 1;
     while (i >= 0) and ( v = nil) do
     begin
        if lowercase(TVariable(varlist.Items[i]).Name) = lowercase(name) then
           v := TVariable(varlist.Items[i]).Wert
           else dec(i);
     end;
   end;
   get := v;
end;


procedure TVarSpace.marctan(st: TStack);
begin
  st.pushDouble(ArcTan(st.popdouble)/ZweiPIDurch360);
end;

procedure TVarSpace.mcos(st: TStack);
begin
    st.pushDouble(cos(st.popdouble*ZweiPIDurch360));
end;

procedure TVarSpace.mround(st: TStack);
begin
   st.pushInteger(round(st.popdouble));
end;

procedure TVarSpace.msin(st:TStack);
begin
    st.pushDouble(sin(st.popdouble*ZweiPIDurch360));
end;

procedure TVarSpace.mtan(st: TStack);
var d: double;
begin
    d := st.popdouble*ZweiPIDurch360;
    st.pushDouble(sin(d)/cos(d));
end;

procedure TVarSpace.mtrunc(st: TStack);
begin
   st.pushInteger(trunc(st.popdouble));
end;

procedure TVarSpace.mzufall(st: TStack);
Var von,bis,zahl: integer;
begin
   bis := st.popInteger;
   von := st.popInteger;
   zahl := 1;
   if von < bis then
      zahl := random(bis - von + 1) + von;
   st.pushInteger(zahl);
end;

procedure TVarSpace.NeuerKontext;
begin
   if KontextCount + 1 > KontextPlatz then
   begin
      KontextPlatz := KontextPlatz + 100;
      setlength(KontextGrenzen,KontextPlatz);
   end;
   inc(KontextCount);
   KontextGrenzen[KontextCount - 1] := VarList.Count; // Ab diesem Index muss nachher gesucht werden
end;

{ TVariable }

constructor TVariable.create;
begin
inherited create;
System := false; ObjektNichtLoeschen := false;
end;

destructor TVariable.destroy;
begin
  if (wert.Typ = vtObjekt) and (not ObjektNichtLoeschen) then
  begin
     wert.o.Free;
     wert.o := nil;
  end;

  if (wert.Typ = vtMethode) and (not ObjektNichtLoeschen) then
  begin
     wert.m.Free;
     wert.m := nil;
  end;
  if not variantnichtloeschen then wert.Free;
  inherited;
end;

{ TVarStack }





end.
