unit UDaten;

interface

uses Windows, SysUtils,classes, forms, Graphics, Controls, ExtCtrls,
     UCountObjects, Clipbrd;

type
TStack = class;
TMethodenProzedur = procedure (st:Tstack) of Object;
TObjekt = class ;
TVariant = class;
TMethodenTyp = (mtObjektMethode, mtSystem, mtSelbstgeschrieben, mtSetzeMethode);
TVarType = (vtBoolean, vtChar, vtInteger, vtDouble, vtString, vtObjekt, vtAblaufSteuerung, vtMethode, vtKeiner);
TAblaufsteuerung = (asWiederholeImmer, asWiederholeN {+AnfBlock+RestCount},asWiederholeSolange {+AnfBed},
                    asWiederholeEndBed {+AnfBlock}, asWiederholeBisBedingung {+AnfBlock},
                    asWennBedingungDann {Boolean: War Bed. erfllt?}, asImSonstBlock,
                    asSolangeBedingung{+AnfBed},
                    asReturnTo, {+ReturnProgrammZeiger}
                    asKeine);

TDrawCanvas = class(TObject)

// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
public
   bm: TBitmap;
   c: TCanvas;
   chinter1, chinter2: TColor;
   Hintergrundfarbe, Gitterfarbe: TColor;
   xmin, xmax, ymin, ymax: integer;
   pb: TPaintBox;
   Gitterein: Boolean;
   Gitterabstand: integer;

   ObjectsToPaint: TList; // Liste mit allen Objekten (TObjekt), die ge-
                          // zeichnet werden sollen (auer TTurtle)
   TurtlesToPaint: TList; // List
   Painterlaubt: Boolean;
   function xWtoScr(x: double): Integer;
   function yWtoScr(y: double): Integer;
   function xScrtoW(x: integer):Integer;
   function yScrtoW(y: integer):Integer;
   procedure addObject(Objekt: TObjekt);
   procedure removeObject(Objekt: TObjekt);
   procedure toFront(Objekt: TObjekt);
   procedure toBack(Objekt: TObjekt);
   procedure paintall(Sender: TObject);
   procedure resize;
   procedure copy;
   constructor create(pb: TPaintbox);
   destructor destroy; override;
end;

TVData = packed record
    vs: String;
    vo: TObject;
    case VarType: TVarType of
       vtBoolean: (vb: Boolean);
       vtChar   : (vc: Char);
       vtInteger: (vi: Integer);
       vtDouble: (vd: Double);
       vtAblaufsteuerung: (va: TAblaufsteuerung);
    end;

TAttribut = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
   public
     versteckt: boolean;
     Name: String;
     Objekt: TObjekt;    // Zu welchem Objekt gehrt das Attribut?
     Wert: TVariant;
     ci: integer;  // Klassenindex (wenn Attribut ein Objekt ist)
     procedure wurdegeaendert;
     constructor create(Name: String; objekt: TObjekt; Typ: TVarType; ci: Integer);
     destructor destroy; override;
end;

TParameter = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
   public
      Name: String;
      typ: TVarType;
      ci: Integer; // Klassenindex!
      Variablenparameter: Boolean;
end;

TMethode = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
  public
  Typ: TMethodenTyp; //mtObjektMethode, mtSelbstgeschrieben, mtSystem
  versteckt: boolean;
  Name: String;
  parameter: TList; // Liste mit Parametern
  Objekt: TObjekt; // zu welchem Objekt gehrt die Methode?
  Nummer: Integer; // wird dem Objekt beim Aufruf bergeben, damit es wei,
                   // welche Methode ausgefhrt werden soll.
  Rueckgabeparameter: TParameter;
  MethodenProzedur: TMethodenProzedur;
  Einsprungadresse: integer; // falls selbstgeschrieben
  Attribut: TAttribut; // falls typ = mSetzeMethode
  procedure addparameter(Name: String; Typ: TVarType; ci: Integer);
  procedure addvarparameter(Name: String; Typ: TVarType; ci: Integer; Variablenparameter: Boolean);
  function getparameter(Name: String): TParameter;
  constructor create(Name: String; Objekt: TObjekt; Nummer: Integer; Rueckgabetyp: TVarType; rueckci: Integer); overload;
  constructor create(MethodenProzedur: TMethodenProzedur; Rueckgabetyp: TVarType; rueckci: Integer); overload;
  constructor create(Einsprungadresse: integer); overload;
  constructor create(a: TAttribut); overload;
  destructor destroy; override;
end;

TObjekt = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
   public
     name, Klassenname: String;
     ci: Integer; // KLassenindex!
     owner: TObjekt; // Z.B. Farbe hat als Owner ein Rechtek, ...
     // Beim Vererben folgen hier die Attribute, z.B.:
     // r: TAttribut;
     attribute: TList;
     methoden: TList;
     zeichenbar: Boolean;
     procedure CreateSetzeMethoden(inheritedFlag: Boolean);
     function GetAttribut(name: String):TAttribut;
     function GetMethode(name: String):TMethode;
     procedure AddAttribut(a: TAttribut);
     procedure AddMethode(m: TMethode);
     procedure attributaenderung(a: TAttribut); virtual; abstract;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); virtual; abstract;
     procedure paint(c: TDrawCanvas); virtual; abstract;
     function Kopie(Name: string; owner: TObjekt): TObjekt; virtual; abstract;
     procedure copyfrom(o: TObjekt); virtual;

     constructor create(name: String; Owner: TObjekt; inheritedFlag: Boolean);
     destructor destroy; override;
end;

TVariant = class(TObject)
// {$IFDEF OBJECTCOUNT} class(TObjectc) {$ELSE} class(TObject) {$ENDIF}
  private
    vd: TVData;
    procedure Setb (const Value: Boolean);
    function Readb: Boolean;
    procedure Setc (const Value: Char);
    function Readc: Char;
    procedure Seti(const Value: Integer);
    function Readi: Integer;
    procedure Setd(const Value: Double);
    function Readd: double;
    procedure Seto(const Value: TObjekt);
    function Reado: TObjekt;
    procedure Setm(const Value: TMethode);
    function Readm: TMethode;
    procedure Sets(const Value: String);
    function Reads: String;
    procedure setTyp(const Typ: TVarType);
    function GetTyp: TVarType;
    procedure setAs(const Value: TAblaufSteuerung);
    function getAs: TAblaufsteuerung;
//    procedure SetObjekt(const Value: TObjekt);
//    function ReadObjekt(const Value: TObjekt);

    procedure error(s: String);
    procedure copyfrom(v: TVariant);
public
    attribut: TAttribut;
    veraendert: Boolean;
    function TypName: String;
    function toSTring: String;
    property b: Boolean read Readb write Setb;
    property c: Char read Readc write Setc;
    property i: Integer read Readi write Seti;
    property d: Double read Readd write Setd;
    property o: TObjekt read Reado write Seto;
    property m: TMethode read Readm write Setm;
    property s: String read Reads write Sets;
    property ast: TAblaufSteuerung read GetAs write SetAs;
    property Typ: TVarType read GetTyp write SetTyp;
    constructor create; overload;
    constructor create(o: TObjekt); overload;
    constructor create(i: Integer); overload;
    constructor create(m: TMethode); overload;
end;

TStack = class (TObject)
private
   a: array of TVariant;
   p: Integer; // Stackzeiger, zeigt auf das nchste freie Element
   anzahl: Integer; // Anzahl der Elemente, die auf den Stack passen
   procedure machplatz;
public
   function oberstesElement: TVariant;
   function Typ: TVarType;
   function pop: TVariant;
   procedure pushInteger(i: Integer);
   procedure pushDouble (d: double);
   procedure pushString (s: String);
   procedure pushObjekt (o: TObjekt);
   procedure pushBoolean(b: Boolean);
   procedure pushChar (c: char);
   procedure pushVariant(v: TVariant);
   procedure pushAblaufSteuerung(ast: TAblaufsteuerung);
   function popAblaufSteuerung: TAblaufsteuerung;
   function popInteger: Integer;
   function popdouble: double;
   function popString: String;
   function popObjekt: TObjekt;
   function popBoolean: Boolean;
   function popChar: Char;
   constructor create;
   destructor destroy; override;
end;


implementation

uses UKlassen;

{ TDrawCanvas }

procedure TDrawCanvas.addObject(Objekt: TObjekt);
begin
  if Objekt.ci = 2*31 then
     begin
     if TurtlesToPaint.IndexOf(Objekt) = -1 then
     TurtlesToPaint.Add(Objekt);
     end
     else
       if ObjectsToPaint.IndexOf(Objekt) = -1 then
           ObjectsToPaint.Add(Objekt);
end;

constructor TDrawCanvas.create(pb: TPaintbox);
begin
   inherited create;
   ObjectsToPaint := TList.Create;
   TurtlesToPaint := TList.Create;
   self.pb := pb;
   pb.OnPaint := paintall;
   bm := TBitmap.Create;
   bm.Width := pb.Width; bm.Height := pb.Height;
   c := bm.Canvas;
   Painterlaubt := true;
   Hintergrundfarbe := TColor($808081);
   Gitterfarbe := TColor($C0C0C1);
end;

procedure TDrawCanvas.removeObject(Objekt: TObjekt);
begin
   ObjectstoPaint.Remove(Objekt);
   TurtlesToPaint.Remove(Objekt);
end;

destructor TDrawCanvas.destroy;
begin
  ObjectsToPaint.Free;
  TurtlesToPaint.Free;
  pb.OnPaint := nil;
//  pb.Repaint;
  bm.Free;
  inherited;
end;

procedure TDrawCanvas.paintall(Sender: TObject);
Var i: integer;
    o : TObjekt;
    t: TTurtle;
begin
   if painterlaubt then
   begin
     with c do
     begin
     Brush.Style := bsSolid;
     Brush.Color := Hintergrundfarbe;
     pen.Style := psSolid;
     pen.Color := Hintergrundfarbe;
     pen.Width := 1;
     Rectangle(0,0,pb.Width+1, pb.Height+1);
     chinter1 := Pixels[0,0];
     Pen.Color := clBlack;
     end;
     if Gitterein then
     begin
        c.Pen.Color := Gitterfarbe;
        for i := 0 to round(xmin/Gitterabstand) do
        begin
           c.moveto(xmin+i*Gitterabstand,0);
           c.lineto(xmin+i*Gitterabstand,bm.height);
           c.moveto(xmin-i*Gitterabstand,0);
           c.lineto(xmin-i*Gitterabstand,bm.height);
        end;
        for i := 0 to round(ymin/Gitterabstand) do
        begin
           c.moveto(0,ymin+i*Gitterabstand);
           c.lineto(bm.Width,ymin+i*Gitterabstand);
           c.moveto(0,ymin-i*Gitterabstand);
           c.lineto(bm.Width,ymin-i*Gitterabstand);
        end;
        c.Pen.Width := 3;
        c.MoveTo(xmin,0); bm.Canvas.lineto(xmin,bm.Height);
        c.MoveTo(0,ymin); bm.Canvas.LineTo(bm.Width,ymin);
        c.Pen.Width := 1;
        chinter2 := c.Pixels[xmin,0];
     end;

     for i := 0 to ObjectsToPaint.Count - 1 do
     begin
        o := TObjekt(ObjectsToPaint.Items[i]);
        if assigned(o) then o.paint(self);
     end;

     for i := 0 to TurtlesToPaint.Count - 1 do
     begin
        t := TTurtle(TurtlesToPaint.Items[i]);
        if assigned(t) then t.TestAufVorPunkt(self);
     end;

     for i := 0 to TurtlesToPaint.Count - 1 do
     begin
        o := TObjekt(TurtlesToPaint.Items[TurtlesToPaint.Count-1-i]);
        if assigned(o) then o.paint(self);
     end;
     // wenn c <> bm.canvas, dann wird in die Zwischenablage kopiert!
     if c = bm.canvas then pb.Canvas.CopyRect(Rect(0,0,bm.Width,bm.height),c,Rect(0,0,pb.Width,pb.Height));
   end;
end;

procedure TDrawCanvas.resize;
begin
   bm.Width := pb.Width;
   bm.Height := pb.Height;
   xmin := round(bm.Width / 2);
   ymin := round(bm.height /2);
end;

procedure TDrawCanvas.toBack(Objekt: TObjekt);
Var i: integer;
begin
   i := ObjectsToPaint.IndexOf(Objekt);
   ObjectsToPaint.move(i,0);
end;

procedure TDrawCanvas.toFront(Objekt: TObjekt);
Var i: integer;
begin
   i := ObjectsToPaint.IndexOf(Objekt);
   ObjectsToPaint.move(i,ObjectsToPaint.Count-1);
end;

function TDrawCanvas.xWtoScr(x: double): Integer;
begin
 //   xWtoScr := round( ( (x-xmin)/(xmax - xmin) )* pb.width);
      xWtoScr := round(x)+xmin;
end;

function TDrawCanvas.yWtoScr(y: double): Integer;
begin
//   yWtoScr := round( ( (y-ymin)/(ymax - ymin) )*pb.height);
     yWtoScr := (-1)*round(y) + ymin;
end;

function TDrawCanvas.xScrtoW(x: integer): Integer;
begin
   xScrtoW := x - xmin;
end;

function TDrawCanvas.yScrtoW(y: integer): Integer;
begin
   yScrtoW := ymin - y;
end;

procedure TDrawCanvas.copy;
var mfc : TMetafileCanvas;
    AFormat: Word;
    AData: THandle;
    APalette: HPALETTE;
    mf: TMetafile;
begin
mf := TMetafile.Create;
mf.width := bm.width;
mf.height := bm.height;
mfc := TMetaFileCanvas.Create(mf,0);

c := mfc;

paintall(self);

c := bm.Canvas;

mfc.Destroy;
mf.SaveToClipboardFormat(AFormat,AData,APalette);
Clipboard.SetAsHandle(AFormat,AData);
mf.Free;
end;

{ TVariant }

procedure TVariant.error(s: String);
begin
   //TApplication.messageBox(PChar(s),'Fehler beim Variant:');
end;

function TVariant.Readb: Boolean;
begin
   case vd.VarType of
      vtBoolean : Readb := vd.vb;
   else
     begin
       error ('Versuch, unerlaubt nach Boolean zu konvertieren!');
       Readb := false;
     end;
   end; // case
end;

function TVariant.Readc: Char;
begin
   if vd.VarType = vtChar then Readc := vd.vc
   else if vd.VarType = vtInteger then
           begin
              if (vd.vi <= 255) and (vd.vi >= 0) then
                      Readc := chr(vd.vi)
                      else
                      begin
                         error('Integer Wert nicht nach char konvertierbar');
                         Readc := chr(0);
                      end;
           end
             else
                begin
                   error('Versuch, unerlaubt nach char zu konvertieren!');
                   Readc := chr(0);
                end;
end;


function TVariant.Readd: double;
begin
   case vd.VarType of
     vtDouble: Readd := vd.vd;
     vtInteger: Readd := vd.vi;
     vtchar: Readd := ord(vd.vc);
   else
     begin
        error('Unzulssiger Versuch, nach Double zu konvertieren!');
        Readd := 0;
     end;
   end;  // case
end;

function TVariant.Readi: Integer;
begin
   case vd.VarType of
     vtInteger: Readi := vd.vi;
     vtChar: Readi := ord(vd.vc);
   else
      begin
        error('Unzulssiger Versuch, nach Integer zu konvertieren!');
        Readi := 0;
      end;
   end; // case
end;

function TVariant.Reado: TObjekt;
begin
   if vd.VarType = vtObjekt then
      Reado := TOBjekt(vd.vo)
   else
      begin
      error('Versuch, eine Object-Variable zu lesen, wo keine vorliegt!');
      Reado := nil;
      end;
end;

function TVariant.Reads: String;
begin
   if vd.VarType = vtString then
      Reads := vd.vs
   else error('Versuch, eine String-Variable zu lesen, wo keine vorliegt!');
end;

procedure TVariant.Setb(const Value: Boolean);
begin
   if vd.VarType = vtString then vd.vs := '';
   vd.vb := Value;
   vd.VarType := vtBoolean;
   veraendert := true;
end;

procedure TVariant.Setc(const Value: Char);
begin
   if vd.VarType = vtString then vd.vs := '';
   vd.vc := Value;
   vd.VarType := vtChar;
   veraendert := true;
end;

procedure TVariant.Setd(const Value: Double);
begin
   if vd.VarType = vtString then vd.vs := '';
   vd.vd := Value;
   vd.VarType := vtDouble;
   veraendert := true;
end;

procedure TVariant.Seti(const Value: Integer);
begin
  if vd.VarType = vtString then vd.vs := '';
  vd.vi := Value;
  vd.Vartype := vtInteger;
   veraendert := true;
end;

procedure TVariant.Seto(const Value: TObjekt);
begin
  if vd.VarType = vtString then vd.vs := '';
  vd.vo := Value;
  vd.Vartype := vtObjekt;
   veraendert := true;
end;

procedure TVariant.Sets(const Value: String);
begin
   vd.vs := Value;
   vd.vartype := vtString;
   veraendert := true;
end;

procedure TVariant.setTyp(const Typ: TVarType);
begin
   if (vd.VarType = vtString) and (Typ <> vtString) then vd.vs := '';
   vd.VarType := Typ;
end;

function TVariant.GetTyp: TVarType;
begin
   GetTyp := vd.VarType;
end;

function TVariant.getAs: TAblaufsteuerung;
Var ast: TAblaufsteuerung;
begin
   Ast := asKeine;
   if vd.VarType <> vtAblaufsteuerung then error('Versuch, eine TAblaufsteuerung aus TVariant zu lesen, obwohl keine da war.')
   else Ast := vd.va;
   getAs := ast;
end;

procedure TVariant.SetAs(const Value: TAblaufSteuerung);
begin
  if vd.VarType = vtString then vd.vs := '';
  vd.va := Value;
  vd.Vartype := vtAblaufSteuerung;
end;

constructor TVariant.create(o: TObjekt);
begin
   inherited create;
   Seto(o);
end;

constructor TVariant.create(i: Integer);
begin
   inherited create;
   Seti(i);
end;

procedure TVariant.copyfrom(v: TVariant);
begin
   vd := v.vd;
end;

function TVariant.TypName: String;
Var s: string;
begin
   s := '';
   case vd.VarType of
   vtBoolean : s := 'Boolean';
   vtChar    : s := 'Char';
   vtInteger : s := 'Integer';
   vtDouble  : s := 'Real';
   vtString  : s := 'String';
   vtObjekt  : s := 'Objekt';
   end;
   TypName := s;
end;

function TVariant.Readm: TMethode;
begin
   if vd.VarType = vtMethode then
      Readm := TMethode(vd.vo)
   else
      begin
      error('Versuch, eine TMethode-Variable zu lesen, wo keine vorliegt!');
      Readm := nil;
      end;
end;

procedure TVariant.Setm(const Value: TMethode);
begin
  if vd.VarType = vtString then vd.vs := '';
  vd.vo := Value;
  vd.Vartype := vtMethode;
  veraendert := true;
end;

constructor TVariant.create(m: TMethode);
begin
   inherited create;
   setm(m);
end;

function TVariant.toSTring: String;
var s: string;
begin
   case vd.VarType of
   vtBoolean: begin
                if vd.vb then s := 'wahr' else s := 'falsch';
              end;
   vtChar: s := vd.vc;
   vtInteger: s := inttostr(vd.vi);
   vtDouble : s := floattostr(vd.vd);
   vtString : s := ''''+vd.vs+'''';
   vtObjekt: begin
                s := '';
             end;
   else s := '';
   end; // case
   toString := s;
end;

constructor TVariant.create;
begin
inherited;
veraendert := true;
end;

{ TAttribut }

constructor TAttribut.create(Name: String; objekt: TObjekt; Typ: TVarType;
  ci: Integer);
begin
   inherited create;
   versteckt := false;
   self.Name := name;
   self.Objekt := objekt;
   Wert := TVariant.Create;
   Wert.Typ := Typ;
   Wert.attribut := self;
   self.ci := ci;
end;

destructor TAttribut.destroy;
begin
  Wert.Free;
  inherited;
end;

procedure TAttribut.wurdegeaendert;
begin
   if Objekt <> nil then
      Objekt.attributaenderung(self);
end;

{ TObjekt }

procedure TObjekt.AddAttribut(a: TAttribut);
begin
   attribute.Add(a);
end;

procedure TObjekt.AddMethode(m: TMethode);
begin
   methoden.Add(m);
end;

procedure TObjekt.copyfrom(o: TObjekt);
begin
// Nicht in jeder Klasse implementiert
end;

constructor TObjekt.create(name: String; Owner: TObjekt; inheritedFlag: Boolean);
begin
   inherited create;
   self.name := name;
   self.owner := Owner;
   attribute := TList.Create;
   methoden := TList.Create;
   zeichenbar := false;
end;

procedure TObjekt.CreateSetzeMethoden;
Var i: integer;
    a: TAttribut;
begin
   if not inheritedFlag then
   for i := 0 to Attribute.Count - 1 do
   begin
      a := TAttribut(Attribute.Items[i]);
      if not a.versteckt then
         addMethode(TMethode.create(a));
   end;
end;

destructor TObjekt.destroy;
Var i: integer;
    a: TAttribut;
begin
  for i := 0 to attribute.Count - 1 do
  begin
    a := TAttribut(attribute.Items[i]);
    if a.Wert.Typ = vtObjekt then
       begin
          a.Wert.o.Free;
          a.Wert.o := nil;
       end;
    a.Free;
  end;
  attribute.Free;
  for i := 0 to methoden.Count - 1 do Tmethode(Methoden.Items[i]).Free;
  methoden.Free;
  inherited;
end;


function TObjekt.GetAttribut(name: String): TAttribut;
Var i: integer;
    a,b: TAttribut;
begin
   i := 0; a := nil;
   while (i <= attribute.Count-1) and (a = nil) do
      begin
      b := TAttribut(attribute.Items[i]);
      if not b.versteckt then
      if lowercase(b.Name) = lowercase(name) then a := TAttribut(attribute.Items[i]);
      inc(i);
      end;
   GetAttribut := a;
end;

function TObjekt.GetMethode(name: String): TMethode;
Var i: integer;
    m,n: TMethode;
begin
   i := 0; m := nil;
   while (i <= methoden.Count-1) and (m = nil) do
      begin
      n := TMethode(methoden.Items[i]);
      if not n.versteckt then
      if lowercase(n.Name) = lowercase(name) then m := TMethode(methoden.Items[i]);
      inc(i);
      end;
   GetMethode := m;
end;

{ TMethode }

procedure TMethode.addparameter(Name: String; Typ: TVarType; ci: Integer);
Var p: TParameter;
begin
   p := TParameter.Create;
   p.Name := name;
   p.ci := ci;
   p.typ := Typ;
   parameter.Add(p);
end;

constructor TMethode.create(Name: String; Objekt: TObjekt; Nummer: Integer;
  Rueckgabetyp: TVarType; rueckci: Integer);
begin
   inherited create;
   typ := mtObjektMethode;
   versteckt := false;
   self.Name := Name;
   self.Objekt := Objekt;
   self.Nummer := Nummer;
   if Rueckgabetyp <> vtKeiner then
   begin
     Rueckgabeparameter := TParameter.Create;
     Rueckgabeparameter.ci := rueckci;
     Rueckgabeparameter.typ := Rueckgabetyp;
   end else Rueckgabeparameter := nil;
   parameter := TList.Create;
end;

constructor TMethode.create(MethodenProzedur: TMethodenProzedur;
  Rueckgabetyp: TVarType; rueckci: Integer);
begin
   inherited create;
   typ := mtSystem;
   versteckt := false;
   Objekt := nil;
   if Rueckgabetyp <> vtKeiner then
   begin
     Rueckgabeparameter := TParameter.Create;
     Rueckgabeparameter.ci := rueckci;
     Rueckgabeparameter.typ := Rueckgabetyp;
   end else Rueckgabeparameter := nil;
   parameter := TList.Create;

   self.MethodenProzedur := MethodenProzedur;
end;

constructor TMethode.create(Einsprungadresse: integer);
begin
   inherited create;
   typ := mtSelbstgeschrieben;
   versteckt := false;
   Objekt := nil;
   self.Einsprungadresse := Einsprungadresse;
   {if Rueckgabetyp <> vtKeiner then
   begin
     Rueckgabeparameter := TParameter.Create;
     Rueckgabeparameter.ci := rueckci;
     Rueckgabeparameter.typ := Rueckgabetyp;
   end else} Rueckgabeparameter := nil;
   parameter := TList.Create;
end;

procedure TMethode.addvarparameter(Name: String; Typ: TVarType;
  ci: Integer; Variablenparameter: Boolean);
Var p: TParameter;
begin
   p := TParameter.Create;
   p.Name := name;
   p.ci := ci;
   p.typ := Typ;
   p.Variablenparameter := Variablenparameter;
   parameter.Add(p);
end;

constructor TMethode.create(a: TAttribut);
begin
   inherited create;
   typ := mtSetzeMethode;
   versteckt := false;
   Objekt := nil;
   Attribut := a;
   Rueckgabeparameter := nil;
   parameter := TList.Create;

   addparameter(a.Name,a.Wert.Typ,a.ci);
   name := a.Name + 'Setzen';
end;

destructor TMethode.destroy;
var i: integer;
begin
  for i := 0 to parameter.Count -1 do TParameter(parameter.Items[i]).Free;
  parameter.Free;
  Rueckgabeparameter.Free;
  inherited;
end;

function TMethode.getparameter(Name: String): TParameter;
Var i: integer;
    p: TParameter;
begin
   p := nil; i := 0;
   while (i <= parameter.Count -1) and (p = nil) do
      if TParameter(parameter.Items[i]).Name = Name then p := TParameter(parameter.Items[i])
        else inc(i);
   getparameter := p;
end;

{ TStack }

constructor TStack.create;
begin
   SetLength(a,1000);
   anzahl := 1000;
   p := 0;
end;

destructor TStack.destroy;
var i: integer;
begin
  for i := 0 to anzahl - 1 do
  begin
     if a[i] <> nil then
     begin
       a[i].Free;
       a[i] := nil;
     end;
  end;
  a := nil;
  inherited;
end;

procedure TStack.machplatz;
begin
   if p = anzahl then
   begin
      anzahl := anzahl + 1000;
      SetLength(a,anzahl);
   end;
end;

function TStack.oberstesElement: TVariant;
Var v: TVariant;
begin
   v := nil;
   if p > 0 then v := a[p-1];
   oberstesElement := v;
end;

function TStack.pop: TVariant;
Var v: TVariant;
begin
   if p > 0 then
      begin
      dec(p);
      v := a[p];
      a[p] := nil;
      end
      else v := nil;
   pop := v;       // Um's vernichten muss sich die aufrufende Prozedur kmmern!
end;

function TStack.popAblaufSteuerung: TAblaufsteuerung;
var ast: TAblaufsteuerung;
begin
   if p > 0 then
      begin
      dec(p);
      ast := a[p].ast;
      end
      else ast := asKeine;
   popAblaufSteuerung := ast;
end;

function TStack.popBoolean: Boolean;
var b: boolean;
begin
   if p > 0 then
      begin
      dec(p);
      b := a[p].b;
      end
      else b := false;
   popBoolean := b;
end;

function TStack.popChar: Char;
var c: char;
begin
   if p > 0 then
      begin
      dec(p);
      c := a[p].c;
      end
      else c := #0;
   popChar := c;
end;

function TStack.popdouble: double;
var d: Double;
begin
   if p > 0 then
      begin
      dec(p);
      d := a[p].d;
      end
      else d := 0;
   popDouble := d;
end;

function TStack.popInteger: Integer;
var i: Integer;
begin
   if p > 0 then
      begin
      dec(p);
      i := a[p].i;
      end
      else i := 0;
   popInteger := i;
end;

function TStack.popObjekt: TObjekt;
var o: TObjekt;
begin
   if p > 0 then
      begin
      dec(p);
      o := a[p].o;
      end
      else o := nil;
   popObjekt := o;
end;

function TStack.popString: String;
var s: string;
begin
   if p > 0 then
      begin
      dec(p);
      s := a[p].s;
      end
      else s := '';
   popString := s;
end;

procedure TStack.pushAblaufSteuerung(ast: TAblaufsteuerung);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].ast := ast;
   inc(p);
end;

procedure TStack.pushBoolean(b: Boolean);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].b := b;
   inc(p);
end;

procedure TStack.pushChar(c: char);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].c := c;
   inc(p);
end;

procedure TStack.pushDouble(d: double);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].d := d;
   inc(p);
end;

procedure TStack.pushInteger(i: Integer);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].i := i;
   inc(p);
end;

procedure TStack.pushObjekt(o: TObjekt);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].o := o;
   inc(p);
end;

procedure TStack.pushString(s: String);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.Create;
   a[p].s := s;
   inc(p);
end;

procedure TStack.pushVariant(v: TVariant);
begin
   machplatz;
   // Alte Variants werden oft auf dem Stack belassen!
   if a[p] = nil then a[p] := TVariant.create;
   a[p].copyfrom(v);
   inc(p);
end;

function TStack.Typ: TVarType;
var vtyp: TVarType;
begin
   if p = 0 then vtyp := vtKeiner
   else vtyp := a[p-1].Typ;
   Typ := vtyp;
end;

end.
