unit UDebugControl;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Printers;

const variablenkapazitaet = 200;

type
TVarString = record
   s: String;   // formatierter String
                // 1 = fett an; 2 = fett aus; 3 = rot an; 4 = rot aus
   Zeile: integer;
   x, breite: integer;
   end;

TDebugControl = class(TCustomControl)
  private
    SBHor, SBVert: TScrollbar;
    BitMap: TBitmap;
    CriticalSectionPaintVars: TRTLCriticalSection;

    variablen: Array [0..Variablenkapazitaet] of TVarString;
    Variablenanzahl: integer;

    Zeilenanzahl: integer;
    ZeilenanzahlScreen: integer;
    Zeilenhoehe: integer;
    zeilenabstand: integer;
    LinkerRand, ObererRand: integer;
    paintwidth, paintheight: integer;

    Scrollbarbreite: integer;

    horpos, vertpos: integer;

  public
    tabulatorbreite: integer; // Tabulatorbreite

   procedure Paint; override;
   constructor create(AOwner: TComponent); override;
   destructor destroy; override;

    procedure mResize(Sender: TObject);
    procedure mChange(Sender: TObject);
    procedure mEnter(Sender: TObject);

   procedure init;
   procedure addvar(s: String);
   procedure complete;
   function TextBreite(s: string; c: TCanvas):integer;
   function stringohneformatierung(s: string):string;
   procedure paintvar(s: String; x,y: integer; c: TCanvas);
end;



implementation




{ TDebugControl }

procedure TDebugControl.addvar(s: String);
begin
   try
   EnterCriticalSection(criticalSectionPaintVars);
     if variablenanzahl < variablenkapazitaet then
     begin
       // Variablen[0..variablenkapazitaet]
       variablen[variablenanzahl].s := s;
       inc(variablenanzahl);
     end;
   finally
   LeaveCriticalSection(criticalSectionPaintVars);
   end;
end;

procedure TDebugControl.complete;
var i, Zeile, x, FensterBreite, breite: integer;
    MaxBreite: integer;
begin
   try
   EnterCriticalSection(criticalSectionPaintVars);

   Bitmap.canvas.Font.Name := 'Arial';
   Bitmap.canvas.Font.Size := 10;
   Bitmap.canvas.Font.Color := clblack;
   Bitmap.canvas.Brush.Color := clwhite;
   Bitmap.canvas.Brush.Style := bsSolid;

   Zeilenhoehe := Bitmap.canvas.TextHeight('Wg|') + Zeilenabstand;

   FensterBreite := width - sbvert.Width;
   x := LinkerRand; Zeile := 0; MaxBreite := 0;
   for i := 0 to variablenanzahl - 1 do
   begin
      variablen[i].x := x;
      breite := Textbreite(variablen[i].s,Bitmap.canvas);
      breite := tabulatorbreite * (breite div tabulatorbreite + 1);
      variablen[i].breite := breite;
      if x + breite < FensterBreite then x := x + breite
      else
      begin
         if x > LinkerRand then inc(Zeile);
         variablen[i].x := LinkerRand;
         x := LinkerRand + breite;
      end;
      variablen[i].Zeile := Zeile;
      if MaxBreite < breite then maxbreite := breite;
   end;

   Zeilenanzahl := zeile + 1;

   if maxbreite > fensterbreite then
   begin
     if horpos > maxbreite then horpos := 0;

     sbhor.Height := scrollbarbreite;
     sbhor.Top := height - scrollbarbreite;
     sbhor.Left := 0;

     if sbhor.PageSize > maxbreite then SBHor.PageSize := fensterbreite;
     sbhor.SetParams(horpos,0,maxbreite);
     sbhor.PageSize := fensterbreite;
     sbhor.Visible := true;
     paintheight := height - sbhor.height;
     ZeilenanzahlScreen := paintheight div Zeilenhoehe;
     sbvert.Height := height - scrollbarbreite;
   end else
   begin
     paintheight := height;
     ZeilenanzahlScreen := paintheight div Zeilenhoehe;
     sbhor.Visible := false;
     sbvert.Height := height;
   end;

   if Zeilenanzahl <= ZeilenanzahlScreen then
   begin
     sbvert.visible := false;
     paintwidth := width;
     sbhor.Width := width;
   end
   else
   begin
     if vertpos > zeilenanzahl - 1 then vertpos := 0;
     sbvert.Width := Scrollbarbreite;
     sbvert.Top := 0;
     sbvert.Left := width - scrollbarbreite;

     sbvert.Visible := true;
     sbvert.pagesize := 1;
     sbvert.SetParams(vertpos,0,Zeilenanzahl -1);
     sbvert.PageSize := zeilenanzahlScreen;

     paintwidth := width - sbvert.Width;
     sbhor.Width := width - Scrollbarbreite;
   end;
   Bitmap.Width := paintwidth;
   bitmap.Height := paintheight;

   finally
     LeaveCriticalSection(criticalSectionPaintVars);
   end;

   paint;
end;

constructor TDebugControl.create(AOwner: TComponent);
begin
  inherited;
   Bitmap := TBitMap.Create;
   ControlStyle := ControlStyle + [csOpaque];
   OnResize := mResize;

  InitializeCriticalSection(CriticalSectionPaintVars);
  Variablenanzahl := 0;

   ScrollBarbreite := 16;

   SBHor := TScrollBar.Create(self);
   SBHor.Parent := self;
   SBHor.Kind := sbhorizontal;
   SBHor.OnChange := mChange;
   SBHor.OnEnter := mEnter;

   SBVert := TScrollBar.Create(self);
   SBVert.Kind := sbvertical;
   SBVert.Parent := self;
   SBVert.OnChange := mChange;
   SBVert.OnEnter := mEnter;

  horpos := 0; vertpos := 0;

  tabulatorbreite := 100;
  Zeilenabstand := 3;
  LinkerRand := 3;
  ObererRand := 3;
end;

destructor TDebugControl.destroy;
begin
  deleteCriticalSection(CriticalSectionPaintVars);
  Bitmap.Free;
  inherited;
end;

procedure TDebugControl.init;
begin
   try
   EnterCriticalSection(criticalSectionPaintVars);
     Variablenanzahl := 0;
   finally
   LeaveCriticalSection(criticalSectionPaintVars);
   end;
end;

procedure TDebugControl.mChange(Sender: TObject);
begin
    if SBHor.Visible then horpos := SBHor.Position;
    if SBVert.Visible then vertpos := sBVert.Position;
    Paint;
end;

procedure TDebugControl.mEnter(Sender: TObject);
begin
   SetFocus;
end;

procedure TDebugControl.mResize(Sender: TObject);
begin
   complete;
   Paint;
end;

procedure TDebugControl.Paint;
var x,xs,ys,Zeile,i: integer;
    r: TRect;
begin
 inherited;
 try
    EnterCriticalSection(criticalSectionPaintVars);
    with Bitmap.Canvas do
    begin
       brush.Color := clwhite;
       brush.Style := bsSolid;
       FillRect(Rect(0,0,paintwidth,paintheight));
    end;
    for i := 0 to Variablenanzahl -1 do
    begin
       x := variablen[i].x; Zeile := Variablen[i].Zeile;
       xs := x - horpos; ys := Zeile * Zeilenhoehe + ObererRand - VertPos * Zeilenhoehe;
       if (xs < paintwidth) and (ys < paintheight) and
          (xs + variablen[i].breite > 0) and (ys + Zeilenhoehe > 0) then
             begin
             paintvar(variablen[i].s,xs,ys,Bitmap.canvas);
             end;
    end;
    if variablenanzahl = 0 then
       bitmap.Canvas.TextOut(3,3,'Seit Beginn des Programmlaufs wurden noch keine Variablen deklariert.');
    r := Rect(0,0,paintwidth,paintheight);
   canvas.CopyRect(r,Bitmap.Canvas,r);
 finally
   LeaveCriticalSection(criticalSectionPaintVars);
 end;

end;

procedure TDebugControl.paintvar(s: String; x, y: integer; c: TCanvas);
var i: integer;
    stext: string;
    ch: char;
begin
    c.Font.Style := [];
    c.Font.Color := clblack;
    i := 1; stext := '';
    while i <= length(s) do
    begin
       ch := s[i];
       if (ord(ch) <= 4) and (stext <> '') then
       begin
          c.TextOut(x,y,stext);
          x := x + c.textwidth(stext);
          stext := '';
       end;
       case ch of
       chr(1): c.Font.Style := [fsBold];
       chr(2): c.font.Style := [];
       chr(3): c.font.Color := clred;
       chr(4): c.font.color := clblack;
       else stext := stext + ch;
       end; // case;
       inc(i);
    end;
    if (stext <> '') then
      c.TextOut(x,y,stext);
end;

function TDebugControl.stringohneformatierung(s: string): string;
Var sof: string;
    i: integer;
begin
    sof := '';
    for i := 1 to length(s) do
      if ord(s[i]) > 4 then sof := sof + s[i];
    stringohneformatierung := sof;
end;

function TDebugControl.TextBreite(s: string; c: TCanvas):integer;
var i, breite: integer;
    stext: string;
    ch: char;
begin
    c.Font.Style := [];
    i := 1; stext := '';breite := 0;
    while i <= length(s) do
    begin
       ch := s[i];
       if (ord(ch) <= 4) and (stext <> '') then
       begin
          breite := breite + c.Textwidth(stext);
          stext := '';
       end;
       case ch of
       chr(1): c.Font.Style := [fsBold];
       chr(2): c.font.Style := [];
       chr(3): begin end;
       chr(4): begin end;
       else stext := stext + ch;
       end; // case;
       inc(i);
    end;
    if (stext <> '') then
      breite := breite + c.TextWidth(stext);
    TextBreite := Breite;  
end;

end.
