unit UFehler;

interface
uses Windows, Graphics, StdCtrls,Classes, SysUtils;
type
TFehler = class(TObject)
  public
     Zeile, Spalte, Inhaber, Fehlernummer: Integer;
     Text: String;
     constructor create(Zeile, Spalte, Inhaber, Fehlernummer
                            : Integer; Text: String );
end;

TFehlerVerwaltung = class(TObject)
  public
  Fehler: TList;
  ListBox: TListBox;
  procedure add(f: TFehler);
  procedure ListBoxAktualisieren;
  procedure aktualisiereAnzeige;
  procedure loescheAlleFehler;
  procedure loescheFehler(Inhaber: Integer);
  constructor create(ListBox: TListBox);
  destructor destroy; override;

end;
Var FehlerVerwaltung: TFehlerVerwaltung;

implementation

uses UMain, UCriticalSections;



{ TFehler }

constructor TFehler.create(Zeile, Spalte, Inhaber, Fehlernummer
               : Integer; Text: String);
begin
   self.Zeile := Zeile; self.Spalte := Spalte;
   self.Text := Text; self.Inhaber := Inhaber;
   self.Fehlernummer := Fehlernummer;
end;

{ TFehlerVerwaltung }

procedure TFehlerVerwaltung.add(f: TFehler);
begin
   Fehler.Add(f);
end;

procedure TFehlerVerwaltung.aktualisiereAnzeige;
begin
   FMain.shc.refresh;
end;

constructor TFehlerVerwaltung.create(ListBox: TListBox);
begin
   self.ListBox := ListBox;
   Fehler := TList.Create;
end;

destructor TFehlerVerwaltung.destroy;
Var i: integer;
begin
  for i := 0 to Fehler.Count -1 do
     TFehler(Fehler.Items[i]).Free;
  Fehler.Free;
  inherited;
end;

procedure TFehlerVerwaltung.ListBoxAktualisieren;
Var i: integer;
    f: TFehler;
    s: string;
begin
   try
     EnterCriticalSection(CriticalSectionFehlerveroeffentlichen);
     ListBox.Clear;
     for i := 0 to Fehler.Count -1 do
     begin
        f := TFehler(Fehler.Items[i]);
        if f.Inhaber = 1 then s := 'Laufzeitfehler' else s := 'Tipp';
        ListBox.AddItem(s+': (Z.'+inttostr(f.Zeile)+
             ' Sp.'+inttostr(f.spalte)+')    '+f.Text,f);
     end;
   finally
     LeaveCriticalSection(CriticalSectionFehlerveroeffentlichen);
   end;
   aktualisiereAnzeige;
end;

procedure TFehlerVerwaltung.loescheAlleFehler;
Var i: integer;
begin
  for i := 0 to Fehler.Count -1 do
     TFehler(Fehler.Items[i]).Free;
  Fehler.Clear;
  ListBoxAktualisieren;
end;

procedure TFehlerVerwaltung.loescheFehler(Inhaber: Integer);
Var i: integer;
    f: TFehler;
begin
  i := 0;
  while (i <= Fehler.Count -1) do
  begin
     f := TFehler(Fehler.Items[i]);
     if f.Inhaber = Inhaber then
        begin
           Fehler.Remove(f); f.Free;
        end
        else inc(i);
  end;
end;

end.
