unit UHelpTree;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, UScanner, UVariablen, UDaten, UKlassen,
  UInterpreter, USHControl, Menus, Buttons, ComCtrls;

procedure TreeCreate(Tree:TTreeView; kf: TKlassenFabrik);
procedure AddAttribut(Node: TTreeNode; a: TAttribut; kf: TKlassenfabrik);
procedure AddMethode(node: TTreeNode; m: TMethode; kf: TKlassenfabrik);
procedure AddKlasse(Tree: TTreeView; o: TObjekt; kf: TKlassenfabrik);
implementation

procedure TreeCreate(Tree:TTreeView; kf: TKlassenFabrik);
Var i: integer;
//    n: TTreeNode;
begin
   //n := TTreeNode.Create(Tree.Items);
   //n.Text := 'Klassen';
   Tree.Items.Clear;
   for i := 0 to kf.Klassenliste.Count -1 do
      AddKlasse(Tree,TObjekt(kf.Klassenliste.Items[i]),kf);
end;

procedure AddAttribut(Node: TTreeNode; a: TAttribut; kf: TKlassenfabrik);
Var n: TTreeNode;
    s: String;
    i: integer;
begin
   if not a.versteckt then
   begin
     s := a.Name + ': ';
     if a.Wert.Typ <> vtObjekt then
     begin
        s := s + a.Wert.TypName;
     end else
     begin
        s := s + a.Wert.o.Klassenname;
     end;
     n := Node.Owner.AddChildFirst(node,s);
     n.ImageIndex := 1; // Attribut!
     n.SelectedIndex := 1;
     if a.wert.Typ = vtObjekt then
     for i := 0 to a.wert.o.attribute.Count-1 do
        AddAttribut(n,TAttribut(a.wert.o.attribute.Items[i]),kf);
   end;
end;

procedure AddMethode(node: TTreeNode; m: TMethode; kf: TKlassenfabrik);
Var s: string;
    i: integer;
    p: TParameter;
    n: TTreeNode;
begin
if not m.versteckt then
  begin
     s := m.Name;
     begin
       s := s + '(';
       if m.parameter.Count > 0 then
       for i := 0 to m.parameter.Count - 1 do
       begin
          p := TParameter(m.parameter.Items[i]);
          s := s + p.Name + ': ';
          case p.typ of
             vtBoolean : s := s +'Boolean';
             vtChar    : s := s +'Char';
             vtInteger : s := s +'Integer';
             vtDouble  : s := s +'Real';
             vtString  : s := s +'String';
             vtObjekt : begin
                           if kf.getKlasse(p.ci) <> nil then
                              s := s + kf.getKlasse(p.ci).Klassenname;
                        end;
          end; // case
          if i < m.parameter.Count -1 then s := s + ',';
       end
       else s := s + ' ';
       s := s + ')';
     end;
     p := m.Rueckgabeparameter;
     if p <> nil then
     begin
        s := s + ':';
          case p.typ of
             vtBoolean : s := s +'Boolean';
             vtChar    : s := s +'Char';
             vtInteger : s := s +'Integer';
             vtDouble  : s := s +'Real';
             vtString  : s := s +'String';
             vtObjekt : begin
                           if kf.getKlasse(p.ci) <> nil then
                              s := s + kf.getKlasse(p.ci).Klassenname;
                        end;
          end; // case
     end;
     n := node.Owner.AddChild(node,s);
     n.ImageIndex := 2; // Methode!
     n.SelectedIndex := 2;
  end;
end;

procedure AddKlasse(Tree: TTreeView; o: TObjekt; kf: TKlassenfabrik);
Var n: TTreeNode;
    i: integer;
begin
   n := Tree.Items.add(nil,o.name);       //node.Owner.Add(node,o.name);
   n.ImageIndex := 0; // Klasse!
   n.SelectedIndex := 0;
   for i := 0 to o.attribute.Count-1 do
      AddAttribut(n,TAttribut(o.attribute.Items[i]),kf);
   for i := 0 to o.methoden.Count -1 do
      AddMethode(n,TMethode(o.methoden.Items[i]),kf);
end;

end.
