unit UCodeComplete;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, UDaten, UKLassen, UVariablen, USyntaxCheck, USHControl;

type
  TVorschlagArt = (VAttribut, VMethode, VVariable, VSchluesselwort,VVarTyp,VKlasse);

  TVorschlag = class(TObject)
     VorschlagArt: TVorschlagArt;
     MethodehatParameter: Boolean;
     Name, Typ: String;
  end;

  ECodeComplete = class(EAbort);

  TFCodeComplete = class(TForm)
    ListBox: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListBoxClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private

    // Workaraound: Wenn das Codecompletefenster den Focus hat, wird nach jedem
    // Tastendruck ein Listboxklick erzeugt.
    WarGradTaste: Boolean;


    Syntaxcheck: TSyntaxcheck; // von dem bekommen wir den TVarSpace
    kf: TKlassenfabrik;
    Kette: TStrings;
    AMVorschlagListe: TList;  // Fr Attribute/Methoden
    VTListe: TList; // Fr Variablentypen
    VSListe: TList; // Fr Variablen/Schlsselwrter

    VorschlagListe:TList; // Dieser Variable wird die aktuelle Liste zugeordnet

    shc: TSHControl;
    procedure VorschlagListeLeeren(VListe:TList);
    procedure VorschlagListeVTFuellen;
  public
    TeilString: String; // Der String, der schon eingegeben wurde
    procedure CreateParams(var Params: TCreateparams); override;
    procedure init(sc: TSyntaxcheck; shc: TSHControl);
    procedure up;
    procedure down;
    function getSelected: string;
    function ListBoxFuellen: Boolean;
    // wird aufgerufen, nachdem . gedrckt wurde
    function AnalyzeString(Zeile: String):Boolean;
    // wird aufgerufen, nachdem : gedrckt wurde
    procedure AnalyzeVarBefehl;

    function AnalyzeZeile(st: String; CursorSpalte: integer):integer;

  end;

var
  FCodeComplete: TFCodeComplete;

implementation

uses UConstants, UCriticalSections, UMain;

{$R *.dfm}

{ TFCodeComplete }

function TFCodeComplete.AnalyzeString(Zeile: String):Boolean;
Var i,j,n: integer;
    c: char;
    s: string;
    o: TObjekt;
    v: TVariant;
    a: TAttribut; m: TMethode; p: TParameter;
    vorschlag: TVorschlag;
    erfolgreich: boolean;
begin
   try
   begin
     EnterCriticalSection(CriticalSectionSyntaxVarSpace);

     erfolgreich := true;
     n := length(Zeile);
     Kette.Clear;
     try
       if n < 2 then raise ECodeComplete.Create('');

       while (n >= 2) and (Zeile[n] = '.') do
       begin
         dec(n);
         s := ''; c := Zeile[n]; // Dummy
         while (charTable[ord(c)] in [OTC,OTZ]) and (n >= 1) and (c <> ' ') do
         begin
            s := c + s;
            dec(n);
            if n >= 1 then c := zeile[n] else c := ' ';
         end;
         if length(s) > 0 then
         begin
           if (charTable[ord(s[1])] = OTZ) then raise ECodeComplete.Create('');
         end else raise ECodeComplete.Create('');
         Kette.Insert(0,s);
       end;
       // Jetzt sind die Strings beisammen. Wir schauen nach, ob es das
       // Attribut gibt
         v := nil;
         if SyntaxCheck.vs <> nil then v := Syntaxcheck.vs.get(Kette.Strings[0]);
       if (v = nil) or (v.Typ <> vtObjekt) then raise ECodeComplete.Create('');
       o := v.o;
       o := kf.getKlasse(o.ci);  // Aus der eigenen Klassenfabrik besorgen
       // => Keine gemeinsam genutzten Objekte mit TSyntaxcheck mehr!
       for i := 1 to Kette.Count - 1 do
       begin
          a := o.GetAttribut(Kette.Strings[i]);
          if (a = nil) or (a.Wert.Typ <> vtObjekt) then raise ECodeComplete.Create('');
          o := a.Wert.o;
       end;
       // Jetzt ist in o das richtige Objekt drin! Wir bauen die Liste auf.
       VorschlagListeLeeren(AMVorschlagListe);
       for i := 0 to o.attribute.Count - 1 do
       begin
          a := TAttribut(o.attribute.Items[i]);
          if not a.versteckt then
          begin
            vorschlag := TVorschlag.Create;
            vorschlag.VorschlagArt := VAttribut;
            vorschlag.Name := a.Name;
            if a.Wert.Typ <> vtObjekt then vorschlag.Typ := a.Wert.TypName
              else begin
                 vorschlag.Typ := kf.getKlasse(a.wert.o.ci).name;
              end;
            AMVorschlagListe.Add(Vorschlag);
          end;
       end;
       for j := 0 to o.methoden.Count -1 do
       begin
         m := TMethode(o.methoden.Items[j]);
         if not m.versteckt then begin
           vorschlag := TVorschlag.Create;
           vorschlag.VorschlagArt := VMethode;
           vorschlag.Name := m.Name;
           vorschlag.MethodehatParameter :=  (m.parameter.Count >= 1);
           // Vorschlag.typ
           //
           s := '';
           begin
             s := s + '(';
             if m.parameter.Count > 0 then
             for i := 0 to m.parameter.Count - 1 do
             begin
                p := TParameter(m.parameter.Items[i]);
                s := s + p.Name + ': ';
                case p.typ of
                   vtBoolean : s := s +'Boolean';
                   vtChar    : s := s +'Char';
                   vtInteger : s := s +'Integer';
                   vtDouble  : s := s +'Real';
                   vtString  : s := s +'String';
                   vtObjekt : begin
                                 if kf.getKlasse(p.ci) <> nil then
                                    s := s + kf.getKlasse(p.ci).Klassenname;
                              end;
                end; // case
                if i < m.parameter.Count -1 then s := s + ',';
             end else s := s + ' ';
             s := s + ')';
           end;
           p := m.Rueckgabeparameter;
           if p <> nil then
           begin
              s := s + ':';
                case p.typ of
                   vtBoolean : s := s +'Boolean';
                   vtChar    : s := s +'Char';
                   vtInteger : s := s +'Integer';
                   vtDouble  : s := s +'Real';
                   vtString  : s := s +'String';
                   vtObjekt : begin
                                 if kf.getKlasse(p.ci) <> nil then
                                    s := s + kf.getKlasse(p.ci).Klassenname;
                              end;
                end; // case
           end;
           Vorschlag.Typ := s;
           // Ende Vorschlag.typ
           AMVorschlagListe.Add(vorschlag);
         end;
       end; // Methoden hinzugefgt
       TeilString := '';  // Bisher wurde noch nichts eingegeben.
       VorschlagListe := AMVorschlagListe;
       ListBoxFuellen;
     except
       on e: ECodeComplete do
       begin
          erfolgreich := false;
       end;
     end; // try ... except
     if erfolgreich then VorschlagListe := AMVorschlagListe;
   end;
   finally
      LeaveCriticalSection(CriticalSectionSyntaxVarSpace);
   end; // try...finally

   AnalyzeString := erfolgreich;
end;

procedure TFCodeComplete.FormCreate(Sender: TObject);
begin
   Kette := TStringlist.Create;
   AMVorschlagListe := TList.Create;
   VTListe := Tlist.create;
   VSListe := Tlist.create;
   kf := TKlassenFabrik.create;
   VorschlagListeVTFuellen;
   WarGradTaste := false;
end;

procedure TFCodeComplete.FormDestroy(Sender: TObject);
begin
   Kette.Free;
   VorschlagListeLeeren(AMVorschlagListe);
   VorschlagListeLeeren(VTListe);
   VorschlagListeLeeren(VSListe);
   AMVorschlagListe.Free;
   vTListe.Free;
   vSListe.Free;
   kf.Free;
end;

procedure TFCodeComplete.init(sc: TSyntaxcheck; shc: TSHControl);
begin
   Syntaxcheck := sc;
   self.shc := shc;
end;

procedure TFCodeComplete.VorschlagListeLeeren(VListe:TList);
Var i: integer;
begin
   for i := 0 to VListe.Count -1 do
      TVorschlag(VListe.Items[i]).Free;
   VListe.Clear;
end;

procedure TFCodeComplete.ListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
Var Offset: Integer;
    v: TVorschlag;
    Bitmap: TBitmap;
    c: TColor;
    s: string;
begin
  with (Control as TListBox).Canvas do  { Zeichnen in der Liste, nicht im Formular }
  begin
  FillRect(Rect);       { Rechteck lschen }
  if Index <= VorschlagListe.Count -1 then
  begin
    c := Brush.Color;
    v := TVorschlag(Listbox.Items.Objects[index]);
    // v := TVorschlag(VorschlagListe.Items[index]);
    Offset := 2;          { Standard-Offset definieren }
    Bitmap := TBitmap.Create;
    case v.VorschlagArt of
      VAttribut: FMain.ImageList1.GetBitmap(1,Bitmap);
      VMethode: FMain.ImageList1.GetBitmap(2,Bitmap);
      VKLasse: FMain.ImageList1.GetBitmap(0,Bitmap);
    else begin Bitmap.free; Bitmap := nil; end;
    end; // case
    if Bitmap <> nil then
    begin
      Brush.Color := Pixels[rect.Left, rect.Top];
      BrushCopy(Bounds(Rect.Left + Offset, Rect.Top, Bitmap.Width, Bitmap.Height),
              Bitmap, Bounds(0, 0, Bitmap.Width, Bitmap.Height), clWhite);  { Bitmap darstellen }
    Bitmap.free;
    end;
    Offset := 26;
    Brush.Color := c;

    Font.Name := 'MS Sans Serif';
    Font.Style := Font.Style + [fsBold];
    s := v.Name;
    if v.VorschlagArt = vAttribut then s := s + ': ';
    TextOut(Rect.Left + Offset, Rect.Top, s);
    offset := offset + TextWidth(s);
    Font.Style := [];
    TextOut(Rect.Left + Offset, Rect.Top, v.Typ);
    end;
  end;
end;

function TFCodeComplete.ListBoxFuellen:Boolean;
Var i: integer;
    v: TVorschlag;
    warwasda: Boolean;
begin
  ListBox.Clear; warwasda := false;
  for i := 0 to VorschlagListe.Count -1 do
  begin
     v := TVorschlag(VorschlagListe.Items[i]);
     if lowercase(copy(v.Name,1,length(Teilstring))) = lowercase(Teilstring) then
     begin
        ListBox.AddItem(v.Name,v);
        warwasda := true;
     end;
  end;
  ListBox.Style := lbOwnerDrawFixed;
  ListBox.ItemHeight := 18;
  if ListBox.Items.Count >= 1 then ListBox.Selected[0] := true;
  ListBoxFuellen := warwasda;
end;

procedure TFCodeComplete.down;
var i: integer;
begin
   i := 0;
   while(i < ListBox.Items.Count -1) and (not ListBox.Selected[i]) do inc(i);
   if ListBox.Selected[i] and (i < ListBox.Items.Count -1 ) then
   begin
      ListBox.Selected[i] := false;
      ListBox.Selected[i+1] := true;
   end;// else ListBox.Selected[0] := true;
end;

procedure TFCodeComplete.up;
var i: integer;
begin
   i := 0;
   while(i < ListBox.Items.Count -1) and (not ListBox.Selected[i]) do inc(i);
   if ListBox.Selected[i] and (i > 0) then
   begin
      ListBox.Selected[i] := false;
      ListBox.Selected[i-1] := true;
   end;// else ListBox.Selected[ListBox.Items.Count-1] := true;
end;

function TFCodeComplete.getSelected: string;
var i: integer;
    s: string;
    v: TVorschlag;
begin
   i := 0; s :='';
   while(i < ListBox.Items.Count -1) and (not ListBox.Selected[i]) do inc(i);
   if ListBox.Selected[i] then
   begin
     v := TVorschlag(ListBox.Items.Objects[i]);
     s := v.name;
     //s := copy(s,length(teilstring)+1,length(s)-length(teilstring));
     if (v.VorschlagArt = vMethode) then
        if v.MethodehatParameter then s := s + '('
           else s := s + '()';
   end;
   getSelected := s;
end;

procedure TFCodeComplete.ListBoxClick(Sender: TObject);
begin
   if not WarGradTaste then
   shc.DoReturn;
   WarGradTaste := false;
end;

procedure TFCodeComplete.VorschlagListeVTFuellen;
Var v:TVorschlag;
    e: EToken;
    i: integer;
begin
   for i := 0 to kf.Klassenliste.Count-1 do
   begin
      v := TVorschlag.Create;
      v.Name := TObjekt(kf.Klassenliste.Items[i]).name;
      v.VorschlagArt := VKlasse;
      vTListe.Add(v);
   end;
   for e := OBoolean to OString do
   begin
      v := TVorschlag.Create;
      v.Name := TokenStrings[ord(e)];
      v.VorschlagArt := VVarTyp;
      VTListe.Add(v);
   end;
end;

procedure TFCodeComplete.AnalyzeVarBefehl;
begin
  VorschlagListe := VTListe;
  TeilString := '';
  ListBoxFuellen;
end;

procedure TFCodeComplete.CreateParams(var Params: TCreateparams);
begin
  inherited CreateParams(Params);
  Params.Style := (Params.Style or WS_THICKFRAME);
end;

function TFCodeComplete.AnalyzeZeile(st: String; CursorSpalte: integer): integer;
Var TeilStringz,bezeichner: string;
    i,j: integer;
    CodeCompleteSpalte: integer;
    falschesZeichen: Boolean;
begin
   try
   begin
     EnterCriticalSection(CriticalSectionSyntaxVarSpace);

     CodeCompleteSpalte := -1;
     if CursorSpalte >= 2 then // es muss mindestens r. da sein
     begin
       TeilStringz := '';
       i := CursorSpalte;
       if length(st) < i then
           i := length(st);
       // alles links vom Cursor sammeln bis ein Punkt oder ein Doppelpunkt kommt
       while (i > 0) and not (st[i] in ['.',':']) do
       begin
          Teilstringz := st[i] + TeilStringz;
          dec(i);
       end;
       if (i > 1) and (st[i] = '.') then
       begin
          if AnalyzeString(copy(st,1,i)) then
             CodeCompleteSpalte := i+1;
       end;
       if (i > 1) and (st[i] = ':') then    // Liegt eine Variablendeklaration vor?
       begin
          falschesZeichen := false;
          for j := 1 to length(st) do
             if not (st[j] in ['a'..'z','A'..'Z','','','','','','','','_',':',',','0'..'9']) then
               falschesZeichen := true;
          j := 1;
          while (j <= length(st)) and (st[j] = ' ') do inc(j);
          bezeichner := '';
          while (j <= length(st)) and not (st[j] in [',','.',' ',':'] )do
           begin
              bezeichner := bezeichner + st[j];
              inc(j);
           end;
           if Syntaxcheck.vs <> nil then
             if (Syntaxcheck.vs.get(bezeichner) = nil) and not falschesZeichen then
              begin
                 AnalyzeVarBefehl;
                 CodeCompleteSpalte := i+1;
              end;
       end;
     end;
     if CodeCompleteSpalte >= 0 then
     begin
       TeilString := TeilStringz;
       ListBoxFuellen;
     end;
   end;
   finally
      LeaveCriticalSection(CriticalSectionSyntaxVarSpace);
   end; // try .. finally
   AnalyzeZeile := CodeCompleteSpalte;
end;


procedure TFCodeComplete.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   shc.mOnKeyDown(Sender,Key,Shift);
end;

procedure TFCodeComplete.FormKeyPress(Sender: TObject; var Key: Char);
begin
    shc.mOnKeypress(Sender,Key);
    WarGradTaste := true;
end;

procedure TFCodeComplete.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    shc.mOnKeyUp(Sender,Key,Shift);
end;

end.
