unit UEinstellungen;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, LadenSpeichern, ComCtrls;

type
  TFEinstellungen = class(TForm)
    GBFileRegistrieren: TGroupBox;
    BRegister: TButton;
    BDeregister: TButton;
    Memo1: TMemo;
    CBKeineZuweisungZuAttributen: TCheckBox;
    BOK: TButton;
    BAbbrechen: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    EPasswort: TEdit;
    Label1: TLabel;
    EArbeitsverzeichnis: TEdit;
    UDCharacterSize: TUpDown;
    ECharacterSize: TEdit;
    Label5: TLabel;
    procedure BRegisterClick(Sender: TObject);
    procedure BDeregisterClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BAbbrechenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EinstellungenSpeichern;
    procedure EinstellungenLaden;
    procedure VarToScreen;
    procedure ScreenToVar;
  private
    ls: TLoadSave;
  public

    // Hier kommen alle Einstellungen rein
    KeineZuweisungZuAttributen: Boolean;
    Passwort: String;
    Arbeitsverzeichnis: String;
    Schriftgroesse: integer;
  end;

var
  FEinstellungen: TFEinstellungen;

implementation

uses RegisterFileType, Uencrypt, UMain;

{$R *.dfm}

procedure TFEinstellungen.BRegisterClick(Sender: TObject);
var exepath: string;
begin
   exepath :=  ExtractFilePath(Application.ExeName)+   ExtractFileName(Application.ExeName);
   pRegisterFileType('eos',exepath);
   Application.MessageBox('EOS wurde in der Registry angemeldet.','Fertig!',MB_OK);
end;

procedure TFEinstellungen.BDeregisterClick(Sender: TObject);
begin
  DeregisterFileType('eos');
  Application.MessageBox('Alle EOS-Eintrge in der Registry wurden entfernt','Fertig!',MB_OK);
end;

procedure TFEinstellungen.FormCreate(Sender: TObject);
begin
   Passwort := '';
   KeineZuweisungZuAttributen := false;
   ls := TLoadSave.Create;
end;

procedure TFEinstellungen.BOKClick(Sender: TObject);
begin
   ScreentoVar;
   EinstellungenSpeichern;
   Close;
   FMAin.shc.checkSyntax;
   FMain.shc.CharacterSize := Schriftgroesse;
end;

procedure TFEinstellungen.FormShow(Sender: TObject);
begin
   vartoScreen;
end;

procedure TFEinstellungen.BAbbrechenClick(Sender: TObject);
begin
   close;
end;

procedure TFEinstellungen.FormDestroy(Sender: TObject);
begin
   ls.Free;
end;

procedure TFEinstellungen.EinstellungenLaden;
begin
   if not ls.OpenFileRead('eos.set') then
   begin
      Passwort := decrypt(ls.ReadStringd('pass',''));
      if Passwort = '' then passwort := decrypt('f297a5318adb');
      if encrypt(Passwort) = encrypt('Keins') then Passwort := '';
      KeineZuweisungZuAttributen := ls.readBooleand('KeineZuweisungZuAttributen',false);
      Arbeitsverzeichnis := ls.ReadStringd('Arbeitsverzeichnis','');
      Schriftgroesse := ls.ReadIntegerd('Schriftgroesse',10);
      if Schriftgroesse < 10 then Schriftgroesse := 10;
      FMain.shc.CharacterSize := Schriftgroesse;
      ls.CloseFile;
   end else passwort := '';
   VartoScreen;
end;

procedure TFEinstellungen.EinstellungenSpeichern;
var s: string;
begin
   if not ls.OpenFileWrite('eos.set') then
   begin
      if Passwort = '' then s := encrypt('Keins')
         else s := encrypt(Passwort);
      ls.WriteStringd('pass', s);
      ls.writeBooleand('KeineZuweisungZuAttributen',KeineZuweisungZuAttributen);
      ls.WriteStringd('Arbeitsverzeichnis', Arbeitsverzeichnis);
      ls.writeIntegerd('Schriftgroesse',Schriftgroesse);
      ls.CloseFile;
   end;
end;

procedure TFEinstellungen.ScreenToVar;
begin
   KeineZuweisungZuAttributen := CBKeineZuweisungZuAttributen.Checked;
   Passwort := EPasswort.Text;
   Arbeitsverzeichnis := EArbeitsverzeichnis.Text;
   Schriftgroesse := UDCharacterSize.Position;
end;

procedure TFEinstellungen.VarToScreen;
begin
   CBKeineZuweisungZuAttributen.Checked := KeineZuweisungZuAttributen;
   EPasswort.Text := Passwort;
   EArbeitsverzeichnis.Text := Arbeitsverzeichnis;
   UDCharacterSize.Position := Schriftgroesse;
end;

end.
