unit UZeichenfenster;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, UDaten, Menus;

type
  TFZeichnen = class(TForm)
    pb: TPaintBox;
    PopupMenu1: TPopupMenu;
    Koordinatenanzeige1: TMenuItem;
    KopierenDrucken1: TMenuItem;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure pbPaint(Sender: TObject);
    procedure pbMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Koordinatenanzeige1Click(Sender: TObject);
    procedure KopierenDrucken1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
     xko, yko: integer;
    { Private-Deklarationen }
  public
    NameDesFensters: string;
    dc: TDrawCanvas;
    fenster: TObject;
    Zeichnenerlaubt: Boolean;
    procedure setCaption;
  end;

var
  FZeichnen: TFZeichnen;

implementation
uses UKLassen, UCriticalSections, ULetztesZeichenfenster;
{$R *.dfm}

procedure TFZeichnen.FormResize(Sender: TObject);
begin
   pb.Left := 0; pb.Top := 0;
   pb.Width := ClientWidth; pb.Height := ClientHeight;
   dc.resize;
end;

procedure TFZeichnen.FormCreate(Sender: TObject);
begin
   left := screen.WorkAreaWidth - width;
   top := 0;
   dc := TDrawCanvas.create(pb);
   //pb.OnPaint := dc.paintall;
   pb.ControlStyle := pb.ControlStyle + [csOpaque];
   Zeichnenerlaubt := true;
   NameDesFensters := '';
   xko := 0;
   yko := 0;
end;

procedure TFZeichnen.FormDestroy(Sender: TObject);
begin
   try
   EnterCriticalSection(CriticalSectionPaint);
   dc.Free; dc := nil;
   finally LeaveCriticalSection(CriticalSectionPaint); end;
   // if Fenster <> nil then TFenster(fenster).form := nil;
end;


procedure TFZeichnen.pbPaint(Sender: TObject);
begin
   try
   EnterCriticalSection(CriticalSectionPaint);
   if Zeichnenerlaubt then dc.paintall(self);
   finally LeaveCriticalSection(CriticalSectionPaint); end;
end;

procedure TFZeichnen.pbMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   xko := x;
   yko := y;
   setCaption;
end;

procedure TFZeichnen.setCaption;
Var s: string;
begin
   s := NameDesFensters;
   if Koordinatenanzeige1.Checked then
   begin
     s := s + ' x:' + inttostr(dc.xScrtoW(xko)) +
              ' y:' + inttostr(dc.yScrtoW(yko));
   end;
   caption := s;
end;

procedure TFZeichnen.Koordinatenanzeige1Click(Sender: TObject);
begin
   Koordinatenanzeige1.Checked := not Koordinatenanzeige1.Checked;
   setCaption;
end;

procedure TFZeichnen.KopierenDrucken1Click(Sender: TObject);
begin
   dc.copy;
end;

procedure TFZeichnen.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   FLetztesZeichenfenster.bm.Assign(dc.bm);
   FLetztesZeichenfenster.xmin := dc.xmin;
   FLetztesZeichenfenster.ymin := dc.ymin;
   FLetztesZeichenfenster.Groesseanpassen;
   FLetztesZeichenfenster.Repaint;
end;

end.
