package data;

/**
 * This object holds information about a given Schuljahr
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class Schuljahr implements Comparable<Schuljahr> {
	/**
	 * id of schuljahr in svp_wl_schuljahr
	 */
	private String id;
	
	/**
	 * e.g. "2007" for Schuljahr 2007/08
	 */
	private String schuljahr; 

	/**
	 * get database-id of schuljahr in svp_wl_schuljahr
	 * 
	 * @return database-id of schuljahr in svp_wl_schuljahr
	 */
	public String getId() {
		return id;
	}

	/**
	 * set id
	 * 
	 * @param id
	 *            database id of schuljahr in svp_wl_schuljahr
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * return schuljahr
	 * 
	 * @return e.g. "2007" for schuljahr 2007/08
	 */
	public String getSchuljahr() {
		return schuljahr;
	}

	/**
	 * set schuljahr
	 * 
	 * @param schuljahr
	 *            e.g. "2007" for schuljahr 2007/08
	 */
	public void setSchuljahr(String schuljahr) {
		this.schuljahr = schuljahr;
	}

	/**
	 * constructor
	 * 
	 * @param id
	 *            database id in svp_wl_schuljahr
	 * @param schuljahr
	 *            schuljahr as String, e.g. "2007" for schuljahr 2007/08
	 */
	public Schuljahr(String id, String schuljahr) {
		super();
		this.id = id;
		this.schuljahr = schuljahr;
	}

	/**
	 * get schuljahr as in
	 * 
	 * @return first year of Schuljahr, e.g. 2007 for schuljahr 2007/08
	 */
	public int getSchuljahrInt() {
		return Integer.parseInt(schuljahr);
	}

	/**
	 * implements Comparable interface... compares first years of given
	 * schuljahre
	 */
	@Override
	public int compareTo(Schuljahr o) {
		return ((Integer) getSchuljahrInt()).compareTo(o.getSchuljahrInt());
	}

}
