package gui.settings;

import data.DatabaseSettings;
import database.DatabaseLoginInfo;

/**
 * controller for settings-window (controller-view pattern)
 * 
 * @author Martin Pabst, 2010
 * 
 */

public class SettingsController {

	/**
	 * view for this controller
	 */
	private SettingsFrame sf;

	/**
	 * true, if window was exited using window-close-button or cancel button (=>
	 * so exit without saving values!)
	 */
	private boolean exitCancel = true;

	/**
	 * true, if window was exited using window-close-button or cancel button (=>
	 * so exit without saving values!)
	 */
	public boolean isExitCancel() {
		return exitCancel;
	}

	/**
	 * set this to true, if window was exited using window-close-button or
	 * cancel button (=> so exit without saving values!)
	 */

	public void setExitCancel(boolean exitCancel) {
		this.exitCancel = exitCancel;
	}

	/**
	 * constructor: constructs and shows modal view.
	 */
	public SettingsController() {
		sf = new SettingsFrame(this);
		writeValuesToGUI();
		sf.setModal(true);
		sf.setVisible(true);
	}

	/**
	 * write settings values to GUI
	 */
	public void writeValuesToGUI() {
		if (DatabaseSettings.getActiveDatabase().compareTo("Derby") == 0) {
			sf.getRbDerby().setSelected(true);
			sf.setDatabaseType("derby");
		} else {
			sf.getRbPostgres().setSelected(true);
			sf.setDatabaseType("postgres");
		}

		DatabaseLoginInfo dliDerby = DatabaseSettings.getDerbyLoginInfo();
		sf.getJTextFieldDerbyUsername().setText(dliDerby.getUsername());
		sf.getJTextFieldDerbyPath().setText(dliDerby.getPath());
		sf.getJPasswordFieldDerbyPassword().setText(dliDerby.getPassword());

		DatabaseLoginInfo dliPostgres = DatabaseSettings.getPostgresLoginInfo();
		sf.getJTextFieldPostgresUsername().setText(dliPostgres.getUsername());
		sf.getJTextFieldPostgresIP().setText(dliPostgres.getIp());
		sf.getJTextFieldPostgresPort().setText(dliPostgres.getPort());
		sf.getJPasswordFieldPostgresPassword().setText(
				dliPostgres.getPassword());

	}

	/**
	 * read settings values from GUI
	 */
	public void readValuesFromGui() {
		if (sf.getRbDerby().isSelected()) {
			DatabaseSettings.setActiveDatabase("Derby");
		} else {
			DatabaseSettings.setActiveDatabase("Postgres");
		}

		DatabaseLoginInfo dliDerby = DatabaseSettings.getDerbyLoginInfo();
		dliDerby.setType("derby");
		dliDerby.setName("Derby");
		dliDerby.setUsername(sf.getJTextFieldDerbyUsername().getText());
		dliDerby.setPassword(new String(sf.getJPasswordFieldDerbyPassword()
				.getPassword()));
		dliDerby.setPath(sf.getJTextFieldDerbyPath().getText());

		DatabaseLoginInfo dliPostgres = DatabaseSettings.getPostgresLoginInfo();
		dliPostgres.setType("postgres");
		dliPostgres.setName("Postgres");
		dliPostgres.setUsername(sf.getJTextFieldPostgresUsername().getText());
		dliPostgres.setPassword(new String(sf
				.getJPasswordFieldPostgresPassword().getPassword()));
		dliPostgres.setIp(sf.getJTextFieldPostgresIP().getText());
		dliPostgres.setPort(sf.getJTextFieldPostgresPort().getText());

		DatabaseSettings.writeSettings();

	}

}
