package logging;

import java.awt.Color;

/**
 * Logging output which writes everything to console.
 * 
 * @author Martin Pabst, 2009
 * 
 */
public class ConsoleOutput implements LogOutput {

	private int progressbarMaximum = 1;
	private int num = 0;
	private final int maxAsterisks = 20;
	private boolean started = false;

	/**
	 * log given String
	 */
	@Override
	public void out(String s) {
		System.out.print(s);
	}

	/**
	 * log given String in given color
	 */
	@Override
	public void outColor(String s, Color c) {
		out(s);
	}

	@Override
	public void outl(String s) {
		out(s + "\n");
	}

	@Override
	public void outlColor(String s, Color c) {
		outColor(s + "\n", c);

	}

	@Override
	public void setProgressBarMaximum(int n) {
		progressbarMaximum = n;
		num = 0;

		if (n == 0 && started) {
			out("]");
			started = false;
		}
		
		if (n > 0 ){
			started = true;
		}

	}

	@Override
	public void setProgressBarValue(int value, String s) {

		long numAsterisks = Math.round(((double) value
				/ (double) progressbarMaximum * (double) (maxAsterisks + 1)));
		if (numAsterisks > num) {

			if (num == 0) {
				out(" [");
			}

				out(".");


			if (num == maxAsterisks) {
				out("] ");
			}

			num++;
		}

	}
}
