package logging;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Implementation of OutputStream leveraging Log-class for output
 * 
 * @author Martin Pabst, 2009
 * 
 */
public class LogStream extends OutputStream {

	private static Color color = new Color(0xa0a0FF);

	private StringBuffer buffer = new StringBuffer(300);
	private LogLevel logLevel;

	public LogStream(LogLevel logLevel) {
		this.logLevel = logLevel;
	}

	@Override
	public void write(int b) throws IOException {
		buffer.append((char) b);
		if ((char) b == '\n') {
			flush();
		}
	}

	@Override
	public void flush() {
		Log.outColor(buffer.toString(), logLevel, color);
		buffer = new StringBuffer(300);
	}

}
