package workerthreads.changedates;

import java.util.ArrayList;

public class SchuleSchuljahrList extends ArrayList<SchuleSchuljahrInfo> {
	public void determineCorrectValues(int delta) {
		/**
		 * Example: if delta = +2, then calendar-references to
		 * Schule_schuljahr-entries from schuljahr 2010 should point to
		 * corresponding entry from schuljahr 2008.
		 * 
		 */

		for (SchuleSchuljahrInfo ssji : this) {
			int schuljahr = ssji.getSchuljahr();
			int correctSchuljahr = schuljahr - delta;

			ssji.setCorrectValue(findValue(ssji.getSchule_stamm_id(),
					correctSchuljahr));

		}

	}

	private SchuleSchuljahrInfo findValue(String schule_stamm_id, int schuljahr) {

		for (SchuleSchuljahrInfo ssji : this) {
			if (ssji.getSchule_stamm_id().compareTo(schule_stamm_id) == 0
					&& ssji.getSchuljahr() == schuljahr) {
				return ssji;
			}
		}
		return null;
	}

}
