package logging;

import java.awt.Color;

/**
 * simple class for logging
 * 
 * @author Martin Pabst, 2009
 * 
 */
public class Log {

	/**
	 * all log output is written to this object which implements LogOutput
	 */
	static LogOutput logOutput = null;

	/**
	 * minimum log level. log entries with log level lower than this are not
	 * printed
	 */
	static LogLevel minimumLogLevel = LogLevel.useful;

	/**
	 * print given string if logLevel <= minimumLogLevel
	 * 
	 * @param s
	 * @param logLevel
	 */
	public static void out(String s, LogLevel logLevel) {
		if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {

			if (logLevel == LogLevel.error) {
				logOutput.outColor(s, Color.red);
			} else {
				logOutput.out(s);
			}
		}
	}

	/**
	 * print given string + '\n' if logLevel <= minimumLogLevel
	 * 
	 * @param s
	 * @param logLevel
	 */
	public static void outl(String s, LogLevel logLevel) {
		if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
			if (logLevel == LogLevel.error) {
				logOutput.outlColor(s, Color.red);
			} else {
				logOutput.outl(s);
			}
		}
	}

	/**
	 * print given string in given color if logLevel <= minimumLogLevel
	 * 
	 * @param s
	 * @param logLevel
	 */
	public static void outColor(String s, LogLevel logLevel, Color c) {
		if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {

			if (logLevel == LogLevel.error) {
				logOutput.outColor(s, Color.red);
			} else {
				logOutput.outColor(s, c);
			}
		}
	}

	/**
	 * print given string + '\n' in given color if logLevel <= minimumLogLevel
	 * 
	 * @param s
	 * @param logLevel
	 */
	public static void outlColor(String s, LogLevel logLevel, Color c) {
		if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
			if (logLevel == LogLevel.error) {
				logOutput.outlColor(s, Color.red);
			} else {
				logOutput.outlColor(s, c);
			}
		}
	}

	/**
	 * Set class for log output. This class is used for all subsequent calls to
	 * out, outl, ...
	 * 
	 * @param lo
	 */
	public static void setLogOutput(LogOutput lo) {
		logOutput = lo;
	}

	/**
	 * returns minimum logging level
	 * 
	 * @return
	 */
	public static LogLevel getMinimumLogLevel() {
		return minimumLogLevel;
	}

	/**
	 * set minimum logging level. Only log-events higher or equal this level are
	 * logged to logOutput
	 * 
	 * @param minimumLogLevel
	 */
	public static void setMinimumLogLevel(LogLevel minimumLogLevel) {
		Log.minimumLogLevel = minimumLogLevel;
	}

	/**
	 * set maximum of progressbar-interval
	 * 
	 * @param n
	 */
	public static void setProgressBarMaximum(int n) {
		logOutput.setProgressBarMaximum(n);
	}

	/**
	 * set current value of progressbar together with String which is displayed
	 * inside progressbar
	 * 
	 * @param value
	 * @param s
	 */
	public static void setProgressBarValue(int value, String s) {
		logOutput.setProgressBarValue(value, s);
	}
	
	public static void printStackTrace(Exception e) {
		outl("", LogLevel.error);
		for (StackTraceElement ste : e.getStackTrace()) {
			outl(ste.toString(), LogLevel.error);
		}
		outl("", LogLevel.error);

	}


}
