package tools.file;

/**
 * 
 * This class capsulates a file tree
 * 
 * @author Martin
 * 
 */

public class FileTree extends FileTreeNode {
	/**
	 * basePath is the path to root of tree
	 */
	private Path basePath = new Path();

	/**
	 * constructor. We only need a basePath to construct filetree. leaves are
	 * attaced later
	 * 
	 * @param basePath
	 */
	public FileTree(Path basePath) {
		super("", null, true);
		this.basePath = basePath;
	}

	/**
	 * get basePath of fileTree
	 * 
	 * @return
	 */
	public Path getBasePath() {
		return basePath;
	}

	/**
	 * set basePath of fileTree
	 * 
	 * @param basePath
	 */
	public void setBasePath(Path basePath) {
		this.basePath = basePath;
	}

}
