package gui.settings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.WindowConstants;

/**
 * This code was edited or generated using CloudGarden's Jigloo SWT/Swing GUI
 * Builder, which is free for non-commercial use. If Jigloo is being used
 * commercially (ie, by a corporation, company or business for any purpose
 * whatever) then you should purchase a license for each developer using Jigloo.
 * Please visit www.cloudgarden.com for details. Use of Jigloo implies
 * acceptance of these licensing terms. A COMMERCIAL LICENSE HAS NOT BEEN
 * PURCHASED FOR THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED LEGALLY FOR
 * ANY CORPORATE OR COMMERCIAL PURPOSE.
 */
public class SettingsFrame extends javax.swing.JDialog {
	private SettingsController controller;
	private JPanel databaseSettingsPanel;
	private JPanel jPanel1;
	public JTextField jTextFieldDerbyUsername;
	private JLabel jLabel6;
	private JLabel jLabel5;
	private JLabel jLabel4;
	private JLabel jLabel3;
	public JTextField jTextFieldDerbyPath;
	private JPasswordField jPasswordFieldPostgresPassword;
	private JPasswordField jPasswordFieldDerbyPassword;
	private JPanel panelDerby;
	private JButton buttonCancel;
	private JButton buttonOK;
	private JPanel jPanelOKTest;
	private JLabel jLabel2;
	public JTextField jTextFieldPostgresUsername;
	private JLabel jLabel1;
	public JTextField jTextFieldPostgresPort;
	private JLabel labelPostgresPort;
	public JTextField jTextFieldPostgresIP;
	private JLabel labelPostgresIP;
	private JPanel panelPostgres;
	private JPanel panelMain;
	private ButtonGroup bgDatabaseConnection;
	private JRadioButton rbDerby;
	private JRadioButton rbPostgres;

	/**
	 * Auto-generated main method to display this JFrame
	 */

	public SettingsFrame() {
		super();
		initGUI();
	}

	public SettingsFrame(SettingsController controller) {
		this.controller = controller;
		initGUI();
	}

	private void initGUI() {
		try {
			BorderLayout thisLayout = new BorderLayout();
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			getContentPane().setLayout(thisLayout);
			this.setTitle("Einstellungen bearbeiten");
			{
				databaseSettingsPanel = new JPanel();
				BorderLayout databaseSettingsPanelLayout = new BorderLayout();
				getContentPane()
						.add(databaseSettingsPanel, BorderLayout.CENTER);
				databaseSettingsPanel.setLayout(databaseSettingsPanelLayout);
				databaseSettingsPanel.setPreferredSize(new java.awt.Dimension(
						381, 220));
				databaseSettingsPanel.setBorder(BorderFactory
						.createTitledBorder("Datenbankverbindung"));
				{
					jPanel1 = new JPanel();
					databaseSettingsPanel.add(getJPanelOKTest(),
							BorderLayout.SOUTH);
					databaseSettingsPanel.add(getPanelMain(),
							BorderLayout.CENTER);
					databaseSettingsPanel.add(jPanel1, BorderLayout.NORTH);
					{
						rbDerby = new JRadioButton();
						jPanel1.add(getRbDerby());
						rbDerby.setText("Einzelplatzversion (Derby)");
						rbDerby.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent evt) {
								rbDerbyActionPerformed(evt);
							}
						});
						getBgDatabaseConnection().add(rbDerby);
					}
					{
						rbPostgres = new JRadioButton();
						jPanel1.add(getRbPostgres());
						rbPostgres.setText("Mehrplatzversion (Postgres)");
						rbPostgres.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent evt) {
								rbPostgresActionPerformed(evt);
							}
						});
						getBgDatabaseConnection().add(rbPostgres);
					}
				}
			}
			pack();
			this.setSize(450, 300);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public JRadioButton getRbPostgres() {
		return rbPostgres;
	}

	public JRadioButton getRbDerby() {
		return rbDerby;
	}

	private ButtonGroup getBgDatabaseConnection() {
		if (bgDatabaseConnection == null) {
			bgDatabaseConnection = new ButtonGroup();
		}
		return bgDatabaseConnection;
	}

	private JPanel getPanelMain() {
		if (panelMain == null) {
			panelMain = new JPanel();
			CardLayout panelMainLayout = new CardLayout();
			panelMain.setLayout(panelMainLayout);
			panelMain.setPreferredSize(new java.awt.Dimension(382, 185));
			panelMain.setSize(382, 150);
			panelMain.add(getPanelDerby(), "cardDerby");
			panelMain.add(getPanelPostgres(), "cardPostgres");
		}
		return panelMain;
	}

	private JPanel getPanelPostgres() {
		if (panelPostgres == null) {
			panelPostgres = new JPanel();
			GroupLayout panelPostgresLayout = new GroupLayout(
					(JComponent) panelPostgres);
			panelPostgres.setLayout(panelPostgresLayout);
			panelPostgres.setPreferredSize(new java.awt.Dimension(382, 155));
			panelPostgresLayout
					.setHorizontalGroup(panelPostgresLayout
							.createSequentialGroup()
							.addContainerGap()
							.addGroup(
									panelPostgresLayout
											.createParallelGroup()
											.addGroup(
													GroupLayout.Alignment.LEADING,
													panelPostgresLayout
															.createSequentialGroup()
															.addComponent(
																	getJLabel2(),
																	GroupLayout.PREFERRED_SIZE,
																	131,
																	GroupLayout.PREFERRED_SIZE)
															.addGap(53))
											.addGroup(
													GroupLayout.Alignment.LEADING,
													panelPostgresLayout
															.createSequentialGroup()
															.addComponent(
																	getJLabel1(),
																	GroupLayout.PREFERRED_SIZE,
																	131,
																	GroupLayout.PREFERRED_SIZE)
															.addGap(53))
											.addGroup(
													GroupLayout.Alignment.LEADING,
													panelPostgresLayout
															.createSequentialGroup()
															.addComponent(
																	getLabelPostgresPort(),
																	GroupLayout.PREFERRED_SIZE,
																	131,
																	GroupLayout.PREFERRED_SIZE)
															.addGap(53))
											.addComponent(
													getLabelPostgresIP(),
													GroupLayout.Alignment.LEADING,
													GroupLayout.PREFERRED_SIZE,
													184,
													GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(
									LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(
									panelPostgresLayout
											.createParallelGroup()
											.addComponent(
													getJTextFieldPostgresPort(),
													GroupLayout.Alignment.LEADING,
													GroupLayout.PREFERRED_SIZE,
													215,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getJTextFieldPostgresIP(),
													GroupLayout.Alignment.LEADING,
													GroupLayout.PREFERRED_SIZE,
													215,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getJTextFieldPostgresUsername(),
													GroupLayout.Alignment.LEADING,
													GroupLayout.PREFERRED_SIZE,
													215,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getJPasswordFieldPostgresPassword(),
													GroupLayout.Alignment.LEADING,
													0, 215, Short.MAX_VALUE))
							.addContainerGap());
			panelPostgresLayout
					.setVerticalGroup(panelPostgresLayout
							.createSequentialGroup()
							.addContainerGap()
							.addGroup(
									panelPostgresLayout
											.createParallelGroup(
													GroupLayout.Alignment.BASELINE)
											.addComponent(
													getJTextFieldPostgresIP(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getLabelPostgresIP(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(
									LayoutStyle.ComponentPlacement.UNRELATED)
							.addGroup(
									panelPostgresLayout
											.createParallelGroup(
													GroupLayout.Alignment.BASELINE)
											.addComponent(
													getJTextFieldPostgresPort(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getLabelPostgresPort(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(
									LayoutStyle.ComponentPlacement.UNRELATED)
							.addGroup(
									panelPostgresLayout
											.createParallelGroup(
													GroupLayout.Alignment.BASELINE)
											.addComponent(
													getJTextFieldPostgresUsername(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getJLabel1(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(
									LayoutStyle.ComponentPlacement.UNRELATED)
							.addGroup(
									panelPostgresLayout
											.createParallelGroup(
													GroupLayout.Alignment.BASELINE)
											.addComponent(
													getJPasswordFieldPostgresPassword(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													21,
													GroupLayout.PREFERRED_SIZE)
											.addComponent(
													getJLabel2(),
													GroupLayout.Alignment.BASELINE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE,
													GroupLayout.PREFERRED_SIZE))
							.addContainerGap(58, 58));
		}
		return panelPostgres;
	}

	private JLabel getLabelPostgresIP() {
		if (labelPostgresIP == null) {
			labelPostgresIP = new JLabel();
			labelPostgresIP.setText("IP des Postgres-Servers:");
		}
		return labelPostgresIP;
	}

	public JTextField getJTextFieldPostgresIP() {
		if (jTextFieldPostgresIP == null) {
			jTextFieldPostgresIP = new JTextField();
		}
		return jTextFieldPostgresIP;
	}

	private JLabel getLabelPostgresPort() {
		if (labelPostgresPort == null) {
			labelPostgresPort = new JLabel();
			labelPostgresPort.setText("Port:");
		}
		return labelPostgresPort;
	}

	public JTextField getJTextFieldPostgresPort() {
		if (jTextFieldPostgresPort == null) {
			jTextFieldPostgresPort = new JTextField();
		}
		return jTextFieldPostgresPort;
	}

	private JLabel getJLabel1() {
		if (jLabel1 == null) {
			jLabel1 = new JLabel();
			jLabel1.setText("Benutzername:");
		}
		return jLabel1;
	}

	public JTextField getJTextFieldPostgresUsername() {
		if (jTextFieldPostgresUsername == null) {
			jTextFieldPostgresUsername = new JTextField();
		}
		return jTextFieldPostgresUsername;
	}

	private JLabel getJLabel2() {
		if (jLabel2 == null) {
			jLabel2 = new JLabel();
			jLabel2.setText("Passwort:");
		}
		return jLabel2;
	}

	private JPanel getJPanelOKTest() {
		if (jPanelOKTest == null) {
			jPanelOKTest = new JPanel();
			jPanelOKTest.add(getButtonCancel());
			jPanelOKTest.add(getButtonOK());
		}
		return jPanelOKTest;
	}

	private JButton getButtonOK() {
		if (buttonOK == null) {
			buttonOK = new JButton();
			buttonOK.setText("OK");
			buttonOK.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					buttonOKActionPerformed(evt);
				}
			});
		}
		return buttonOK;
	}

	private JButton getButtonCancel() {
		if (buttonCancel == null) {
			buttonCancel = new JButton();
			buttonCancel.setText("Abbrechen");
			buttonCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					buttonCancelActionPerformed(evt);
				}
			});
		}
		return buttonCancel;
	}

	private JPanel getPanelDerby() {
		if (panelDerby == null) {
			panelDerby = new JPanel();
			GroupLayout jPanel2Layout = new GroupLayout((JComponent) panelDerby);
			panelDerby.setPreferredSize(new java.awt.Dimension(382, 155));
			panelDerby.setLayout(jPanel2Layout);
			jPanel2Layout
					.setHorizontalGroup(jPanel2Layout
							.createSequentialGroup()
							.addContainerGap()
							.addGroup(
									jPanel2Layout
											.createParallelGroup()
											.addGroup(
													jPanel2Layout
															.createSequentialGroup()
															.addGroup(
																	jPanel2Layout
																			.createParallelGroup()
																			.addComponent(
																					getJLabel6(),
																					GroupLayout.Alignment.LEADING,
																					GroupLayout.PREFERRED_SIZE,
																					131,
																					GroupLayout.PREFERRED_SIZE)
																			.addComponent(
																					getJLabel5(),
																					GroupLayout.Alignment.LEADING,
																					GroupLayout.PREFERRED_SIZE,
																					131,
																					GroupLayout.PREFERRED_SIZE)
																			.addComponent(
																					getJLabel3(),
																					GroupLayout.Alignment.LEADING,
																					GroupLayout.PREFERRED_SIZE,
																					131,
																					GroupLayout.PREFERRED_SIZE))
															.addPreferredGap(
																	LayoutStyle.ComponentPlacement.UNRELATED)
															.addGroup(
																	jPanel2Layout
																			.createParallelGroup()
																			.addComponent(
																					getJTextFieldDerbyUsername(),
																					GroupLayout.Alignment.LEADING,
																					0,
																					259,
																					Short.MAX_VALUE)
																			.addComponent(
																					getJTextFieldDerbyPath(),
																					GroupLayout.Alignment.LEADING,
																					0,
																					259,
																					Short.MAX_VALUE)
																			.addComponent(
																					getJPasswordFieldDerbyPassword(),
																					GroupLayout.Alignment.LEADING,
																					0,
																					259,
																					Short.MAX_VALUE)))
											.addGroup(
													GroupLayout.Alignment.LEADING,
													jPanel2Layout
															.createSequentialGroup()
															.addComponent(
																	getJLabel4(),
																	GroupLayout.PREFERRED_SIZE,
																	261,
																	GroupLayout.PREFERRED_SIZE)
															.addGap(
																	0,
																	147,
																	Short.MAX_VALUE)))
							.addContainerGap());
			jPanel2Layout.setVerticalGroup(jPanel2Layout
					.createSequentialGroup().addContainerGap().addGroup(
							jPanel2Layout.createParallelGroup(
									GroupLayout.Alignment.BASELINE)
									.addComponent(getJTextFieldDerbyPath(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE)
									.addComponent(getJLabel3(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(getJLabel4(), GroupLayout.PREFERRED_SIZE,
							GroupLayout.PREFERRED_SIZE,
							GroupLayout.PREFERRED_SIZE).addPreferredGap(
							LayoutStyle.ComponentPlacement.RELATED).addGroup(
							jPanel2Layout.createParallelGroup(
									GroupLayout.Alignment.BASELINE)
									.addComponent(getJTextFieldDerbyUsername(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE)
									.addComponent(getJLabel5(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addGroup(
							jPanel2Layout.createParallelGroup(
									GroupLayout.Alignment.BASELINE)
									.addComponent(
											getJPasswordFieldDerbyPassword(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE, 21,
											GroupLayout.PREFERRED_SIZE)
									.addComponent(getJLabel6(),
											GroupLayout.Alignment.BASELINE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE,
											GroupLayout.PREFERRED_SIZE))
					.addContainerGap(83, 83));
		}
		return panelDerby;
	}

	public JTextField getJTextFieldDerbyPath() {
		if (jTextFieldDerbyPath == null) {
			jTextFieldDerbyPath = new JTextField();
		}
		return jTextFieldDerbyPath;
	}

	public JTextField getJTextFieldDerbyUsername() {
		if (jTextFieldDerbyUsername == null) {
			jTextFieldDerbyUsername = new JTextField();
		}
		return jTextFieldDerbyUsername;
	}

	private JLabel getJLabel3() {
		if (jLabel3 == null) {
			jLabel3 = new JLabel();
			jLabel3.setText("Pfad zur Datenbank:");
		}
		return jLabel3;
	}

	private JLabel getJLabel4() {
		if (jLabel4 == null) {
			jLabel4 = new JLabel();
			jLabel4.setText("(Tipp: Der Pfad hat die Form ...../database/asv)");
		}
		return jLabel4;
	}

	private JLabel getJLabel5() {
		if (jLabel5 == null) {
			jLabel5 = new JLabel();
			jLabel5.setText("Benutzername:");
		}
		return jLabel5;
	}

	private JLabel getJLabel6() {
		if (jLabel6 == null) {
			jLabel6 = new JLabel();
			jLabel6.setText("Passwort:");
		}
		return jLabel6;
	}

	public JPasswordField getJPasswordFieldDerbyPassword() {
		if (jPasswordFieldDerbyPassword == null) {
			jPasswordFieldDerbyPassword = new JPasswordField();
		}
		return jPasswordFieldDerbyPassword;
	}

	public JPasswordField getJPasswordFieldPostgresPassword() {
		if (jPasswordFieldPostgresPassword == null) {
			jPasswordFieldPostgresPassword = new JPasswordField();
		}
		return jPasswordFieldPostgresPassword;
	}

	private void rbDerbyActionPerformed(ActionEvent evt) {
		setDatabaseType("derby");
	}

	private void rbPostgresActionPerformed(ActionEvent evt) {
		setDatabaseType("postgres");
	}

	public void setDatabaseType(String type) {
		CardLayout cl = (CardLayout) getPanelMain().getLayout();
		if (type.compareTo("derby") == 0) {
			cl.show(getPanelMain(), "cardDerby");
		} else {
			cl.show(getPanelMain(), "cardPostgres");
		}
	}

	public static void main(String[] args) {
		SettingsFrame sf = new SettingsFrame();
		sf.setVisible(true);
	}

	private void buttonCancelActionPerformed(ActionEvent evt) {
		setVisible(false);
	}

	private void buttonOKActionPerformed(ActionEvent evt) {
		controller.readValuesFromGui();
		controller.setExitCancel(false);
		setVisible(false);
	}

}
