package tools.commandlineparser;

import java.util.ArrayList;

public class ArgumentParser {

	private String[] args;

	private ArrayList<Command> commands = new ArrayList<Command>();

	public ArgumentParser(String[] args) {
		this.args = args;
		parse();
	}

	private void parse() {

		Command command = null;

		for (String s : args) {
			if (s.startsWith("-")) {

				if (command != null) {
					commands.add(command);
				}

				command = new Command();
				command.setCommand(s);
			} else {
				if (s.startsWith("\"") && s.endsWith("\"")) {
					s = s.substring(1, s.length() - 1);
				}
				command.addParameter(s);
			}
		}
		
		if(command != null) {
			commands.add(command);
		}
		
	}

	public ArrayList<Command> getCommands(String commandstring) {
		ArrayList<Command> ret = new ArrayList<Command>();
		for (Command command : commands) {
			if (command.getCommand().equalsIgnoreCase(commandstring)) {
				ret.add(command);
			}
		}
		return ret;
	}

}
