/*
 * Decompiled with CFR 0.152.
 */
package gui.choosedialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ChooseDialog
extends JDialog
implements ActionListener {
    private int optionChosen = -1;
    private JRadioButton[] radioButtons;
    private JCheckBox[] checkBoxes;
    private boolean[] checkBoxState;
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancel = new JButton("Abbrechen");
    private boolean cancelPressed;

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    public ChooseDialog(JFrame owner, boolean modal, String[] radioButtonOptions, int radioButtonInitialValue, String title, String radioButtonQuestion, String[] checkBoxLabels, String checkBoxQuestion, boolean[] checkBoxInitialValues) {
        super((Frame)owner, modal);
        this.setSize(200, 200);
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setIconImage(owner.getIconImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 1));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder(blackline, radioButtonQuestion));
        ButtonGroup bg = new ButtonGroup();
        this.radioButtons = new JRadioButton[radioButtonOptions.length];
        int i = 0;
        while (i < radioButtonOptions.length) {
            JRadioButton rb;
            this.radioButtons[i] = rb = new JRadioButton(radioButtonOptions[i]);
            radioButtonPanel.add(rb);
            rb.addActionListener(this);
            bg.add(rb);
            ++i;
        }
        this.radioButtons[radioButtonInitialValue].setSelected(true);
        if (radioButtonOptions.length > 0) {
            mainPanel.add((Component)radioButtonPanel, "North");
        }
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 1));
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(blackline, checkBoxQuestion));
        int n = checkBoxLabels.length;
        if (checkBoxInitialValues.length < n) {
            n = checkBoxInitialValues.length;
        }
        this.checkBoxState = new boolean[n];
        this.checkBoxes = new JCheckBox[n];
        int i2 = 0;
        while (i2 < n) {
            JCheckBox cb = new JCheckBox(checkBoxLabels[i2]);
            cb.setSelected(checkBoxInitialValues[i2]);
            this.checkBoxes[i2] = cb;
            checkBoxPanel.add(cb);
            ++i2;
        }
        if (n > 0) {
            mainPanel.add((Component)checkBoxPanel, "Center");
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(this.buttonOK);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(this.buttonCancel);
        this.buttonOK.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        mainPanel.add((Component)buttonPanel, "South");
        this.optionChosen = -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancel) {
            this.optionChosen = -1;
            this.setVisible(false);
        }
        if (e.getSource() == this.buttonOK) {
            int i = 0;
            while (i < this.radioButtons.length) {
                if (this.radioButtons[i].isSelected()) {
                    this.optionChosen = i;
                }
                ++i;
            }
            i = 0;
            while (i < this.checkBoxes.length) {
                this.checkBoxState[i] = this.checkBoxes[i].isSelected();
                ++i;
            }
            this.setVisible(false);
        }
    }

    public int getOptionChosen() {
        return this.optionChosen;
    }

    public boolean[] getCheckBoxState() {
        return this.checkBoxState;
    }
}

