/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.awt.Color;
import logging.LogOutput;

public class ConsoleOutput
implements LogOutput {
    private int progressbarMaximum = 1;
    private int num = 0;
    private final int maxAsterisks = 20;
    private boolean started = false;

    @Override
    public void out(String s) {
        System.out.print(s);
    }

    @Override
    public void outColor(String s, Color c) {
        this.out(s);
    }

    @Override
    public void outl(String s) {
        this.out(String.valueOf(s) + "\n");
    }

    @Override
    public void outlColor(String s, Color c) {
        this.outColor(String.valueOf(s) + "\n", c);
    }

    @Override
    public void setProgressBarMaximum(int n) {
        this.progressbarMaximum = n;
        this.num = 0;
        if (n == 0 && this.started) {
            this.out("]");
            this.started = false;
        }
        if (n > 0) {
            this.started = true;
        }
    }

    @Override
    public void setProgressBarValue(int value, String s) {
        long numAsterisks = Math.round((double)value / (double)this.progressbarMaximum * 21.0);
        if (numAsterisks > (long)this.num) {
            if (this.num == 0) {
                this.out(" [");
            }
            this.out(".");
            if (this.num == 20) {
                this.out("] ");
            }
            ++this.num;
        }
    }
}

