/*
 * Decompiled with CFR 0.152.
 */
package tools.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import logging.Log;
import logging.LogLevel;

public class FileTool {
    public static boolean makeDir(String path) {
        return new File(path).mkdirs();
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            Log.outl(String.valueOf(ex.getMessage()) + " in the specified directory.", LogLevel.error);
            System.exit(0);
        }
        catch (IOException e) {
            Log.outl(e.getMessage(), LogLevel.error);
        }
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        return contents.toString();
    }

    public static ArrayList<String> readTextFileToArrayList(File file, String encoding) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.add(line);
            }
        }
        return contents;
    }

    public static void writeTextFile(File file, String encoding, ArrayList<String> contents) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            for (String s : contents) {
                writer.write(String.valueOf(s) + System.getProperty("line.separator"));
            }
        }
    }

    public static void writeTextFile(File file, String encoding, String contents, boolean append) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding);){
            writer.write(contents);
        }
    }
}

