/*
 * Decompiled with CFR 0.152.
 */
package workerthreads.changedates;

import data.DateChangeJob;
import data.Schuljahr;
import data.Settings;
import database.DatabaseAccess;
import gui.MainFrameController;
import java.awt.Color;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingWorker;
import logging.Log;
import logging.LogLevel;
import workerthreads.changedates.DateInfo;
import workerthreads.changedates.SchuleSchuljahrInfo;
import workerthreads.changedates.SchuleSchuljahrList;
import workerthreads.changedates.SchuljahrChangeInfo;

public class ChangeDatesWorker
extends SwingWorker<Void, String> {
    private static int[][] pkzHelper;
    private MainFrameController controller;
    private ArrayList<Schuljahr> schuljahre = new ArrayList();
    private ArrayList<SchuljahrChangeInfo> schuljahrChangeInfoList = new ArrayList();
    private ArrayList<DateInfo> dateInfos = new ArrayList();
    private int globalDelta = 0;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 6;
        nArray[4] = 3;
        nArray[5] = 7;
        nArray[6] = 4;
        nArray[7] = 8;
        nArray[8] = 5;
        nArray[9] = 9;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = 1;
        nArray2[2] = 9;
        nArray2[3] = 7;
        nArray2[4] = 5;
        nArray2[5] = 3;
        nArray2[6] = 8;
        nArray2[7] = 6;
        nArray2[8] = 4;
        nArray2[9] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 4;
        nArray3[4] = 6;
        nArray3[5] = 8;
        nArray3[6] = 3;
        nArray3[7] = 5;
        nArray3[8] = 7;
        nArray3[9] = 9;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[1] = 1;
        nArray4[2] = 9;
        nArray4[3] = 8;
        nArray4[4] = 7;
        nArray4[5] = 6;
        nArray4[6] = 5;
        nArray4[7] = 4;
        nArray4[8] = 3;
        nArray4[9] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[10];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 4;
        nArray5[5] = 5;
        nArray5[6] = 6;
        nArray5[7] = 7;
        nArray5[8] = 8;
        nArray5[9] = 9;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[10];
        nArray6[1] = 1;
        nArray6[2] = 9;
        nArray6[3] = 5;
        nArray6[4] = 8;
        nArray6[5] = 4;
        nArray6[6] = 7;
        nArray6[7] = 3;
        nArray6[8] = 6;
        nArray6[9] = 2;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[10];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 6;
        nArray7[4] = 3;
        nArray7[5] = 7;
        nArray7[6] = 4;
        nArray7[7] = 8;
        nArray7[8] = 5;
        nArray7[9] = 9;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[10];
        nArray8[1] = 1;
        nArray8[2] = 9;
        nArray8[3] = 7;
        nArray8[4] = 5;
        nArray8[5] = 3;
        nArray8[6] = 8;
        nArray8[7] = 6;
        nArray8[8] = 4;
        nArray8[9] = 2;
        nArrayArray[7] = nArray8;
        pkzHelper = nArrayArray;
    }

    public ChangeDatesWorker(MainFrameController controller, int globalDelta) {
        this.globalDelta = globalDelta;
        this.controller = controller;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.controller.setButtonsEnabled(false);
        this.controller.setWaitCursor(true);
        this.controller.enableProgressbar(true);
        this.controller.setProgressBarMaximum(-1);
        this.doInForeground();
        this.controller.setWaitCursor(false);
        this.controller.setButtonsEnabled(true);
        this.controller.enableProgressbar(false);
        return null;
    }

    public void doInForeground() {
        long timeStart;
        block10: {
            timeStart = System.currentTimeMillis();
            try {
                try {
                    DatabaseAccess.getActiveDatabase(false).openConnection();
                    this.getSchuljahre();
                    int i = 1;
                    for (DateChangeJob dcj : Settings.getDateChangeJobs()) {
                        if (!dcj.isOnlyCorrectCalendar()) {
                            try {
                                Log.out("Job " + i + " von " + Settings.getDateChangeJobs().size() + ": ", LogLevel.useful);
                                this.changeDates(dcj);
                            }
                            catch (Exception e) {
                                Log.outl("ChangeDatesWorker.changeDates(): " + e.toString(), LogLevel.error);
                                e.printStackTrace();
                                StringWriter w = new StringWriter();
                                Log.printStackTrace(e);
                            }
                        }
                        ++i;
                    }
                    if (Settings.getDateChangeJobs().size() > 0) {
                        this.correctCalendar(Settings.getDateChangeJobs().get(0));
                    }
                }
                catch (Exception ex) {
                    Log.outlColor("Fehler: " + ex.toString(), LogLevel.error, Color.red);
                    Log.printStackTrace(ex);
                    DatabaseAccess.getActiveDatabase(false).closeConnection();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DatabaseAccess.getActiveDatabase(false).closeConnection();
                throw throwable;
            }
            DatabaseAccess.getActiveDatabase(false).closeConnection();
        }
        Log.outl("", LogLevel.useful);
        Log.outlColor("Dauer: " + (System.currentTimeMillis() - timeStart) + " ms.", LogLevel.useful, Color.blue);
    }

    private void changeDates(DateChangeJob dateChangeJob) throws SQLException {
        long timeStart = System.currentTimeMillis();
        int d = this.getDelta(dateChangeJob);
        Log.outColor("aendere Spalte " + dateChangeJob.getAttribute() + " in Entitaet " + dateChangeJob.getEntity() + ": Addiere " + d + " Jahr" + (d * d > 1 ? "e" : "") + ". ", LogLevel.useful, Color.blue);
        if (this.columnExists(dateChangeJob)) {
            String attributeName = dateChangeJob.getAttribute();
            if (attributeName.equalsIgnoreCase("schuljahr_id") || attributeName.equalsIgnoreCase("abiturjahr_id")) {
                this.changeSchuljahrNeu(dateChangeJob, attributeName);
            } else {
                this.readDateInfo(dateChangeJob);
                this.changeDateInfo(dateChangeJob);
            }
        } else {
            Log.outColor(" Spalte existiert nicht.", LogLevel.useful, new Color(150, 0, 0));
        }
        Log.outlColor(" in " + (System.currentTimeMillis() - timeStart) + " ms.", LogLevel.useful, new Color(0, 125, 0));
        Log.outl("", LogLevel.useful);
    }

    private boolean columnExists(DateChangeJob dateChangeJob) {
        boolean exists = true;
        String query = "SELECT " + dateChangeJob.getAttribute() + " FROM " + dateChangeJob.getEntity();
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        try {
            Statement statement = connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                }
                resultSet.close();
            }
            catch (SQLException ex) {
                exists = false;
            }
            statement.close();
        }
        catch (SQLException e) {
            exists = false;
        }
        return exists;
    }

    private void getSchuljahrChangeInfo(DateChangeJob dateChangeJob, String attributeName) throws SQLException {
        this.schuljahrChangeInfoList.clear();
        int delta = this.getDelta(dateChangeJob);
        if (delta > 0) {
            int i = this.schuljahre.size() - 1;
            while (i - delta >= 0) {
                int oldSchoolyear = i - delta;
                int newSchoolyear = i--;
                this.getDateChangeInfoFromDataBase(dateChangeJob, oldSchoolyear, newSchoolyear, attributeName);
            }
        } else {
            int i = 0;
            while (i - delta < this.schuljahre.size()) {
                int oldSchoolyear = i - delta;
                int newSchoolyear = i++;
                this.getDateChangeInfoFromDataBase(dateChangeJob, oldSchoolyear, newSchoolyear, attributeName);
            }
        }
    }

    private void getDateChangeInfoFromDataBase(DateChangeJob dateChangeJob, int oldSchoolYear, int newSchoolyear, String attributeName) throws SQLException {
        String query = "SELECT ID FROM " + dateChangeJob.getEntity() + " WHERE " + attributeName + " = '" + this.schuljahre.get(oldSchoolYear).getId() + "'";
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        while (resultSet.next()) {
            String id = resultSet.getString(1);
            this.schuljahrChangeInfoList.add(new SchuljahrChangeInfo(id, this.schuljahre.get(newSchoolyear).getId()));
        }
        resultSet.close();
        statement.close();
    }

    private void correctCalendar(DateChangeJob dateChangeJob) throws SQLException {
        int delta = this.getDelta(dateChangeJob);
        Log.outColor("Korrigiere Referenzen svp_kalendertag.schule_schuljahr_id... ", LogLevel.useful, new Color(0, 100, 0));
        String query = "select ssj.ID, ssj.SCHULE_STAMM_ID, ssj.SCHULJAHR_ID,(select schulnummer from svp_schule_stamm sst where sst.id = ssj.schule_stamm_id),(select wlsj.kurzform from svp_wl_schuljahr wlsj where id = ssj.schuljahr_id) from SVP_SCHULE_SCHULJAHR ssj";
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        SchuleSchuljahrList ssjlist = new SchuleSchuljahrList();
        while (resultSet.next()) {
            String id = resultSet.getString(1);
            String schule_stamm_id = resultSet.getString(2);
            String schuljahr_id = resultSet.getString(3);
            String schulnummer = resultSet.getString(4);
            String schuljahrKurzform = resultSet.getString(5);
            SchuleSchuljahrInfo ssji = new SchuleSchuljahrInfo(id, schuljahr_id, schule_stamm_id, schulnummer, schuljahrKurzform);
            ssjlist.add(ssji);
        }
        resultSet.close();
        statement.close();
        ssjlist.determineCorrectValues(delta);
        Collections.sort(ssjlist);
        int i = 0;
        int increment = 1;
        int endIndex = ssjlist.size();
        if (delta < 0) {
            i = endIndex - 1;
            increment = -1;
            endIndex = -1;
        }
        Log.setProgressBarMaximum(ssjlist.size());
        int n = 0;
        try {
            do {
                SchuleSchuljahrInfo ssji = (SchuleSchuljahrInfo)ssjlist.get(i);
                Log.setProgressBarValue(n, "Schule " + ssji.getSchulnummer() + ", Schuljahr " + ssji.getSchuljahr() + "/" + (ssji.getSchuljahr() + 1) % 100);
                connection = DatabaseAccess.getActiveDatabase(false).getConnection();
                statement = connection.createStatement();
                if (ssji.getCorrectValue() != null) {
                    query = "UPDATE SVP_KALENDERTAG SET SCHULE_SCHULJAHR_ID = '" + ssji.getCorrectValue().getId() + "' " + "WHERE SCHULE_SCHULJAHR_ID = '" + ssji.getId() + "'";
                    statement.executeUpdate(query);
                } else {
                    String query1 = "DELETE FROM SVP_TERMIN WHERE KALENDERTAG_ID IN (SELECT ID FROM SVP_KALENDERTAG WHERE SCHULE_SCHULJAHR_ID = '" + ssji.getId() + "')";
                    String query2 = "DELETE FROM SVP_KALENDERTAG WHERE SCHULE_SCHULJAHR_ID = '" + ssji.getId() + "'";
                    statement.executeUpdate(query1);
                    statement.executeUpdate(query2);
                }
                statement.close();
                ++n;
            } while ((i += increment) != endIndex);
        }
        catch (Exception ex) {
            Log.outl("ChangeDatesWorker.correctCalendar: " + ex.toString(), LogLevel.error);
        }
        Log.outlColor("fertig.", LogLevel.useful, new Color(0, 100, 0));
    }

    private void changeSchuljahrNeu(DateChangeJob dateChangeJob, String attributeName) throws SQLException {
        int delta = this.getDelta(dateChangeJob);
        String deleteQuery = "";
        Statement statement = null;
        Connection connection = null;
        int i = 0;
        while (i < Math.abs(delta)) {
            deleteQuery = delta > 0 ? "DELETE FROM " + dateChangeJob.getEntity() + " WHERE " + attributeName + " = " + "'" + this.schuljahre.get(this.schuljahre.size() - 1 - i).getId() + "'" : "DELETE FROM " + dateChangeJob.getEntity() + " WHERE " + attributeName + " = " + "'" + this.schuljahre.get(0 + i).getId() + "'";
            connection = DatabaseAccess.getActiveDatabase(false).getConnection();
            statement = connection.createStatement();
            statement.executeUpdate(deleteQuery);
            statement.close();
            ++i;
        }
        this.getSchuljahrChangeInfo(dateChangeJob, attributeName);
        Log.setProgressBarMaximum(this.schuljahrChangeInfoList.size());
        i = 0;
        while (i < this.schuljahrChangeInfoList.size()) {
            SchuljahrChangeInfo info = this.schuljahrChangeInfoList.get(i);
            String query = "UPDATE " + dateChangeJob.getEntity() + " SET " + attributeName + " = '" + info.getNewSchoolYear() + "' WHERE ID = '" + info.getId() + "'";
            statement = connection.createStatement();
            statement.executeUpdate(query);
            statement.close();
            if (i % 10 == 0) {
                Log.setProgressBarValue(i, "aendere Datensatz " + i + " von " + this.schuljahrChangeInfoList.size() + ".");
            }
            ++i;
        }
        Log.setProgressBarMaximum(0);
        Log.outColor(this.schuljahrChangeInfoList.size() + " Datensaetze geaendert", LogLevel.useful, new Color(0, 125, 0));
    }

    private int getCount(DateChangeJob dateChangeJob) throws SQLException {
        String query = "SELECT COUNT(*) FROM " + dateChangeJob.getEntity();
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        this.dateInfos.clear();
        resultSet.next();
        String s = resultSet.getString(1);
        int ret = Integer.parseInt(s);
        resultSet.close();
        statement.close();
        return ret;
    }

    private void readDateInfo(DateChangeJob dateChangeJob) throws SQLException {
        int n = this.getCount(dateChangeJob);
        String query = "SELECT ID," + dateChangeJob.getAttribute() + " FROM " + dateChangeJob.getEntity();
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        this.dateInfos.clear();
        int i = 0;
        while (resultSet.next()) {
            String id = resultSet.getString(1);
            String date = resultSet.getString(2);
            this.dateInfos.add(new DateInfo(date, id));
            ++i;
        }
        Log.out(this.dateInfos.size() + " Datensaetze gelesen... ", LogLevel.useful);
        resultSet.close();
        statement.close();
    }

    private void getSchuljahre() throws SQLException {
        Log.outColor("Hole Schuljahre: ", LogLevel.useful, Color.blue);
        String query = "SELECT ID, KURZFORM FROM SVP_WL_SCHULJAHR";
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        this.schuljahre.clear();
        while (resultSet.next()) {
            String id = resultSet.getString(1);
            String schuljahr = resultSet.getString(2);
            if (schuljahr.length() != 7) continue;
            schuljahr = schuljahr.substring(0, 4);
            this.schuljahre.add(new Schuljahr(id, schuljahr));
            Log.out(schuljahr + ", ", LogLevel.useful);
        }
        Log.outl("\n", LogLevel.useful);
        Collections.sort(this.schuljahre);
        resultSet.close();
        statement.close();
    }

    private void changeDateInfo(DateChangeJob dateChangeJob) throws SQLException {
        int n = this.dateInfos.size();
        Log.setProgressBarMaximum(n);
        String sDelta = "" + this.getDelta(dateChangeJob);
        if (sDelta.startsWith("+")) {
            sDelta = sDelta.substring(1);
        }
        int delta = Integer.parseInt(sDelta);
        int i = 1;
        int changed = 0;
        for (DateInfo di : this.dateInfos) {
            String date = di.getDate();
            if (date != null) {
                String newDate = date;
                String quotation = "'";
                if (dateChangeJob.isIntegerAttribute()) {
                    quotation = "";
                    if (!date.isEmpty()) {
                        try {
                            int newDateInt = Integer.parseInt(date);
                            newDate = "" + (newDateInt + delta);
                        }
                        catch (NumberFormatException newDateInt) {}
                    }
                } else if (dateChangeJob.getAttribute().compareToIgnoreCase("pkz") == 0 || dateChangeJob.getAttribute().compareToIgnoreCase("pkz_wunsch") == 0) {
                    newDate = ChangeDatesWorker.changePKZ(delta, date);
                    Log.out("PKZ " + date + " -> " + newDate, LogLevel.trace);
                } else {
                    newDate = this.changeDateString(delta, date);
                }
                if (date.compareToIgnoreCase(newDate) != 0) {
                    String query = "UPDATE " + dateChangeJob.getEntity() + " SET " + dateChangeJob.getAttribute() + " = " + quotation + newDate + quotation + " WHERE ID = '" + di.getId() + "'";
                    Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(query);
                    statement.close();
                    ++changed;
                }
            }
            Log.setProgressBarValue(i, i + " Datensaetze geaendert.");
            ++i;
        }
        Log.setProgressBarMaximum(0);
        Log.outColor(changed + " Datensaetze geaendert", LogLevel.useful, new Color(0, 125, 0));
    }

    public static String changePKZ(int delta, String oldPKZ) {
        String newDate = oldPKZ;
        if (oldPKZ.length() == 9 && oldPKZ.charAt(0) != ' ') {
            String lfdNr = oldPKZ.substring(0, 2);
            String day = oldPKZ.substring(2, 4);
            String month = oldPKZ.substring(4, 6);
            String year = oldPKZ.substring(6, 8);
            int pz = ChangeDatesWorker.getPruefziffer(oldPKZ.substring(0, 8));
            if (pz != Integer.parseInt(oldPKZ.substring(8, 9))) {
                Log.outl("Falsche Pr\u00fcfziffer: " + oldPKZ + "; " + pz, LogLevel.error);
            }
            int iYear = Integer.parseInt(year);
            if (month.compareTo("02") == 0 && day.compareTo("29") == 0) {
                day = "28";
            }
            if (month.compareTo("02") == 0 && day.compareTo("28") == 0 && (iYear + delta) % 4 == 0) {
                day = "29";
            }
            newDate = String.valueOf(lfdNr) + day + month + (iYear + delta);
            newDate = String.valueOf(newDate) + ChangeDatesWorker.getPruefziffer(newDate);
        }
        return newDate;
    }

    public String changeDateString(int delta, String date) {
        String newDate = date;
        if (date.length() >= 4) {
            String newYear;
            String year = date.substring(0, 4);
            int iyear = Integer.parseInt(year);
            newDate = newYear = "" + (iyear + delta);
            if (date.length() > 4) {
                String month = date.substring(5, 7);
                String day = date.substring(8, 10);
                if (month.compareTo("02") == 0 && day.compareTo("29") == 0) {
                    day = "28";
                }
                if (month.compareTo("02") == 0 && day.compareTo("28") == 0 && (iyear + delta) % 4 == 0) {
                    day = "29";
                }
                newDate = String.valueOf(newDate) + "-" + month + "-" + day;
            }
            String tail = date.substring(newDate.length());
            newDate = String.valueOf(newDate) + tail;
        }
        return newDate;
    }

    public static int getPruefziffer(String pKZAnfang) {
        int summe = 0;
        int x2 = 0;
        int x3 = 0;
        int x = 1;
        while (x <= 8) {
            x2 = Integer.parseInt(pKZAnfang.substring(x - 1, x));
            summe += pkzHelper[x - 1][x2];
            ++x;
        }
        x3 = (summe / 10 + 1) * 10 - summe;
        if (x3 == 10) {
            x3 = 0;
        }
        return x3;
    }

    private int getDelta(DateChangeJob dateChangeJob) {
        return this.globalDelta != 0 ? this.globalDelta : dateChangeJob.getDeltaInt();
    }
}

