/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.ArrayList;
import tools.string.StringTool;

public class Script {
    private String statements;
    private ArrayList<String> singleStatements = new ArrayList();
    private String identifier;

    public String getStatements() {
        return this.statements;
    }

    public void setStatements(String statements) {
        this.statements = statements;
        this.singleStatements = this.chopSQLScript(statements);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Script(String statements, String identifier) {
        this.setStatements(statements);
        this.identifier = identifier;
    }

    public String toString() {
        String ret = "Name: " + this.identifier + "\n";
        ret = this.singleStatements.size() == 1 ? String.valueOf(ret) + "Statements: " + this.statements : String.valueOf(ret) + "; " + this.singleStatements.size() + " statements.";
        ret = String.valueOf(ret) + "\n";
        return ret;
    }

    private ArrayList<String> chopSQLScript(String script) {
        boolean readInsideQuotationMarks = false;
        String statement = "";
        ArrayList<String> ret = new ArrayList<String>();
        int pos = 0;
        int a = 0;
        while (pos < script.length()) {
            switch (script.charAt(pos)) {
                case '\'': {
                    readInsideQuotationMarks = !readInsideQuotationMarks;
                    break;
                }
                case ';': {
                    if (readInsideQuotationMarks) break;
                    statement = script.substring(a, pos + 1);
                    if ((statement = this.deleteStartComment(statement)).length() > 3) {
                        ret.add(statement);
                    }
                    a = pos + 1;
                    break;
                }
            }
            ++pos;
        }
        if (a < script.length() - 1) {
            statement = script.substring(a, script.length());
            if ((statement = this.deleteStartComment(statement)).length() > 3) {
                ret.add(statement);
            }
        }
        return ret;
    }

    private String deleteStartComment(String query) {
        query = StringTool.deleteBeginSpace(query);
        while (query.startsWith("--")) {
            int pos = 0;
            while (pos < query.length() && query.charAt(pos) != '\n') {
                ++pos;
            }
            if (pos >= query.length()) continue;
            query = query.substring(pos + 1);
        }
        return query;
    }

    public ArrayList<String> getSingleStatements() {
        return this.singleStatements;
    }
}

