/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DateChangeJob;
import data.DateChangeJobList;
import data.Script;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import logging.Log;
import logging.LogLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tools.file.FileTool;
import tools.xml.XMLReader;

public class Settings {
    private static DateChangeJobList dateChangeJobs = new DateChangeJobList();
    private static ArrayList<Script> scripts = new ArrayList();
    private static String fitnesseRoot = "";
    private static int fitnesseDestinationSchoolyear = 2009;
    private static int schuljahrFuerDateienOhneMarker;
    private static String fitnesseProtocoll;
    private static boolean fitnesseWriteChanges;

    static {
        fitnesseProtocoll = null;
        fitnesseWriteChanges = false;
    }

    public static String getFitnesseProtocoll() {
        return fitnesseProtocoll;
    }

    public static void readSettings() {
        try {
            Document doc = XMLReader.readFile("jobs.xml");
            Element root = XMLReader.root(doc);
            Log.outlColor("Einstellungen laden:", LogLevel.info, Color.blue);
            Log.outl("", LogLevel.info);
            if (root.getNodeName().compareTo("settings") != 0) {
                throw new Exception("Element \"settings\" in der Datei einstellungen.xml erwartet.");
            }
            Element settings = root;
            Element xmlFitnesseRoot = XMLReader.element(settings, "fitnesseroot");
            fitnesseRoot = XMLReader.attributeNotNull(xmlFitnesseRoot, "path");
            Log.out("\nFitnesseroot: " + fitnesseRoot, LogLevel.info);
            String sFitnesseDestSchoolyear = XMLReader.attribute(xmlFitnesseRoot, "neuesbasisschuljahr");
            fitnesseDestinationSchoolyear = 2009;
            if (sFitnesseDestSchoolyear != null) {
                fitnesseDestinationSchoolyear = Integer.parseInt(sFitnesseDestSchoolyear.substring(0, 4));
            }
            Log.outl("\nNeues Basisschuljahr: " + Settings.intToSchuljahrString(fitnesseDestinationSchoolyear), LogLevel.info);
            String sSchuljahrfuerdateienohnemarker = XMLReader.attribute(xmlFitnesseRoot, "schuljahrfuerdateienohnemarker");
            schuljahrFuerDateienOhneMarker = 2008;
            if (sSchuljahrfuerdateienohnemarker != null) {
                schuljahrFuerDateienOhneMarker = Integer.parseInt(sSchuljahrfuerdateienohnemarker.substring(0, 4));
            }
            Log.outl("\nF\u00fcr Dateien ohne Marker wird als Basisschuljahr " + Settings.intToSchuljahrString(schuljahrFuerDateienOhneMarker) + " angenommen.", LogLevel.info);
            String sFitnesseProtocoll = XMLReader.attribute(xmlFitnesseRoot, "protocoll");
            if (sFitnesseProtocoll != null) {
                fitnesseProtocoll = sFitnesseProtocoll;
            }
            Log.outl("\nProtokoll f\u00fcr Fitnesse-\u00c4nderungen: " + sFitnesseProtocoll, LogLevel.info);
            String sFitnesseWriteChanges = XMLReader.attribute(xmlFitnesseRoot, "writechanges");
            if (sFitnesseWriteChanges != null) {
                fitnesseWriteChanges = sFitnesseWriteChanges.compareToIgnoreCase("true") == 0;
            }
            Log.outl("\nAenderungen in originale Fitnesse-Scripte schreiben: " + sFitnesseWriteChanges, LogLevel.info);
            List<Element> xmlDateChangeJobs = XMLReader.elements(settings, "dateChangeJob");
            dateChangeJobs.clear();
            for (Element element : xmlDateChangeJobs) {
                DateChangeJob dcj = new DateChangeJob(XMLReader.attributeNotNull(element, "entity"), XMLReader.attributeNotNull(element, "attribute"), XMLReader.attributeNotNull(element, "delta"), XMLReader.attributeNotNull(element, "onlycorrectcalendar").compareToIgnoreCase("true") == 0);
                dateChangeJobs.add(dcj);
                Log.outlColor("DateChangeJob: ", LogLevel.info, Color.blue);
                Log.outl(dcj.toString(), LogLevel.info);
            }
            Log.outl("", LogLevel.info);
            List<Element> xmlScripts = XMLReader.elements(settings, "script");
            scripts.clear();
            for (Element element2 : xmlScripts) {
                String statements = Settings.getText(element2);
                String name = XMLReader.attributeNotNull(element2, "name");
                Script script = new Script(statements, name);
                scripts.add(script);
                Log.outlColor("Scripts: ", LogLevel.info, Color.blue);
                Log.outl(script.toString(), LogLevel.info);
                Log.outl("", LogLevel.info);
            }
            List<Element> xmlNewDateChangeJobs = XMLReader.elements(settings, "newDateChangeJob");
            for (Element element3 : xmlNewDateChangeJobs) {
                String delta = XMLReader.attributeNotNull(element3, "delta");
                String text = Settings.getText(element3);
                boolean onlyCorrectCalendar = XMLReader.elementBooleanAttribute(element3, "onlycorrectcalendar");
                Settings.parseAttributes(text, delta, onlyCorrectCalendar);
            }
        }
        catch (Exception e) {
            Log.outl(String.valueOf(e.toString()) + e.getStackTrace().toString(), LogLevel.error);
        }
    }

    public static boolean isFitnesseWriteChanges() {
        return fitnesseWriteChanges;
    }

    public static String intToSchuljahrString(int sj) {
        int sjp1 = (sj + 1) % 100;
        return String.valueOf(sj) + "/" + (sjp1 < 10 ? "0" : "") + sjp1;
    }

    public static int getSchuljahrFuerDateienOhneMarker() {
        return schuljahrFuerDateienOhneMarker;
    }

    private static String getText(Element element) {
        String filename = XMLReader.attributeNotNull(element, "filename");
        String text = "";
        if (!filename.isEmpty() && filename.length() > 2) {
            try {
                File file = new File(filename);
                text = FileTool.readTextFile(file, "UTF-8");
            }
            catch (IOException ex) {
                Log.outl("Fehler: Kann Datei " + filename + " nicht lesen. " + ex.toString(), LogLevel.error);
            }
        } else {
            text = XMLReader.text(element);
        }
        return text;
    }

    private static void parseAttributes(String text, String delta, boolean onlyCorrectCalendar) {
        DateChangeJob dcj;
        State state = State.PARSEBLANK;
        int i = 0;
        char c = ' ';
        String entity = "";
        String attribute = "";
        while (i < text.length()) {
            c = text.charAt(i);
            switch (state) {
                case PARSEATTRIBUTE: {
                    if (!Settings.isBlank(c)) {
                        attribute = String.valueOf(attribute) + c;
                    } else {
                        if (!attribute.isEmpty() && !entity.isEmpty()) {
                            dcj = new DateChangeJob(entity, attribute, delta, onlyCorrectCalendar);
                            dateChangeJobs.add(dcj);
                            Log.outlColor("DateChangeJob: ", LogLevel.info, Color.blue);
                            Log.outl(dcj.toString(), LogLevel.info);
                        }
                        attribute = "";
                        entity = "";
                        state = State.PARSEBLANK;
                    }
                    ++i;
                    break;
                }
                case PARSEENTITY: {
                    if (c != '.') {
                        entity = String.valueOf(entity) + c;
                    } else {
                        state = State.PARSEATTRIBUTE;
                    }
                    ++i;
                    break;
                }
                case PARSEBLANK: {
                    if (Settings.isBlank(c)) {
                        ++i;
                        break;
                    }
                    state = State.PARSEENTITY;
                    break;
                }
            }
        }
        if (!attribute.isEmpty() && !entity.isEmpty()) {
            dcj = new DateChangeJob(entity, attribute, delta, onlyCorrectCalendar);
            dateChangeJobs.add(dcj);
            Log.outlColor("DateChangeJob: ", LogLevel.info, Color.blue);
            Log.outl(dcj.toString(), LogLevel.info);
        }
    }

    private static boolean isBlank(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == ',';
    }

    public static ArrayList<DateChangeJob> getDateChangeJobs() {
        return dateChangeJobs;
    }

    public static ArrayList<Script> getScripts() {
        return scripts;
    }

    public static String getFitnesseRoot() {
        return fitnesseRoot;
    }

    public static int getFitnesseDestinationSchoolyear() {
        return fitnesseDestinationSchoolyear;
    }

    static enum State {
        PARSEENTITY,
        PARSEATTRIBUTE,
        PARSEBLANK;

    }
}

