/*
 * Decompiled with CFR 0.152.
 */
package database;

import java.sql.Connection;

public abstract class DatabaseAccess {
    protected String name;
    protected String username;
    protected String password;
    protected Connection connection;
    private static DatabaseAccess activeASVDatabase;
    private static DatabaseAccess activeCacheDatabase;

    public static DatabaseAccess getActiveDatabase(boolean cache) {
        if (cache) {
            return activeCacheDatabase;
        }
        return activeASVDatabase;
    }

    public static void setActiveDatabase(DatabaseAccess activeDatabase) {
        activeASVDatabase = activeDatabase;
    }

    public abstract void openConnection() throws Exception;

    public abstract void closeConnection();

    public Connection getConnection() {
        try {
            this.connection.setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    public DatabaseAccess(String name, String username, String password) {
        this.username = username;
        this.password = password;
        this.name = name;
    }

    public static void setActiveASVDatabase(DatabaseAccess activeASVDatabase) {
        DatabaseAccess.activeASVDatabase = activeASVDatabase;
    }

    public static void setActiveCacheDatabase(DatabaseAccess activeCacheDatabase) {
        DatabaseAccess.activeCacheDatabase = activeCacheDatabase;
    }
}

