/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DatabaseAccess;
import java.awt.Color;
import java.sql.DriverManager;
import java.sql.SQLException;
import logging.Log;
import logging.LogLevel;

public class PostgresDatabaseAccess
extends DatabaseAccess {
    private String ip;
    private String port;
    private String databaseName;

    public PostgresDatabaseAccess(String name, String username, String password, String ip, String port, String databaseName) {
        super(name, username, password);
        this.ip = ip;
        this.port = port;
        this.databaseName = databaseName;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                Log.outColor("Postgres-connection geschlossen.", LogLevel.useful, new Color(0, 150, 0));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void openConnection() throws Exception {
        Log.outColor("Verbinde mit Postgres-Datenbank...", LogLevel.useful, new Color(0, 150, 0));
        Class.forName("org.postgresql.Driver");
        String dbURL = "jdbc:postgresql://" + this.ip + ":" + this.port + "/" + this.databaseName;
        this.connection = DriverManager.getConnection(dbURL, this.username, this.password);
        this.connection.setAutoCommit(false);
        Log.outlColor("OK!", LogLevel.useful, new Color(0, 150, 0));
    }
}

