/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.awt.Color;
import logging.LogLevel;
import logging.LogOutput;

public class Log {
    static LogOutput logOutput = null;
    static LogLevel minimumLogLevel = LogLevel.useful;

    public static void out(String s, LogLevel logLevel) {
        if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
            if (logLevel == LogLevel.error) {
                logOutput.outColor(s, Color.red);
            } else {
                logOutput.out(s);
            }
        }
    }

    public static void outl(String s, LogLevel logLevel) {
        if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
            if (logLevel == LogLevel.error) {
                logOutput.outlColor(s, Color.red);
            } else {
                logOutput.outl(s);
            }
        }
    }

    public static void outColor(String s, LogLevel logLevel, Color c) {
        if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
            if (logLevel == LogLevel.error) {
                logOutput.outColor(s, Color.red);
            } else {
                logOutput.outColor(s, c);
            }
        }
    }

    public static void outlColor(String s, LogLevel logLevel, Color c) {
        if (logLevel.compareTo(minimumLogLevel) >= 0 && logOutput != null) {
            if (logLevel == LogLevel.error) {
                logOutput.outlColor(s, Color.red);
            } else {
                logOutput.outlColor(s, c);
            }
        }
    }

    public static void setLogOutput(LogOutput lo) {
        logOutput = lo;
    }

    public static LogLevel getMinimumLogLevel() {
        return minimumLogLevel;
    }

    public static void setMinimumLogLevel(LogLevel minimumLogLevel) {
        Log.minimumLogLevel = minimumLogLevel;
    }

    public static void setProgressBarMaximum(int n) {
        logOutput.setProgressBarMaximum(n);
    }

    public static void setProgressBarValue(int value, String s) {
        logOutput.setProgressBarValue(value, s);
    }

    public static void printStackTrace(Exception e) {
        Log.outl("", LogLevel.error);
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            Log.outl(ste.toString(), LogLevel.error);
            ++n2;
        }
        Log.outl("", LogLevel.error);
    }
}

