/*
 * Decompiled with CFR 0.152.
 */
package tools.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import logging.Log;
import tools.file.FileTree;
import tools.file.FileTreeNode;
import tools.file.Path;

public class RecursiveFileListing {
    private static int directoriesParsed = 0;

    public static List<File> getRecursiveFileList(String path, String type, boolean withDirectories, String excludeSuffix) throws FileNotFoundException {
        if (path.length() > 0) {
            if (path.charAt(path.length() - 1) != '\\' && path.charAt(path.length() - 1) != '/') {
                path = String.valueOf(path) + "\\";
            }
            File startingDir = new File(path);
            RecursiveFileListing.validateDirectory(startingDir);
            return RecursiveFileListing.getFileListing(startingDir, withDirectories, type.toLowerCase(), excludeSuffix);
        }
        throw new FileNotFoundException("Path has lengt 0.");
    }

    private static List<File> getFileListing(File aStartingDir, boolean withDirectories, String type, String excludeSuffix) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        int i = 0;
        while (i < filesAndDirs.length) {
            File file = filesAndDirs[i];
            if (!file.getName().endsWith(excludeSuffix)) {
                if (file.isDirectory()) {
                    if (withDirectories) {
                        result.add(file);
                    }
                    List<File> deeperList = RecursiveFileListing.getFileListing(file, withDirectories, type, excludeSuffix);
                    result.addAll(deeperList);
                } else if (type.isEmpty() || file.toString().toLowerCase().endsWith(type)) {
                    result.add(file);
                }
            }
            ++i;
        }
        Log.setProgressBarValue(-1, ++directoriesParsed + " folders scanned.");
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static FileTree getFileTree(String path) throws FileNotFoundException {
        if (path.length() > 0) {
            if (path.charAt(path.length() - 1) != '\\' && path.charAt(path.length() - 1) != '/') {
                path = String.valueOf(path) + "\\";
            }
            File startingDir = new File(path);
            RecursiveFileListing.validateDirectory(startingDir);
            FileTree fileTree = new FileTree(new Path(path, false, false));
            RecursiveFileListing.getNode(startingDir, fileTree);
            return fileTree;
        }
        throw new FileNotFoundException("Path has lengt 0.");
    }

    private static void getNode(File aStartingDir, FileTreeNode node) throws FileNotFoundException {
        File[] filesAndDirs = aStartingDir.listFiles();
        int i = 0;
        while (i < filesAndDirs.length) {
            File file = filesAndDirs[i];
            if (!file.isFile()) {
                FileTreeNode dir = new FileTreeNode(file.getName(), node, true);
                RecursiveFileListing.getNode(file, dir);
            } else {
                FileTreeNode fileTreeNode = new FileTreeNode(file.getName(), node, false);
            }
            ++i;
        }
    }
}

