/*
 * Decompiled with CFR 0.152.
 */
package workerthreads;

import data.Script;
import data.Settings;
import database.DatabaseAccess;
import gui.MainFrameController;
import java.awt.Color;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import logging.Log;
import logging.LogLevel;

public class ExecuteScriptsWorker
extends SwingWorker<Void, String> {
    private MainFrameController controller;
    private String path;
    private ArrayList<String> views = new ArrayList();

    public ExecuteScriptsWorker(MainFrameController controller) {
        this.controller = controller;
    }

    @Override
    protected Void doInBackground() throws Exception {
        block6: {
            this.controller.setButtonsEnabled(false);
            this.controller.setWaitCursor(true);
            this.controller.enableProgressbar(true);
            this.controller.setProgressBarMaximum(-1);
            try {
                try {
                    DatabaseAccess.getActiveDatabase(false).openConnection();
                    for (Script script : Settings.getScripts()) {
                        this.executeScript(script);
                    }
                }
                catch (Exception e) {
                    Log.outl("ExecuteScriptsWorker: " + e.toString(), LogLevel.error);
                    DatabaseAccess.getActiveDatabase(false).closeConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DatabaseAccess.getActiveDatabase(false).closeConnection();
                throw throwable;
            }
            DatabaseAccess.getActiveDatabase(false).closeConnection();
        }
        this.controller.setWaitCursor(false);
        this.controller.setButtonsEnabled(true);
        this.controller.enableProgressbar(false);
        return null;
    }

    private void executeScript(Script script) throws SQLException {
        Statement statement;
        Connection connection;
        Log.out("F\u00fchre Script " + script.getIdentifier() + " aus: ", LogLevel.useful);
        ArrayList<String> scripts = script.getSingleStatements();
        Log.setProgressBarMaximum(scripts.size());
        int i = 1;
        int linesChanged = 0;
        long time = System.currentTimeMillis();
        this.views.clear();
        for (String query : scripts) {
            Log.setProgressBarValue(i, "Statement " + i + " von " + scripts.size());
            query = this.deleteEndSpace(query);
            query = this.deleteBeginSpace(query);
            if (query.endsWith(";")) {
                query = query.substring(0, query.length() - 1);
            }
            connection = DatabaseAccess.getActiveDatabase(false).getConnection();
            statement = connection.createStatement();
            try {
                int returncode = statement.executeUpdate(query);
                linesChanged += returncode;
                statement.close();
                this.rememberview(query);
            }
            catch (SQLException ex) {
                Log.outl("SQLException: " + ex.toString(), LogLevel.error);
            }
            ++i;
        }
        if (this.views.size() > 0) {
            Log.outl("Ungeschlossene views: ", LogLevel.error);
            for (String identifier : this.views) {
                Log.outl("Schlie\u00dfe " + identifier, LogLevel.useful);
                connection = DatabaseAccess.getActiveDatabase(false).getConnection();
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("drop view " + identifier);
                    statement.close();
                }
                catch (SQLException ex) {
                    Log.outl("SQLException: " + ex.toString(), LogLevel.error);
                }
            }
        }
        Log.outlColor(linesChanged + " Zeilen ge\u00e4ndert. " + "Dauer: " + (System.currentTimeMillis() - time) + " ms.", LogLevel.useful, Color.blue);
    }

    private void rememberview(String query) {
        String query1 = query.toLowerCase();
        if (query1.startsWith("create")) {
            query1 = query1.substring("create".length());
            if ((query1 = this.deleteBeginSpace(query1)).toLowerCase().startsWith("view")) {
                query1 = query1.substring("view".length());
                query1 = this.deleteBeginSpace(query1);
                int pos = 0;
                while (pos < query1.length() && !this.isSpace(query1.charAt(pos)) && query1.charAt(pos) != ';') {
                    ++pos;
                }
                String viewIdentifier = query1.substring(0, pos);
                this.views.add(viewIdentifier);
                Log.outl("View " + viewIdentifier + " definiert.", LogLevel.trace);
            }
        } else if (query1.startsWith("drop")) {
            query1 = query1.substring("drop".length());
            if ((query1 = this.deleteBeginSpace(query1)).toLowerCase().startsWith("view")) {
                query1 = query1.substring("view".length());
                query1 = this.deleteBeginSpace(query1);
                int pos = 0;
                while (pos < query1.length() && !this.isSpace(query1.charAt(pos)) && query1.charAt(pos) != ';') {
                    ++pos;
                }
                String viewIdentifier = query1.substring(0, pos);
                int i = 0;
                while (i < this.views.size()) {
                    if (this.views.get(i).compareTo(viewIdentifier) == 0) {
                        this.views.remove(i);
                        Log.outl("View " + viewIdentifier + " gel\u00f6scht.", LogLevel.trace);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private String deleteEndSpace(String s) {
        while (s != null && !s.isEmpty() && this.isSpace(s.charAt(s.length() - 1))) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String deleteBeginSpace(String s) {
        while (s != null & !s.isEmpty() && this.isSpace(s.charAt(0))) {
            s = s.substring(1);
        }
        return s;
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }
}

