/*
 * Decompiled with CFR 0.152.
 */
package workerthreads.fitnessescriptcorrector;

import data.Settings;
import java.util.Calendar;
import workerthreads.changedates.ChangeDatesWorker;
import workerthreads.fitnessescriptcorrector.Token;
import workerthreads.fitnessescriptcorrector.TokenList;
import workerthreads.fitnessescriptcorrector.TokenType;

public class FitnesseTimeMachine {
    private TokenList tokenList;
    private boolean modified = false;
    private boolean baseSchoolyearSet = false;
    private int lastPositionToComment = 0;
    private static String COMMENTMARKER = "fitnesse-time-machine changed";
    private static String BASESCHOOLYEARCOMMENTMARKER = "basisschuljahr";
    private static String TIMEMACHINEFLAGS = "Zeitmaschine:";
    private int destinationSchoolyear = 2009;
    private boolean timeMachineOn = true;
    private int oldBaseSchoolyear = Settings.getSchuljahrFuerDateienOhneMarker();
    private int pos = 0;

    public FitnesseTimeMachine(TokenList tokenList, int destinationSchoolyear) {
        this.tokenList = tokenList;
        this.destinationSchoolyear = destinationSchoolyear;
    }

    public boolean run() {
        Token t;
        boolean lastLineWasPipeLine = this.thisLineIsPipeline();
        boolean headerOver = false;
        block12: while ((t = this.peek(0)) != null && this.destinationSchoolyear != this.oldBaseSchoolyear) {
            switch (t.getTokenType()) {
                case Einsatz: {
                    if (this.timeMachineOn) {
                        this.shiftEinsatz(t);
                        this.modified = true;
                    }
                    this.getToken();
                    break;
                }
                case Date: {
                    if (headerOver && this.timeMachineOn) {
                        this.shiftDate(t);
                        this.modified = true;
                    }
                    this.getToken();
                    break;
                }
                case Year: {
                    if (headerOver && this.timeMachineOn) {
                        this.shiftYear(t);
                        this.modified = true;
                    }
                    this.getToken();
                    break;
                }
                case Schoolyear: {
                    if (headerOver && this.timeMachineOn) {
                        this.shiftSchoolyear(t);
                        this.modified = true;
                    }
                    this.getToken();
                    break;
                }
                case PKZ: {
                    if (this.timeMachineOn) {
                        this.shiftPKZ(t);
                        this.modified = true;
                    }
                    this.getToken();
                    break;
                }
                case NewLine: {
                    if (!lastLineWasPipeLine) {
                        this.lastPositionToComment = this.pos + 1;
                    }
                    this.getToken();
                    lastLineWasPipeLine = this.thisLineIsPipeline();
                    break;
                }
                case Hash: {
                    String timemachineFlags;
                    boolean removeLine = false;
                    if (this.comesBaseSchoolyearCommentmarker()) {
                        String s = this.peek(1).getText().substring(BASESCHOOLYEARCOMMENTMARKER.length());
                        while (s.length() > 0 && !this.isDigit(s.charAt(0))) {
                            s = s.substring(1);
                        }
                        if (s.length() >= 4) {
                            int sj = 0;
                            try {
                                sj = Integer.parseInt(s.substring(0, 4));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (sj > 2000 && sj < 3000) {
                                this.oldBaseSchoolyear = sj;
                                this.peek(1).setText(String.valueOf(BASESCHOOLYEARCOMMENTMARKER) + ": " + this.destinationSchoolyear);
                                this.baseSchoolyearSet = true;
                            }
                        }
                    }
                    if ((timemachineFlags = this.comesTimemachineFlagsMarker()) != null) {
                        if ((timemachineFlags = this.stripWhitespace(timemachineFlags)).compareToIgnoreCase("ein") == 0 || timemachineFlags.compareToIgnoreCase("an") == 0) {
                            this.timeMachineOn = true;
                        }
                        if (timemachineFlags.compareToIgnoreCase("aus") == 0) {
                            this.timeMachineOn = false;
                        }
                    }
                    if (this.comesCommentmarker()) {
                        removeLine = true;
                    }
                    if (removeLine) {
                        while (this.peek(0) != null && this.peek(0).getTokenType() != TokenType.NewLine) {
                            this.tokenList.remove(this.pos);
                        }
                        if (this.peek(0) != null) {
                            this.tokenList.remove(this.pos);
                        }
                        lastLineWasPipeLine = this.thisLineIsPipeline();
                        this.lastPositionToComment = this.pos;
                        this.modified = true;
                        break;
                    }
                    this.getToken();
                    break;
                }
                case Text: {
                    this.getToken();
                    if (!t.getText().contains("de.isb.svp.fixture.SvpAdapterFixture") && !t.getText().contains("!define")) continue block12;
                    headerOver = true;
                    break;
                }
                default: {
                    this.getToken();
                }
            }
        }
        if (this.modified && !this.baseSchoolyearSet) {
            this.tokenList.add(0, new Token(TokenType.Hash, "#"));
            this.tokenList.add(1, new Token(TokenType.Text, String.valueOf(BASESCHOOLYEARCOMMENTMARKER) + ": " + this.destinationSchoolyear));
            this.tokenList.add(2, new Token(TokenType.NewLine, "\r\n"));
        }
        return this.modified;
    }

    private String stripWhitespace(String s) {
        while (s.startsWith(" ")) {
            s = s.substring(1);
        }
        while (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public int getOldBaseSchoolyear() {
        return this.oldBaseSchoolyear;
    }

    private boolean isDigit(char c) {
        return c >= '1' && c <= '9' || c == '0';
    }

    private boolean comesCommentmarker() {
        String s = "";
        if (this.peek(1) != null) {
            s = this.peek(1).getText();
        }
        return (this.isNewLine(this.lastToken()) || this.pos == 0) && s.length() >= COMMENTMARKER.length() && s.substring(0, COMMENTMARKER.length()).compareToIgnoreCase(COMMENTMARKER) == 0;
    }

    private String comesTimemachineFlagsMarker() {
        String s = "";
        if (this.peek(1) != null) {
            s = this.peek(1).getText();
        }
        if ((this.isNewLine(this.lastToken()) || this.pos == 0) && s.length() >= TIMEMACHINEFLAGS.length() && s.substring(0, TIMEMACHINEFLAGS.length()).compareToIgnoreCase(TIMEMACHINEFLAGS) == 0) {
            return s.substring(TIMEMACHINEFLAGS.length());
        }
        return null;
    }

    private boolean comesBaseSchoolyearCommentmarker() {
        String s = "";
        if (this.peek(1) != null) {
            s = this.peek(1).getText();
        }
        return (this.isNewLine(this.lastToken()) || this.pos == 0) && s.length() >= BASESCHOOLYEARCOMMENTMARKER.length() && s.substring(0, BASESCHOOLYEARCOMMENTMARKER.length()).compareToIgnoreCase(BASESCHOOLYEARCOMMENTMARKER) == 0;
    }

    private boolean thisLineIsPipeline() {
        boolean ret = false;
        Token p0 = this.peek(0);
        Token p1 = this.peek(1);
        if (p0 != null && p0.getTokenType() == TokenType.Pipe) {
            ret = true;
        }
        if (p0 != null && p1 != null && p0.getTokenType() == TokenType.Exclamationmark && p1.getTokenType() == TokenType.Pipe) {
            ret = true;
        }
        return ret;
    }

    private void insertComment(String text) {
        Token t1 = new Token(TokenType.Hash, "#");
        this.tokenList.add(this.lastPositionToComment, t1);
        if (this.lastPositionToComment <= this.pos) {
            ++this.pos;
        }
        Token t2 = new Token(TokenType.Text, String.valueOf(COMMENTMARKER) + " " + text);
        this.tokenList.add(this.lastPositionToComment + 1, t2);
        if (this.lastPositionToComment + 1 <= this.pos) {
            ++this.pos;
        }
        Token t3 = new Token(TokenType.NewLine, "\r\n");
        this.tokenList.add(this.lastPositionToComment + 2, t3);
        if (this.lastPositionToComment + 2 <= this.pos) {
            ++this.pos;
        }
    }

    private void shiftPKZ(Token t) {
        String oldPKZ = t.getText();
        String newPKZ = ChangeDatesWorker.changePKZ(this.destinationSchoolyear - this.oldBaseSchoolyear, oldPKZ);
        t.setText(newPKZ);
        this.insertComment("PKZ " + oldPKZ + " to " + newPKZ + ".");
    }

    private void shiftSchoolyear(Token t) {
        String oldSchoolyear = t.getText();
        int year = Integer.parseInt(oldSchoolyear.substring(0, 4));
        int newYear = year + this.destinationSchoolyear - this.oldBaseSchoolyear;
        String newSchoolyear = newYear + "/" + (newYear + 1) % 100;
        t.setText(newSchoolyear);
        this.insertComment("Schuljahr " + oldSchoolyear + " to " + newSchoolyear + ".");
    }

    private void shiftYear(Token t) {
        String oldYear = t.getText();
        String newYear = "" + (this.destinationSchoolyear - this.oldBaseSchoolyear + Integer.parseInt(oldYear));
        t.setText(newYear);
        this.insertComment("year " + oldYear + " to " + newYear + ".");
    }

    private void shiftEinsatz(Token t) {
        String oldEinsatzString = t.getText();
        String s2 = oldEinsatzString.substring(0, 2);
        int i1 = Integer.parseInt(s2);
        int newi1 = (i1 + this.destinationSchoolyear - this.oldBaseSchoolyear) % 100;
        int newi2 = (newi1 + 1) % 100;
        String newEinsatzString = String.valueOf(this.intToSchoolyear2Digits(newi1)) + "/" + this.intToSchoolyear2Digits(newi2);
        t.setText(newEinsatzString);
        this.insertComment("Einsatz \"" + oldEinsatzString + "\" to \"" + newEinsatzString + "\".");
    }

    private String intToSchoolyear2Digits(int i) {
        if (i < 0) {
            i += 100;
        }
        String s = "" + i;
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private void shiftDate(Token t) {
        Calendar cal = t.getCalendar();
        String oldDate = t.getText();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int newYear = year + this.destinationSchoolyear - this.oldBaseSchoolyear;
        if (month == 1 && day == 29) {
            day = 28;
        }
        if (month == 1 && day == 28 && newYear % 4 == 0) {
            day = 29;
        }
        String dayString = (day < 10 ? "0" : "") + day;
        String monthString = (month + 1 < 10 ? "0" : "") + (month + 1);
        t.setText(String.valueOf(dayString) + "." + monthString + "." + newYear);
        cal.set(newYear, month, day);
        this.insertComment("date " + oldDate + " to " + t.getText() + ".");
    }

    private boolean isNewLine(Token t) {
        return t != null && t.getTokenType() == TokenType.NewLine;
    }

    private boolean isExclamationmark(Token t) {
        return t != null && t.getTokenType() == TokenType.Exclamationmark;
    }

    private boolean isPipe(Token t) {
        return t != null && t.getTokenType() == TokenType.Pipe;
    }

    private Token peek(int n) {
        if (this.pos + n < this.tokenList.size()) {
            return (Token)this.tokenList.get(this.pos + n);
        }
        return null;
    }

    private Token getToken() {
        if (this.pos < this.tokenList.size()) {
            ++this.pos;
            return (Token)this.tokenList.get(this.pos - 1);
        }
        return null;
    }

    private Token lastToken() {
        if (this.pos > 0) {
            return (Token)this.tokenList.get(this.pos - 1);
        }
        return null;
    }
}

