/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DatabaseAccess;
import database.DerbyDatabaseAccess;
import database.PostgresDatabaseAccess;
import java.awt.Color;
import logging.Log;
import logging.LogLevel;
import org.w3c.dom.Element;
import tools.xml.XMLReader;
import tools.xml.XMLWriter;

public class DatabaseLoginInfo {
    private String type = "";
    private String path = "";
    private String ip = "";
    private String port = "";
    private String username = "";
    private String password = "";
    private String name = "";

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void readFromXML(Element element) {
        this.type = XMLReader.attributeNotNull(element, "type");
        this.username = XMLReader.attributeNotNull(element, "username");
        this.password = XMLReader.attributeNotNull(element, "password");
        this.name = XMLReader.attributeNotNull(element, "name");
        Log.outl(" ", LogLevel.info);
        Log.outlColor("Datenbankeinstellungen gefunden: ", LogLevel.info, Color.blue);
        Log.out("Typ: " + this.type + ", Benutzername: " + this.username + ", Datenbankkennung: " + this.name, LogLevel.info);
        if (this.type.compareToIgnoreCase("derby") == 0) {
            this.path = XMLReader.attributeNotNull(element, "path");
            Log.outl(", path: " + this.path, LogLevel.info);
        } else if (this.type.compareToIgnoreCase("postgres") == 0) {
            this.ip = XMLReader.attributeNotNull(element, "ip");
            this.port = XMLReader.attributeNotNull(element, "port");
            Log.outl(", ip: " + this.ip + ", port: " + this.port, LogLevel.info);
        } else {
            Log.outl("Datenbanktyp " + this.type + " unbekannt.", LogLevel.error);
        }
    }

    private static String getCachePath(String path) {
        while (path.charAt(path.length() - 1) != '/' && path.charAt(path.length() - 1) != '\\' && path.length() > 0) {
            path = path.substring(0, path.length() - 1);
        }
        path = String.valueOf(path) + "cache";
        return path;
    }

    public void setAsActiveDatabase() {
        if (this.type.compareToIgnoreCase("derby") == 0) {
            DatabaseAccess.setActiveASVDatabase(new DerbyDatabaseAccess(this.name, this.username, this.password, this.path));
            DatabaseAccess.setActiveCacheDatabase(new DerbyDatabaseAccess(this.name, this.username, this.password, DatabaseLoginInfo.getCachePath(this.path)));
        } else if (this.type.compareToIgnoreCase("postgres") == 0) {
            DatabaseAccess.setActiveASVDatabase(new PostgresDatabaseAccess(this.name, this.username, this.password, this.ip, this.port, "asv"));
            DatabaseAccess.setActiveCacheDatabase(new PostgresDatabaseAccess(this.name, this.username, this.password, this.ip, this.port, "cache"));
        } else {
            Log.outl("Datenbanktyp " + this.type + " unbekannt.", LogLevel.error);
        }
    }

    public String getName() {
        return this.name;
    }

    public void writeToXML(Element settings) {
        Element element = XMLWriter.addElement("database", settings);
        XMLWriter.addAttribute(element, "name", this.name);
        XMLWriter.addAttribute(element, "type", this.type);
        XMLWriter.addAttribute(element, "username", this.username);
        XMLWriter.addAttribute(element, "password", this.password);
        if (this.type.compareTo("postgres") == 0) {
            XMLWriter.addAttribute(element, "ip", this.ip);
            XMLWriter.addAttribute(element, "port", this.port);
        }
        if (this.type.compareTo("derby") == 0) {
            XMLWriter.addAttribute(element, "path", this.path);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }
}

