/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import logging.Log;
import logging.LogLevel;

public class EditSettingsDialog
extends JDialog
implements ActionListener {
    private JTextArea textArea;
    private JButton buttonSave;
    private JButton buttonCancel;

    public EditSettingsDialog(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("data/iconASV16.png"));
        this.setSize(850, 650);
        this.setDefaultCloseOperation(2);
        this.setTitle("ASV Hilfecompiler, Einstellungen bearbeiten");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.textArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.textArea);
        mainPanel.add((Component)sp, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.buttonSave = new JButton("Einstellungen Speichern");
        this.buttonSave.addActionListener(this);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPanel.add(this.buttonSave);
        this.buttonCancel = new JButton("Abbrechen");
        this.buttonCancel.addActionListener(this);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(this.buttonCancel);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)buttonPanel, "North");
        try {
            this.readFile(new File("jobs.xml"));
            this.textArea.setCaretPosition(0);
        }
        catch (Exception ex) {
            Log.outl("Kann einstellungen.xml nicht lesen: " + ex.toString(), LogLevel.error);
            this.setVisible(false);
        }
    }

    public void readFile(File file) throws Exception {
        String text = "";
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                text = String.valueOf(text) + (char)c;
            }
        }
        this.textArea.setText(text);
    }

    public void writeFile(File file) throws Exception {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            String text = this.textArea.getText();
            int i = 0;
            while (i < text.length()) {
                ((Writer)writer).write(text.charAt(i));
                ++i;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSave) {
            try {
                this.writeFile(new File("jobs.xml"));
            }
            catch (Exception ex) {
                Log.outl("Kann einstellungen.xml nicht lesen: " + ex.toString(), LogLevel.error);
                this.setVisible(false);
            }
        }
        e.getSource();
        this.setVisible(false);
    }
}

