/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.DatabaseSettings;
import data.Settings;
import gui.ColorPane;
import gui.MainFrame;
import java.awt.Color;
import javax.swing.SwingUtilities;
import logging.Log;
import logging.LogLevel;
import logging.LogOutput;
import workerthreads.ExecuteScriptsWorker;
import workerthreads.changedates.ChangeDatesWorker;
import workerthreads.fitnessescriptcorrector.FitnesseScriptCorrector;
import workerthreads.getmetadata.GetMetadataWorker;

public class MainFrameController
implements LogOutput {
    private MainFrame mainFrame = MainFrame.getInstance();

    public MainFrameController() {
        this.mainFrame.setController(this);
        this.mainFrame.init();
        Log.setLogOutput(this);
        this.readSettings();
    }

    public void showMainFrame() {
        this.mainFrame.setVisible(true);
    }

    public void readSettings() {
        this.mainFrame.getTextArea().setText("");
        this.mainFrame.setButtonsEnabled(false);
        Settings.readSettings();
        DatabaseSettings.readSettings();
        this.mainFrame.setButtonsEnabled(true);
    }

    @Override
    public void out(String s) {
        ColorPane ta = this.mainFrame.getTextArea();
        ta.append(Color.black, s);
    }

    @Override
    public void outl(String s) {
        this.out(String.valueOf(s) + "\n");
    }

    @Override
    public void outColor(String s, Color c) {
        ColorPane ta = this.mainFrame.getTextArea();
        ta.append(c, s);
    }

    @Override
    public void outlColor(String s, Color c) {
        this.outColor(String.valueOf(s) + "\n", c);
    }

    public void clearTextArea() {
        this.mainFrame.getTextArea().setText("");
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setButtonsEnabled(boolean enabled) {
        Runnable doSetEnabled = enabled ? new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.mainFrame.setButtonsEnabled(true);
            }
        } : new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.mainFrame.setButtonsEnabled(false);
            }
        };
        SwingUtilities.invokeLater(doSetEnabled);
        this.mainFrame.setButtonsEnabled(enabled);
    }

    public void setWaitCursor(boolean isWait) {
        this.mainFrame.setWaitCursor(isWait);
    }

    @Override
    public void setProgressBarMaximum(int n) {
        this.mainFrame.setProgressBarMaximum(n);
    }

    @Override
    public void setProgressBarValue(int value, String s) {
        this.mainFrame.setProgressBarPosition(value, s);
    }

    public void enableProgressbar(boolean enabled) {
        this.mainFrame.enableProgressBar(enabled);
    }

    public void changeDates() {
        this.clearTextArea();
        Log.outlColor("Aendere Datumsangaben:", LogLevel.useful, Color.blue);
        ChangeDatesWorker worker = new ChangeDatesWorker(this, 0);
        worker.execute();
    }

    public void startScript() {
        this.clearTextArea();
        Log.outlColor("Aendere Datumsangaben:", LogLevel.useful, Color.blue);
        ExecuteScriptsWorker worker = new ExecuteScriptsWorker(this);
        worker.execute();
    }

    public void outputDateFields() {
        this.clearTextArea();
        Log.outlColor("Test: Get Metadata from database", LogLevel.useful, Color.blue);
        GetMetadataWorker worker = new GetMetadataWorker(this);
        worker.execute();
    }

    public void correctFitnesseScripts() {
        this.clearTextArea();
        Log.outlColor("\u00c4ndere Fitnessescripts:", LogLevel.useful, Color.blue);
        Log.outl("Transferiere die Skripts zum Basisschuljahr " + Settings.intToSchuljahrString(Settings.getFitnesseDestinationSchoolyear()) + ".", LogLevel.useful);
        FitnesseScriptCorrector worker = new FitnesseScriptCorrector(this);
        worker.execute();
    }
}

