/*
 * Decompiled with CFR 0.152.
 */
package workerthreads.fitnessescriptcorrector;

import data.Settings;
import gui.MainFrameController;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingWorker;
import logging.Log;
import logging.LogLevel;
import tools.file.FileTool;
import tools.file.RecursiveFileListing;
import workerthreads.fitnessescriptcorrector.FitnesseTimeMachine;
import workerthreads.fitnessescriptcorrector.Lexer;
import workerthreads.fitnessescriptcorrector.TokenList;

public class FitnesseScriptCorrector
extends SwingWorker<Void, String> {
    private MainFrameController controller;

    public FitnesseScriptCorrector(MainFrameController controller) {
        this.controller = controller;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.controller.setButtonsEnabled(false);
        this.controller.setWaitCursor(true);
        this.controller.enableProgressbar(true);
        this.controller.setProgressBarMaximum(-1);
        List<File> fileList = RecursiveFileListing.getRecursiveFileList(Settings.getFitnesseRoot(), "txt", false, ".svn");
        Log.outl(fileList.size() + " Fitnesse-Dateien gefunden.\n", LogLevel.useful);
        Log.setProgressBarMaximum(fileList.size());
        this.correctFiles(fileList);
        this.controller.setWaitCursor(false);
        this.controller.setButtonsEnabled(true);
        this.controller.enableProgressbar(false);
        return null;
    }

    private void correctFiles(List<File> files) {
        boolean debug = false;
        int i = 0;
        boolean firstFileInProtocoll = true;
        int countModified = 0;
        File protocollFile = null;
        if (Settings.getFitnesseProtocoll() != null) {
            protocollFile = new File(Settings.getFitnesseProtocoll());
        }
        for (File file : files) {
            Log.setProgressBarValue(i, file.getAbsolutePath());
            try {
                FitnesseTimeMachine tm;
                boolean modified;
                String textAlt = FileTool.readTextFile(file, "UTF-8");
                Lexer l = new Lexer();
                TokenList tokenList = l.lex(textAlt);
                if (debug) {
                    this.testOutput(file, textAlt, tokenList);
                }
                if (modified = (tm = new FitnesseTimeMachine(tokenList, Settings.getFitnesseDestinationSchoolyear())).run()) {
                    ++countModified;
                    Log.outlColor(String.valueOf(file.getAbsolutePath()) + " ge\u00e4ndert von " + this.intToSchuljahrString(tm.getOldBaseSchoolyear()) + " nach " + this.intToSchuljahrString(Settings.getFitnesseDestinationSchoolyear()) + ".", LogLevel.useful, new Color(0, 100, 0));
                } else {
                    Log.outlColor(String.valueOf(file.getAbsolutePath()) + " nicht ge\u00e4ndert.", LogLevel.useful, Color.blue);
                }
                if (debug) {
                    Log.outlColor("\n\nNeue Version:", LogLevel.useful, new Color(0, 0, 100));
                    Log.outl(tokenList.toString(), LogLevel.useful);
                }
                if (modified) {
                    String textNeu = tokenList.toString();
                    if (Settings.getFitnesseProtocoll() != null) {
                        String s = "File " + file.getAbsolutePath() + ": \n";
                        s = String.valueOf(s) + "\r\n========== Alt: ==========\r\n";
                        s = String.valueOf(s) + textAlt;
                        s = String.valueOf(s) + "\r\n========== Neu: ==========\r\n";
                        s = String.valueOf(s) + textNeu;
                        s = String.valueOf(s) + "\r\n========== Tokens: ============\r\n";
                        s = String.valueOf(s) + tokenList.traceOutput();
                        FileTool.writeTextFile(protocollFile, "UTF-8", s, !firstFileInProtocoll);
                        firstFileInProtocoll = false;
                        if (Settings.isFitnesseWriteChanges()) {
                            FileTool.writeTextFile(file, "UTF-8", textNeu, false);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Log.outlColor("\n\n" + countModified + " files altered. ", LogLevel.useful, Color.blue);
    }

    private String intToSchuljahrString(int sj) {
        int sjp1 = (sj + 1) % 100;
        return String.valueOf(sj) + "/" + (sjp1 < 10 ? "0" : "") + sjp1;
    }

    private void testOutput(File file, String text, TokenList tokenList) {
        Log.outlColor("\n" + file.getAbsolutePath(), LogLevel.useful, Color.blue);
        Log.outlColor(text, LogLevel.useful, Color.black);
        Log.outlColor(tokenList.traceOutput(), LogLevel.useful, new Color(0, 100, 0));
    }
}

