/*
 * Decompiled with CFR 0.152.
 */
package workerthreads.fitnessescriptcorrector;

import java.util.Calendar;
import workerthreads.changedates.ChangeDatesWorker;
import workerthreads.fitnessescriptcorrector.Token;
import workerthreads.fitnessescriptcorrector.TokenList;
import workerthreads.fitnessescriptcorrector.TokenType;

public class Lexer {
    private TokenList tokenList;
    private String text;
    private int textPos;
    private State state;
    private StringBuilder lastRead;

    public TokenList lex(String text) {
        this.tokenList = new TokenList();
        this.text = text;
        this.textPos = 0;
        this.state = State.BeginOfLine;
        this.lastRead = new StringBuilder();
        this.startLexing();
        this.markTokensBetweenPipes();
        return this.tokenList;
    }

    private void markTokensBetweenPipes() {
        boolean betweenPipes = false;
        int lastPipe = 0;
        int j = 0;
        while (j < this.tokenList.size()) {
            Token t = (Token)this.tokenList.get(j);
            switch (t.getTokenType()) {
                case Pipe: {
                    if (betweenPipes) {
                        int i = lastPipe + 1;
                        while (i < j) {
                            ((Token)this.tokenList.get(i)).setBetweenPipes(true);
                            ++i;
                        }
                    } else {
                        betweenPipes = true;
                    }
                    lastPipe = j;
                    break;
                }
                case Date: 
                case Year: 
                case Text: {
                    break;
                }
                default: {
                    betweenPipes = false;
                }
            }
            ++j;
        }
    }

    private void startLexing() {
        block6: while (this.peek() != '\u0000') {
            switch (this.state) {
                case BeginOfLine: {
                    this.lexBeginOfLine();
                    break;
                }
                case ReadingBetweenPipes: {
                    this.consumeText("|", "\n", "\r");
                    if (this.peek() == '|') {
                        this.getChar();
                        this.push(TokenType.Pipe);
                        this.state = State.ReadingBetweenPipes;
                        break;
                    }
                    if (this.peek() != '\n' && this.peek() != '\r') continue block6;
                    this.readNewLine();
                    this.state = State.BeginOfLine;
                    break;
                }
                case ReadingExclamationmarkComment: {
                    this.consumeText("-!", "", "");
                    if (!this.comes("-!")) break;
                    this.consume("-!");
                    this.push(TokenType.ExclamationmarkCommentEnd);
                    this.readNewLine();
                    this.state = State.BeginOfLine;
                    break;
                }
                case ReadingStatement: 
                case ReadingHashComment: 
                case ReadingText: {
                    this.consumeText("\n", "\r", "");
                    if (this.peek() != '\n' && this.peek() != '\r') continue block6;
                    this.readNewLine();
                    this.state = State.BeginOfLine;
                    break;
                }
            }
        }
    }

    private void consumeText(String end1, String end2, String end3) {
        boolean lastCharWasDigit = false;
        while (!(this.peek() == '\u0000' || this.comes(end1) || this.comes(end2) || this.comes(end3))) {
            boolean yearOrDateOrSchoolyearOrPKZOrEinsatz = false;
            boolean comesDigit = this.isDigit(this.peek());
            if (!yearOrDateOrSchoolyearOrPKZOrEinsatz && !lastCharWasDigit && comesDigit) {
                Calendar calendar = this.comesDate();
                if (calendar != null) {
                    yearOrDateOrSchoolyearOrPKZOrEinsatz = true;
                    Token token = new Token(TokenType.Date, this.flushLastRead());
                    token.setCalendar(calendar);
                    this.tokenList.add(token);
                } else if (this.comesSchoolyear()) {
                    yearOrDateOrSchoolyearOrPKZOrEinsatz = true;
                    this.consume("xxxx/xx");
                    this.push(TokenType.Schoolyear);
                } else if (this.comesPKZ()) {
                    yearOrDateOrSchoolyearOrPKZOrEinsatz = true;
                    this.consume("xxxxxxxxx");
                    this.push(TokenType.PKZ);
                } else if (this.comesYear()) {
                    yearOrDateOrSchoolyearOrPKZOrEinsatz = true;
                    this.consume("xxxx");
                    this.push(TokenType.Year);
                } else if (this.comesEinsatz()) {
                    yearOrDateOrSchoolyearOrPKZOrEinsatz = true;
                    this.consume("xx/xx");
                    this.push(TokenType.Einsatz);
                }
            }
            lastCharWasDigit = comesDigit;
            if (yearOrDateOrSchoolyearOrPKZOrEinsatz) continue;
            this.getChar();
        }
        this.storeLastReadInTextToken();
    }

    private boolean comesEinsatz() {
        char c;
        String s;
        if (this.text.length() - this.textPos >= "10/11 ".length() && this.startsWithFormat(s = this.text.substring(this.textPos, this.textPos + 6), "99/99") && ((c = s.charAt(5)) == ' ' || c == ')' || c == '|')) {
            int i1 = Integer.parseInt(s.substring(0, 2));
            int i2 = Integer.parseInt(s.substring(3, 5));
            if ((i2 - i1 + 100) % 100 == 1) {
                return true;
            }
        }
        return false;
    }

    private boolean comesPKZ() {
        String pkz;
        int pruefziffer;
        boolean ret = this.comesFormat("999999999");
        if (ret && this.text.length() - this.textPos > 9 && this.isDigit(this.text.charAt(this.textPos + 9))) {
            ret = false;
        }
        if (ret && (pruefziffer = ChangeDatesWorker.getPruefziffer((pkz = this.text.substring(this.textPos, this.textPos + 9)).substring(0, 8))) != Integer.parseInt(pkz.substring(8, 9))) {
            ret = false;
            this.consume(pkz);
        }
        return ret;
    }

    private boolean comesSchoolyear() {
        boolean ret = this.comesFormat("9999/99 ");
        if (ret && this.text.length() - this.textPos > 7 && this.isDigit(this.text.charAt(this.textPos + 7))) {
            ret = false;
        }
        if (ret) {
            int suffix;
            int year = Integer.parseInt(this.text.substring(this.textPos, this.textPos + 4));
            if (year < 1900 || year > 2200) {
                ret = false;
            }
            if ((suffix = Integer.parseInt(this.text.substring(this.textPos + 5, this.textPos + 7))) != (year + 1) % 100) {
                ret = false;
            }
            if (!ret) {
                int i = 0;
                while (i < 7) {
                    this.getChar();
                    ++i;
                }
            }
        }
        return ret;
    }

    private int numberOfDigitsToCome(int startIndex, int maxDigits) {
        int i = startIndex;
        int number = 0;
        while (number < maxDigits && i < this.text.length()) {
            if (!this.isDigit(this.text.charAt(i))) break;
            ++number;
            ++i;
        }
        return number;
    }

    private Calendar comesDate() {
        int numberOfDigits2;
        int numberOfDigits1 = this.numberOfDigitsToCome(this.textPos, 2);
        Calendar ret = null;
        if (numberOfDigits1 >= 1 && numberOfDigits1 <= 2 && this.text.charAt(this.textPos + numberOfDigits1) == '.' && (numberOfDigits2 = this.numberOfDigitsToCome(this.textPos + numberOfDigits1 + 1, 2)) >= 1 && numberOfDigits2 <= 2 && this.text.charAt(this.textPos + numberOfDigits1 + numberOfDigits2 + 1) == '.' && this.numberOfDigitsToCome(this.textPos + numberOfDigits1 + numberOfDigits2 + 2, 5) == 4) {
            int i;
            int length = numberOfDigits1 + numberOfDigits2 + 6;
            int date = Integer.parseInt(this.text.substring(this.textPos, this.textPos + numberOfDigits1));
            int month = Integer.parseInt(this.text.substring(this.textPos + numberOfDigits1 + 1, this.textPos + numberOfDigits1 + 1 + numberOfDigits2));
            int yearStart = this.textPos + numberOfDigits1 + numberOfDigits2 + 2;
            int year = Integer.parseInt(this.text.substring(yearStart, yearStart + 4));
            ret = Calendar.getInstance();
            ret.clear();
            ret.set(year, month - 1, date);
            if (ret.get(5) != date || ret.get(2) != month - 1 || ret.get(1) != year) {
                ret = null;
                i = 0;
                while (i < length) {
                    this.getChar();
                    ++i;
                }
            }
            if (ret != null) {
                this.storeLastReadInTextToken();
                i = 0;
                while (i < length) {
                    this.getChar();
                    ++i;
                }
            }
        }
        return ret;
    }

    private void storeLastReadInTextToken() {
        if (this.lastRead.length() > 0) {
            this.push(TokenType.Text);
        }
    }

    private boolean comesYear() {
        int year;
        boolean ret = this.comesFormat("9999 ");
        if (ret && this.text.length() - this.textPos > 4 && this.isDigit(this.text.charAt(this.textPos + 4))) {
            ret = false;
        }
        if (ret && ((year = Integer.parseInt(this.text.substring(this.textPos, this.textPos + 4))) < 1970 || year > 2020)) {
            ret = false;
        }
        return ret;
    }

    private boolean comesFormat(String format) {
        boolean ret = false;
        if (this.text.length() - this.textPos >= format.length()) {
            ret = true;
            int j = 0;
            while (j < format.length()) {
                char formatChar = format.charAt(j);
                char textChar = this.text.charAt(this.textPos + j);
                if (!(formatChar == '9' && this.isDigit(textChar) || formatChar == textChar)) {
                    ret = false;
                    break;
                }
                ++j;
            }
        }
        return ret;
    }

    private boolean startsWithFormat(String s, String formatString) {
        boolean ret = false;
        if (s.length() >= formatString.length()) {
            ret = true;
            int j = 0;
            while (j < formatString.length()) {
                char formatChar = formatString.charAt(j);
                char textChar = s.charAt(j);
                if (!(formatChar == '9' && this.isDigit(textChar) || formatChar == textChar)) {
                    ret = false;
                    break;
                }
                ++j;
            }
        }
        return ret;
    }

    private boolean isDigit(char c) {
        return c >= '1' && c <= '9' || c == '0';
    }

    private void lexBeginOfLine() {
        this.readSpace();
        switch (this.peek()) {
            case '|': {
                this.getChar();
                this.push(TokenType.Pipe);
                this.state = State.ReadingBetweenPipes;
                break;
            }
            case '!': {
                this.lexExclamationMark();
                break;
            }
            case '#': {
                this.getChar();
                this.push(TokenType.Hash);
                this.state = State.ReadingHashComment;
                break;
            }
            default: {
                this.state = State.ReadingText;
            }
        }
    }

    private void lexExclamationMark() {
        if (this.comes("!-")) {
            this.consume("!-");
            this.push(TokenType.ExclamationmarkCommentStart);
            this.state = State.ReadingExclamationmarkComment;
        } else if (this.comes("!|")) {
            this.getChar();
            this.push(TokenType.Exclamationmark);
            this.getChar();
            this.push(TokenType.Pipe);
            this.state = State.ReadingBetweenPipes;
        } else if (this.comes("!define tab (Einsatz")) {
            this.consumeText("\n", "\r", "@@@@@@@@@");
            this.state = State.BeginOfLine;
        } else {
            this.consume("!");
            this.push(TokenType.Exclamationmark);
            this.state = State.ReadingStatement;
        }
    }

    private void consume(String s) {
        this.storeLastReadInTextToken();
        int i = 0;
        while (i < s.length()) {
            this.getChar();
            ++i;
        }
    }

    private void push(TokenType t) {
        this.push(t, this.flushLastRead());
    }

    private void push(TokenType t, String s) {
        this.tokenList.add(new Token(t, s));
    }

    private void readSpace() {
        while (true) {
            if (this.isSpace(this.peek())) {
                this.getChar();
                continue;
            }
            if (this.lastRead.length() > 0) {
                this.push(TokenType.Space);
            }
            this.readNewLine();
            if (!this.isSpace(this.peek())) break;
        }
    }

    private void readNewLine() {
        while (this.peek() == '\n' || this.peek() == '\r') {
            char c = this.getChar();
            if ((c != '\r' || this.peek() == '\n') && c != '\n') continue;
            this.push(TokenType.NewLine);
        }
        if (this.lastRead.length() > 0) {
            this.push(TokenType.NewLine);
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\ufeff';
    }

    private char peek() {
        if (this.textPos < this.text.length()) {
            return this.text.charAt(this.textPos);
        }
        return '\u0000';
    }

    private char getChar() {
        char c = this.peek();
        if (this.textPos < this.text.length()) {
            ++this.textPos;
        }
        this.lastRead.append(c);
        return c;
    }

    private boolean comes(String s) {
        boolean erg = false;
        if (this.text.length() - this.textPos >= s.length() && s.length() > 0) {
            erg = true;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) != this.text.charAt(this.textPos + i)) {
                    erg = false;
                    break;
                }
                ++i;
            }
        }
        return erg;
    }

    private String flushLastRead() {
        String erg = this.lastRead.toString();
        this.lastRead = new StringBuilder();
        return erg;
    }

    static enum State {
        BeginOfLine,
        ReadingStatement,
        ReadingBetweenPipes,
        ReadingHashComment,
        ReadingExclamationmarkComment,
        ReadingText;

    }
}

