import { gameHeight, gameWidth } from "../mainscene/Globals.js";
/**
 * Simple class to demonstrate a gameover scene.
 */
export class GameOverScene extends Phaser.Scene {
    constructor() {
        super({
            key: "GameOverScene"
        });
    }
    init(data) {
        this.gameOverData = data;
    }
    preload() {
        this.load.atlas('spritesheet2', 'assets/graphics/spritesheet.png', 'assets/graphics/spritesheet.json');
    }
    create() {
        let text1 = this.add.text(gameWidth / 2, gameHeight * 0.2, "Game Over", {
            fontFamily: "sans-serif",
            fontSize: "72px",
            color: "#aaa",
            stroke: "#666",
            strokeThickness: 5,
            align: 'center'
        });
        text1.setOrigin(0.5, 0.5);
        let text2 = this.add.text(gameWidth / 2, gameHeight * 0.4, "You earned " + this.gameOverData.points + " Points and reached level " + this.gameOverData.level + "!", {
            fontFamily: "sans-serif",
            fontSize: "36px",
            color: "#3f3",
            stroke: "#666",
            strokeThickness: 2,
            align: 'center'
        });
        text2.setOrigin(0.5, 0.5);
        let text3 = this.add.text(gameWidth / 2, gameHeight * 0.5, "Press Space to start again!", {
            fontFamily: "sans-serif",
            fontSize: "36px",
            color: "#3f3",
            stroke: "#666",
            strokeThickness: 2,
            align: 'center'
        });
        text3.setOrigin(0.5, 0.5);
        this.spacebar = this.input.keyboard.addKey(Phaser.Input.Keyboard.KeyCodes.SPACE);
    }
    update(time, delta) {
        if (this.spacebar.isDown) {
            this.scene.start("MainScene");
        }
    }
}
//# sourceMappingURL=GameOverScene.js.map