import { Level4 } from "../levels/Level4.js";
import { Level1 } from "../levels/Level1.js";
import { Level2 } from "../levels/Level2.js";
import { Level3 } from "../levels/Level3.js";
import { framesPerStep } from "./Globals.js";
export class MainScene extends Phaser.Scene {
    constructor() {
        super({
            key: "MainScene"
        });
        this.levels = [new Level1(this), new Level2(this), new Level3(this), new Level4(this)];
        /**
         * Each framesPerStep frames do a simulation-step:
         */
        this.frame = framesPerStep;
    }
    preload() {
        this.load.atlas('spritesheet', 'assets/graphics/spritesheet.png', 'assets/graphics/spritesheet.json');
    }
    /**
     * After create has finished phaser calls ScoreScene.create. This in turn
     * calls onScoreSceneReady (see below).
     */
    create() {
        this.scene.launch("ScoreScene");
    }
    /**
     * This is called from scoreScene.create
     */
    onScoreSceneReady() {
        this.currentLevelIndex = 1;
        this.nextLevel();
    }
    update(time, delta) {
        this.frame--;
        if (this.frame <= 0) {
            this.frame = framesPerStep;
            if (this.currentLevel != null) {
                this.currentLevel.simulateFallingBouldersAndGems();
            }
        }
    }
    getScoreScene() {
        return this.scene.get("ScoreScene");
    }
    getScoreBoard() {
        return this.getScoreScene().getScoreBoard();
    }
    /**
     * Starts next level
     */
    nextLevel() {
        if (this.currentLevel != null) {
            this.currentLevel.destroyTiles();
        }
        this.currentLevelIndex = (this.currentLevelIndex + 1) % this.levels.length;
        this.currentLevel = this.levels[this.currentLevelIndex];
        this.currentLevel.setupTiles();
    }
    /**
     * Stops current Scene and starts GameOver-Scene.
     */
    gameOver() {
        // Pass level and points to GameOver-Scene:
        let data = {
            level: this.currentLevelIndex + 1,
            points: this.getScoreBoard().score
        };
        this.scene.stop("ScoreScene");
        this.scene.start("GameOverScene", data);
    }
}
//# sourceMappingURL=MainScene.js.map