export class Spaceship extends Phaser.Physics.Arcade.Sprite {
    constructor(scene) {
        super(scene, 100, 300, 'spaceship');
        this.v = 30;
        scene.add.existing(this);
        scene.physics.add.existing(this);
        this.cursorKeys = scene.input.keyboard.createCursorKeys();
        let that = this;
        this.updateFunction = () => { that.update(); };
        scene.events.on('update', this.updateFunction);
    }
    update() {
        let vx = 0;
        let vy = 0;
        if (this.cursorKeys.right.isDown) {
            vx = 1;
        }
        if (this.cursorKeys.left.isDown) {
            vx = -1;
        }
        if (this.cursorKeys.up.isDown) {
            vy = -1;
        }
        if (this.cursorKeys.down.isDown) {
            vy = 1;
        }
        if (vx != 0 || vy != 0) {
            let d = Math.sqrt(vx * vx + vy * vy);
            this.setVelocity(vx / d * this.v, vy / d * this.v);
        }
        else {
            this.setVelocity(0, 0);
        }
    }
    destroy() {
        this.scene.events.off('update', this.updateFunction);
        super.destroy();
    }
}
//# sourceMappingURL=Spaceship.js.map