import { Level } from "./Level.js";
import { MainScene } from "./MainScene.js";
import { Tile } from "./Tile.js";


/**
 * The Door at the end of each level consists of two tiles. This class encapsulates them and their functions.
 */
export class Door {

    doorTop: Tile;
    doorBottom: Tile;

    isOpen: boolean = false;

    constructor(private mainScene: MainScene, public column: number, public row: number, public level: Level) {

        // door consists of two tiles
        this.doorTop = new Tile(mainScene, column, row, "doortop", level);
        this.doorBottom = new Tile(mainScene, column, row + 1, "doorbottom", level);

    }

    /**
     * Opens door tiles by setting appropriate pictures
     */
    open(){
        this.doorTop.setFrame("Boulder#12");
        this.doorBottom.setFrame("Boulder#13");
        this.isOpen = true;
    }

}