import { Tile } from "./Tile.js";
/**
 * The Door at the end of each level consists of two tiles. This class encapsulates them and their functions.
 */
export class Door {
    constructor(mainScene, column, row, level) {
        this.mainScene = mainScene;
        this.column = column;
        this.row = row;
        this.level = level;
        this.isOpen = false;
        // door consists of two tiles
        this.doorTop = new Tile(mainScene, column, row, "doortop", level);
        this.doorBottom = new Tile(mainScene, column, row + 1, "doorbottom", level);
    }
    /**
     * Opens door tiles by setting appropriate pictures
     */
    open() {
        this.doorTop.setFrame("Boulder#12");
        this.doorBottom.setFrame("Boulder#13");
        this.isOpen = true;
    }
}
//# sourceMappingURL=Door.js.map