import { ScoreBoard } from "./ScoreBoard.js";
export class ScoreScene extends Phaser.Scene {
    constructor() {
        super({
            key: "ScoreScene",
            active: true
        });
    }
    preload() {
        this.load.atlas('spritesheet1', 'assets/graphics/spritesheet.png', 'assets/graphics/spritesheet.json');
    }
    create() {
        this.scoreboard = new ScoreBoard(this);
        let mainScene = this.scene.get("MainScene");
        mainScene.onScoreSceneReady();
    }
    update(time, delta) {
    }
    getScoreBoard() {
        return this.scoreboard;
    }
}
//# sourceMappingURL=ScoreScene.js.map