export class WebSocketController {
    constructor(messageListener, onWebSocketReady) {
        this.messageListener = messageListener;
        this.connectionReady = false;
        let url = (window.location.protocol.startsWith("https") ? "wss://" : "ws://") + window.location.host;
        this.connection = new WebSocket(url);
        let that = this;
        this.connection.onopen = function () {
            that.connectionReady = true;
            if (onWebSocketReady != null) {
                onWebSocketReady(that);
            }
        };
        this.connection.onmessage = function (message) {
            try {
                var serverMessage = JSON.parse(message.data);
            }
            catch (e) {
                console.log('This doesn\'t look like a valid JSON: ', message.data);
                return;
            }
            that.messageListener.onMessage(serverMessage);
        };
    }
    send(message) {
        if (!this.connectionReady)
            return;
        this.connection.send(JSON.stringify(message));
    }
}
//# sourceMappingURL=WebSocketController.js.map