/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.Redo;
import commands.Undo;
import commands.baseclasses.AbstractCommand;
import java.util.LinkedList;

public class CommandManager {
    private final int maxHistoryLength = 100;
    private LinkedList<AbstractCommand> history = new LinkedList();
    private LinkedList<AbstractCommand> redoList = new LinkedList();

    public final void invokeCommand(AbstractCommand command) {
        if (command instanceof Undo) {
            this.undo();
            return;
        }
        if (command instanceof Redo) {
            this.redo();
            return;
        }
        if (command.doIt()) {
            this.addToHistory(command);
        } else {
            this.history.clear();
        }
        if (this.redoList.size() > 0) {
            this.redoList.clear();
        }
    }

    private void undo() {
        if (this.history.size() > 0) {
            AbstractCommand undoCmd = this.history.removeFirst();
            undoCmd.undoIt();
            this.redoList.addFirst(undoCmd);
        }
    }

    private void redo() {
        if (this.redoList.size() > 0) {
            AbstractCommand redoCmd = this.redoList.removeFirst();
            redoCmd.doIt();
            this.history.addFirst(redoCmd);
        }
    }

    private void addToHistory(AbstractCommand command) {
        this.history.addFirst(command);
        if (this.history.size() > 100) {
            this.history.removeLast();
        }
    }

    public final AbstractCommand getLastCommand() {
        if (this.history.size() > 0) {
            return this.history.getFirst();
        }
        return null;
    }

    public final void clearRedoList() {
        this.redoList.clear();
    }
}

