/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyDocument;
import document.MyPage;
import document.view.MyView;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import javax.swing.JOptionPane;
import util.language.Lang;

public class DeleteCurrrentPageCommand
extends AbstractCommand {
    private MyPage page;
    private int pageIndex;
    private PageViewPortController controller;

    public DeleteCurrrentPageCommand(PageViewPortController controller, MyPage page) {
        this.controller = controller;
        this.page = page;
        boolean removePagePossible = true;
        MyView view = controller.getView();
        if (view.isAutomaticZoomToFitPage()) {
            JOptionPane.showMessageDialog(controller.getPageScrollPaneController().getPageScrollPane(), Lang.get("Die einzige Seite in der Schnelleingabe kann nicht gel\u00f6scht werden."));
            removePagePossible = false;
        }
        if (view.getPages().size() <= 1) {
            JOptionPane.showMessageDialog(controller.getPageScrollPaneController().getPageScrollPane(), Lang.get("Mindestens eine Seite muss im Dokument vorhanden bleiben."));
            removePagePossible = false;
        }
        if (removePagePossible) {
            MyDocument document = controller.getDocument();
            this.pageIndex = view.getPages().indexOf(page);
            document.getCommandManager().invokeCommand(this);
        }
    }

    @Override
    public final boolean doIt() {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        this.controller.getView().removePage(this.page);
        this.controller.setMetrics();
        if (stateInfo.getMarkedObjects().getPage() == this.page) {
            stateInfo.clearMarkedObjects();
        }
        stateInfo.clearHandles();
        stateInfo.getHandlesOfMarkedObjects();
        this.controller.doRepaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        this.controller.getView().addPage(this.page, this.pageIndex);
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        stateInfo.clearHandles();
        stateInfo.getHandlesOfMarkedObjects();
        this.controller.setMetrics();
        this.controller.doRepaint();
        return false;
    }
}

