/*
 * Decompiled with CFR 0.152.
 */
package commands.changefillings;

import commands.baseclasses.AbstractCommand;
import document.MyFillableObject;
import document.MyFilling;
import document.MyGroup;
import document.MyObject;
import document.Renderable;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;

public class ChangeFillingAlphaCommand
extends AbstractCommand {
    private ArrayList<MyObject> objectsToChange = new ArrayList();
    private ArrayList<MyFilling> oldFillings = new ArrayList();
    private int newAlpha;

    public ChangeFillingAlphaCommand(MarkedObjectsAndHandles stateInfo, int pnewAlpha) {
        if (stateInfo.getMarkedObjects().size() > 0) {
            for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
                this.addObjects(object);
            }
            this.newAlpha = pnewAlpha;
            stateInfo.getMarkedObjects().getPage().getDocument().getCommandManager().invokeCommand(this);
        }
    }

    private void addObjects(MyObject object) {
        if (object.getType() == Renderable.ObjectType.group) {
            for (MyObject o : ((MyGroup)object).getObjects()) {
                this.addObjects(o);
            }
        }
        if (object instanceof MyFillableObject) {
            this.objectsToChange.add(object);
            this.oldFillings.add(((MyFillableObject)object).getFilling().getCopy());
        }
    }

    @Override
    public final boolean doIt() {
        for (MyObject object : this.objectsToChange) {
            ((MyFillableObject)object).getFilling().setAlpha(this.newAlpha);
        }
        return true;
    }

    @Override
    public final boolean undoIt() {
        int i = 0;
        while (i < this.objectsToChange.size()) {
            ((MyFillableObject)this.objectsToChange.get(i)).setFilling(this.oldFillings.get(i).getCopy());
            ++i;
        }
        return false;
    }
}

