/*
 * Decompiled with CFR 0.152.
 */
package commands.changelinestyles;

import commands.baseclasses.AbstractCommand;
import document.MyGroup;
import document.MyLineStyle;
import document.MyObject;
import document.Renderable;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;

public abstract class LineStylePreserveCommand
extends AbstractCommand {
    private ArrayList<MyObject> objectsToChange = new ArrayList();
    private ArrayList<MyLineStyle> oldLineStyles = new ArrayList();

    public final void preserveOldLineStyles(MarkedObjectsAndHandles stateInfo) {
        for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
            this.addObjects(object);
        }
    }

    private void addObjects(MyObject object) {
        if (object.getType() == Renderable.ObjectType.group) {
            for (MyObject o : ((MyGroup)object).getObjects()) {
                this.addObjects(o);
            }
        }
        if (object instanceof MyObject) {
            this.getObjectsToChange().add(object);
            this.getOldLineStyles().add(object.getLineStyle().getCopy());
        }
    }

    @Override
    public final boolean undoIt() {
        int i = 0;
        while (i < this.getObjectsToChange().size()) {
            MyObject object = this.getObjectsToChange().get(i);
            object.setLineStyle(this.getOldLineStyles().get(i).getCopy());
            ++i;
        }
        return false;
    }

    protected final void setObjectsToChange(ArrayList<MyObject> pobjectsToChange) {
        this.objectsToChange = pobjectsToChange;
    }

    protected final ArrayList<MyObject> getObjectsToChange() {
        return this.objectsToChange;
    }

    protected final void setOldLineStyles(ArrayList<MyLineStyle> poldLineStyles) {
        this.oldLineStyles = poldLineStyles;
    }

    protected final ArrayList<MyLineStyle> getOldLineStyles() {
        return this.oldLineStyles;
    }
}

